/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.matrixalgebra.decomposition.SingularValueDecomposition;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.exception.OutOfRangeException;

public class SolveByOrthogonalizing {
    private List<ModelEffect> myBaseModel;
    private List<double[]> myBasisVectors;
    private List<double[]> myData;
    private List<double[]> myOrthogonalizedData;
    private List<double[]> UColumns = null;
    private SingularValueDecomposition baseSvd = null;
    private static final double tol = 1.0E-10;

    private SolveByOrthogonalizing() {
    }

    public static SolveByOrthogonalizing getInstanceFromModel(List<ModelEffect> baseModel, List<double[]> dataList) {
        SolveByOrthogonalizing sbo = new SolveByOrthogonalizing();
        sbo.myBaseModel = baseModel;
        sbo.myData = dataList;
        DoubleMatrix[][] design = sbo.createDesignMatricesFromModel();
        sbo.computeBaseSvd(design);
        sbo.OrthogonalizeData();
        return sbo;
    }

    public static SolveByOrthogonalizing getInstanceFromVectors(List<double[]> basisVectors, List<double[]> dataList) {
        SolveByOrthogonalizing sbo = new SolveByOrthogonalizing();
        sbo.myBasisVectors = basisVectors;
        sbo.myData = dataList;
        sbo.computeBaseSvd(sbo.createDesignMatricesFromVectors());
        sbo.OrthogonalizeData();
        return sbo;
    }

    public Marker solveForR(Marker marker) {
        if (marker.vector2 == null) {
            return this.solveForR(marker.position(), marker.vector1());
        }
        return this.solveForR(marker.position(), marker.vector1(), marker.vector2);
    }

    public Marker solveForR(Position pos, double[] values) {
        double[] val1 = SolveByOrthogonalizing.center(values);
        double[] val2 = this.orthogonalizeByBase(val1);
        double[] val3 = SolveByOrthogonalizing.centerAndScale(val2);
        double[] orthogonalValues = SolveByOrthogonalizing.centerAndScale(this.orthogonalizeByBase(SolveByOrthogonalizing.center(values)));
        if (orthogonalValues == null) {
            double[] rValues = IntStream.range(0, this.myOrthogonalizedData.size()).mapToDouble(i -> Double.NaN).toArray();
            return new Marker(pos, rValues, 0);
        }
        double[] rValues = new double[this.myOrthogonalizedData.size()];
        int count = 0;
        for (double[] data : this.myOrthogonalizedData) {
            double ip = SolveByOrthogonalizing.innerProduct(data, orthogonalValues);
            rValues[count++] = ip * ip;
        }
        return new Marker(pos, rValues, 1);
    }

    public Marker solveForR(Position pos, double[] add, double[] dom) {
        if (dom == null) {
            return this.solveForR(pos, add);
        }
        double[] orthogonalAdd = this.orthogonalizeByBase(SolveByOrthogonalizing.center(add));
        double[] orthogonalDom = this.orthogonalizeByBase(SolveByOrthogonalizing.center(dom));
        double mult = SolveByOrthogonalizing.innerProduct(orthogonalAdd, orthogonalDom) / SolveByOrthogonalizing.innerProduct(orthogonalAdd, orthogonalAdd);
        int n = orthogonalDom.length;
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = i2;
            orthogonalDom[n2] = orthogonalDom[n2] - mult * orthogonalAdd[i2];
        }
        double[] v1 = SolveByOrthogonalizing.centerAndScale(orthogonalAdd);
        double[] v2 = SolveByOrthogonalizing.centerAndScale(orthogonalDom);
        if (v1 == null) {
            if (v2 == null) {
                double[] rValues = IntStream.range(0, this.myOrthogonalizedData.size()).mapToDouble(i -> Double.NaN).toArray();
                return new Marker(pos, rValues, 0);
            }
            double[] rValues = this.myOrthogonalizedData.stream().mapToDouble(d -> SolveByOrthogonalizing.innerProduct(d, v2)).map(d -> d * d).toArray();
            return new Marker(pos, rValues, 1);
        }
        if (v2 == null) {
            double[] rValues = this.myOrthogonalizedData.stream().mapToDouble(d -> SolveByOrthogonalizing.innerProduct(d, v1)).map(d -> d * d).toArray();
            return new Marker(pos, rValues, 1);
        }
        double[] rValues = this.myOrthogonalizedData.stream().mapToDouble(d -> {
            double r1 = SolveByOrthogonalizing.innerProduct(v1, d);
            double r2 = SolveByOrthogonalizing.innerProduct(v2, d);
            return r1 * r1 + r2 * r2;
        }).toArray();
        return new Marker(pos, rValues, 2);
    }

    private DoubleMatrix[][] createDesignMatricesFromModel() {
        DoubleMatrix[][] designMatrices = new DoubleMatrix[][]{(DoubleMatrix[])this.myBaseModel.stream().filter(a -> !a.getID().toString().toLowerCase().equals("mean")).map(me -> me.getX()).toArray(DoubleMatrix[]::new)};
        return designMatrices;
    }

    private DoubleMatrix[][] createDesignMatricesFromVectors() {
        DoubleMatrix[][] designMatrices = new DoubleMatrix[][]{(DoubleMatrix[])this.myBasisVectors.stream().map(d -> DoubleMatrixFactory.DEFAULT.make(((double[])d).length, 1, (double[])d)).toArray(DoubleMatrix[]::new)};
        return designMatrices;
    }

    private void computeBaseSvd(DoubleMatrix[][] designMatrices) {
        if (designMatrices[0].length == 0 || designMatrices[0][0] == null) {
            return;
        }
        DoubleMatrix X = DoubleMatrixFactory.DEFAULT.compose(designMatrices);
        int nrows = X.numberOfRows();
        double dblnrows = nrows;
        int ncols = X.numberOfColumns();
        for (int c = 0; c < ncols; ++c) {
            double mean = X.columnSum(c) / dblnrows;
            for (int r = 0; r < nrows; ++r) {
                X.set(r, c, X.get(r, c) - mean);
            }
        }
        this.baseSvd = X.getSingularValueDecomposition();
        DoubleMatrix U = this.baseSvd.getU(false);
        this.UColumns = new ArrayList<double[]>();
        int ncol = U.numberOfColumns();
        for (int i = 0; i < ncol; ++i) {
            this.UColumns.add(U.column(i).to1DArray());
        }
    }

    private void OrthogonalizeData() {
        this.myOrthogonalizedData = this.baseSvd == null ? this.myData.stream().map(d -> SolveByOrthogonalizing.centerAndScale(Arrays.copyOf(d, ((double[])d).length))).collect(Collectors.toList()) : this.myData.stream().map(d -> SolveByOrthogonalizing.center(Arrays.copyOf(d, ((double[])d).length))).map(d -> this.orthogonalizeByBase((double[])d)).map(d -> SolveByOrthogonalizing.centerAndScale(d)).collect(Collectors.toList());
    }

    private double[] orthogonalizeByBase(double[] vector) {
        if (this.baseSvd == null) {
            return Arrays.copyOf(vector, vector.length);
        }
        int nrows = vector.length;
        double[] result = Arrays.copyOf(vector, nrows);
        DoubleMatrix U = this.baseSvd.getU(false);
        int ncol = U.numberOfColumns();
        for (int i = 0; i < ncol; ++i) {
            double[] u = U.column(i).to1DArray();
            double ip = SolveByOrthogonalizing.innerProduct(vector, u);
            for (int j = 0; j < nrows; ++j) {
                int n = j;
                result[n] = result[n] - ip * u[j];
            }
        }
        return result;
    }

    public int baseDf() {
        int df = 1;
        if (this.baseSvd != null) {
            double[] singularValues = this.baseSvd.getSingularValues();
            int n = singularValues.length;
            for (int i = 0; i < n; ++i) {
                if (!(singularValues[i] > 1.0E-10)) continue;
                ++df;
            }
        }
        return df;
    }

    public static double innerProduct(double[] x, double[] y) {
        int n = x.length;
        double sumprod = 0.0;
        for (int i = 0; i < n; ++i) {
            sumprod += x[i] * y[i];
        }
        return sumprod;
    }

    public static double[] center(double[] values) {
        int n = values.length;
        double mean = Arrays.stream(values).sum() / (double)n;
        int i = 0;
        while (i < n) {
            int n2 = i++;
            values[n2] = values[n2] - mean;
        }
        return values;
    }

    public static double[] scale(double[] values) {
        int n = values.length;
        double divisor = Math.sqrt(SolveByOrthogonalizing.innerProduct(values, values));
        int i = 0;
        while (i < n) {
            int n2 = i++;
            values[n2] = values[n2] / divisor;
        }
        return values;
    }

    public static double[] centerAndScale(double[] values) {
        int n = values.length;
        double sum = 0.0;
        double sumsq = 0.0;
        for (int i = 0; i < n; ++i) {
            double val = values[i];
            sum += val;
        }
        double mean = sum / (double)n;
        for (int i = 0; i < n; ++i) {
            values[i] = values[i] - mean;
            sumsq += values[i] * values[i];
        }
        double divisor = Math.sqrt(sumsq);
        if (divisor < 1.0E-10) {
            return null;
        }
        int i = 0;
        while (i < n) {
            int n2 = i++;
            values[n2] = values[n2] / divisor;
        }
        return values;
    }

    public static double calculateFfromR2(double r2, double markerDf, double errorDf) {
        return r2 / (1.0 - r2) * errorDf / markerDf;
    }

    public static double calculateP(double F, double markerDf, double errorDf) {
        double p;
        if (!Double.isFinite(F)) {
            return Double.NaN;
        }
        try {
            p = LinearModelUtils.Ftest(F, markerDf, errorDf);
        }
        catch (Exception e) {
            p = Double.NaN;
        }
        return p;
    }

    public static double calculateR2Fromp(double alpha, double modelDf, double errorDf) {
        FDistribution fdist = new FDistribution(modelDf, errorDf);
        try {
            double p = 1.0 - alpha;
            double F = fdist.inverseCumulativeProbability(p);
            double Fme = F * modelDf / errorDf;
            return Fme / (1.0 + Fme);
        }
        catch (OutOfRangeException e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    public List<double[]> getOrthogonalizedData() {
        return this.myOrthogonalizedData;
    }

    public List<double[]> copyOrthogonalizedData() {
        return this.myOrthogonalizedData.stream().map(darray -> Arrays.copyOf(darray, ((double[])darray).length)).collect(Collectors.toList());
    }

    public List<double[]> getUColumns() {
        return this.UColumns;
    }

    public List<double[]> copyUColumns() {
        return this.UColumns.stream().map(darray -> Arrays.copyOf(darray, ((double[])darray).length)).collect(Collectors.toList());
    }

    public static class Marker {
        public final Position myPosition;
        public final double[] vector1;
        public final double[] vector2;
        public int df;

        public Marker(Position pos, double[] values, int df) {
            this.myPosition = pos;
            this.vector1 = values;
            this.vector2 = null;
            this.df = df;
        }

        public Marker(Position pos, double[] additive, double[] dominant, int df) {
            this.myPosition = pos;
            this.vector1 = additive;
            this.vector2 = dominant;
            this.df = df;
        }

        public Position position() {
            return this.myPosition;
        }

        public double[] vector1() {
            return this.vector1;
        }

        public double[] vector2() {
            return this.vector2;
        }

        public boolean hasTwoVectors() {
            return this.vector2 != null;
        }

        public int degreesOfFreedom() {
            if (this.vector2 == null) {
                return 1;
            }
            return 2;
        }
    }
}

