/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa;

import com.google.common.collect.ImmutableMultimap;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.AbstractTableReport;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.TableReport;
import org.apache.commons.codec.language.Metaphone;
import org.apache.commons.codec.language.Soundex;

public class IdentifierSynonymizer
extends AbstractTableReport
implements Serializable,
TableReport {
    ArrayList<TaxaList> taxaListSynonymized = new ArrayList();
    TaxaList tempTaxaList = null;
    private TaxaList referenceIDGroup;
    private int matchCount = 0;
    private int unmatchCount = 0;
    private int technique = 0;
    private String delimiter = "";
    private double globalMin = Double.POSITIVE_INFINITY;
    private double globalMax = Double.NEGATIVE_INFINITY;

    public IdentifierSynonymizer(TaxaList preferredTaxa, TaxaList[] alternateTaxaSets) {
        this.init2(preferredTaxa, alternateTaxaSets);
    }

    public IdentifierSynonymizer(TaxaList preferredTaxa, TaxaList[] alternateTaxaSets, int technique) {
        this.technique = technique;
        this.init2(preferredTaxa, alternateTaxaSets);
    }

    public IdentifierSynonymizer(TaxaList preferredTaxa, TaxaList[] alternateTaxaSets, int technique, String delimiter) {
        this.technique = technique;
        this.delimiter = delimiter;
        this.init2(preferredTaxa, alternateTaxaSets);
    }

    public IdentifierSynonymizer(TaxaList preferredTaxa, TaxaList alternateTaxa) {
        TaxaList[] alternateTaxaSets = new TaxaList[]{alternateTaxa};
        this.init2(preferredTaxa, alternateTaxaSets);
    }

    private void init2(TaxaList referenceTaxa, TaxaList[] alternateTaxaSets) {
        this.referenceIDGroup = referenceTaxa;
        ImmutableMultimap.Builder changeSynBuild = new ImmutableMultimap.Builder();
        for (TaxaList altTaxaList : alternateTaxaSets) {
            for (Taxon altTaxon : altTaxaList) {
                ArrayList<String> theBest = this.findBestMatch(altTaxon.getName(), referenceTaxa);
                if (theBest.size() == 1) {
                    String bs = theBest.get(0);
                    if (!bs.equals(altTaxon.getName())) {
                        changeSynBuild.put((Object)altTaxon.getName(), (Object)bs);
                    }
                    ++this.matchCount;
                    continue;
                }
                for (String score : theBest) {
                    changeSynBuild.put((Object)altTaxon.getName(), (Object)score);
                }
                ++this.unmatchCount;
            }
        }
        ImmutableMultimap changeSyn = changeSynBuild.build();
        for (TaxaList altTaxaList : alternateTaxaSets) {
            TaxaListBuilder tlb = new TaxaListBuilder();
            for (Taxon taxon : altTaxaList) {
                GeneralAnnotation ga = taxon.getAnnotation();
                Taxon.Builder tb = new Taxon.Builder(taxon.getName());
                Set<String> keys = ga.getAnnotationKeys();
                for (String key : keys) {
                    String[] values;
                    if (key.equals("SYNONYM")) continue;
                    for (String value : values = ga.getTextAnnotation(key)) {
                        tb.addAnno(key, value);
                    }
                }
                if (changeSyn.keySet().contains((Object)taxon.getName())) {
                    for (String entry : changeSyn.get((Object)taxon.getName())) {
                        tb.addAnno("SYNONYM", entry);
                    }
                }
                tlb.add(tb.build());
            }
            this.taxaListSynonymized.add(tlb.build());
        }
        this.resetTempTaxaList();
        System.out.println(this.toString());
    }

    public TaxaList getTaxaList() {
        return this.taxaListSynonymized.get(0);
    }

    public int getTechnique() {
        return this.technique;
    }

    public void setGlobalMax(double max) {
        this.globalMax = max;
    }

    private ArrayList<String> findBestMatch(String unmatchedString) {
        ArrayList<String> bestMatches = new ArrayList<String>();
        double maxScore = -1.0;
        double minScore = Double.POSITIVE_INFINITY;
        boolean ignoreCase = true;
        boolean ignoreWhite = false;
        boolean ignorePunc = false;
        for (int levelOfRestriction = 0; bestMatches.size() != 1 && levelOfRestriction < 4; ++levelOfRestriction) {
            switch (levelOfRestriction) {
                case 1: {
                    ignoreCase = true;
                    break;
                }
                case 2: {
                    ignoreWhite = true;
                    break;
                }
                case 3: {
                    ignorePunc = true;
                }
            }
            for (int i = 0; i < this.referenceIDGroup.numberOfTaxa(); ++i) {
                double sm = this.technique == 7 ? IdentifierSynonymizer.getScore(this.referenceIDGroup.taxaName(i), unmatchedString, ignoreCase, ignoreWhite, ignorePunc, this.technique, this.delimiter) : IdentifierSynonymizer.getScore(this.referenceIDGroup.taxaName(i), unmatchedString, ignoreCase, ignoreWhite, ignorePunc, this.technique);
                if (sm < minScore) {
                    bestMatches.clear();
                    bestMatches.add(this.referenceIDGroup.taxaName(i));
                    minScore = sm;
                    if (!(minScore < this.globalMin)) continue;
                    System.out.println(minScore);
                    this.globalMin = minScore;
                    continue;
                }
                if (sm != minScore) continue;
                bestMatches.add(this.referenceIDGroup.taxaName(i));
            }
            if (!(minScore > this.globalMax)) continue;
            this.globalMax = minScore;
        }
        return bestMatches;
    }

    public ArrayList<String> findBestMatch(String taxaName, TaxaList referenceTaxa) {
        ArrayList<String> bestMatches = new ArrayList<String>();
        double maxScore = -1.0;
        double minScore = Double.POSITIVE_INFINITY;
        boolean ignoreCase = true;
        boolean ignoreWhite = false;
        boolean ignorePunc = false;
        for (int levelOfRestriction = 0; bestMatches.size() != 1 && levelOfRestriction < 4; ++levelOfRestriction) {
            switch (levelOfRestriction) {
                case 1: {
                    ignoreCase = true;
                    break;
                }
                case 2: {
                    ignoreWhite = true;
                    break;
                }
                case 3: {
                    ignorePunc = true;
                }
            }
            for (Taxon refTaxa : referenceTaxa) {
                double sm = this.technique == 7 ? IdentifierSynonymizer.getScore(refTaxa.getName(), taxaName, ignoreCase, ignoreWhite, ignorePunc, this.technique, this.delimiter) : IdentifierSynonymizer.getScore(refTaxa.getName(), taxaName, ignoreCase, ignoreWhite, ignorePunc, this.technique);
                if (sm < minScore) {
                    bestMatches.clear();
                    bestMatches.add(refTaxa.getName());
                    minScore = sm;
                    if (!(minScore < this.globalMin)) continue;
                    this.globalMin = minScore;
                    continue;
                }
                if (sm != minScore || bestMatches.contains(refTaxa.getName())) continue;
                bestMatches.add(refTaxa.getName());
            }
            if (!(minScore > this.globalMax)) continue;
            this.globalMax = minScore;
        }
        System.out.println("GlobalMin" + this.globalMin);
        System.out.println("GlobalMax" + this.globalMax);
        return bestMatches;
    }

    public ArrayList<String> findOrderedMatches(String unmatchedString, int levelOfRestriction) {
        TreeMap<Double, String> theSortMap = new TreeMap<Double, String>();
        boolean ignoreCase = false;
        boolean ignoreWhite = false;
        boolean ignorePunc = false;
        if (levelOfRestriction > 0) {
            ignoreCase = true;
        }
        if (levelOfRestriction > 1) {
            ignoreWhite = true;
        }
        if (levelOfRestriction > 2) {
            ignorePunc = true;
        }
        for (int i = 0; i < this.referenceIDGroup.numberOfTaxa(); ++i) {
            double sm = this.technique == 7 ? IdentifierSynonymizer.getScore(this.referenceIDGroup.taxaName(i), unmatchedString, ignoreCase, ignoreWhite, ignorePunc, this.technique, this.delimiter) : IdentifierSynonymizer.getScore(this.referenceIDGroup.taxaName(i), unmatchedString, ignoreCase, ignoreWhite, ignorePunc, this.technique);
            sm = 1.0 - (sm - this.globalMin) / (this.globalMax - this.globalMin);
            theSortMap.put(1.0 - sm - (double)i / 100000.0, this.referenceIDGroup.taxaName(i));
        }
        return new ArrayList<String>(theSortMap.values());
    }

    public static double getScore(String s1, String s2, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc, int technique) {
        double score = 0.0;
        if (s1.equals(s2)) {
            return score;
        }
        if (technique == 0) {
            score = 1.0 - IdentifierSynonymizer.scoreMatch(s1, s2, ignoreCase, ignoreWhite, ignorePunc);
        } else if (technique == 1) {
            score = IdentifierSynonymizer.editDistanceScoreMatch(s1, s2, ignoreCase, ignoreWhite, ignorePunc);
        } else if (technique == 2) {
            score = IdentifierSynonymizer.dtwDist(s1, s2, "hamming", ignoreCase, true, ignorePunc);
        } else if (technique == 3) {
            score = IdentifierSynonymizer.dtwDist(s1, s2, "key", ignoreCase, true, ignorePunc);
        } else if (technique == 4) {
            score = IdentifierSynonymizer.hammingDistSoundex(s1, s2, ignoreCase, ignoreWhite, ignorePunc);
        } else if (technique == 5) {
            score = 1.0 - IdentifierSynonymizer.diceWithMetaphone(s1, s2, ignoreCase, ignoreWhite, ignorePunc);
        } else if (technique == 6) {
            score = IdentifierSynonymizer.editWithMetaphone(s1, s2, ignoreCase, ignoreWhite, ignorePunc);
        }
        return score;
    }

    public static double getScore(String s1, String s2, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc, int technique, String delimiter) {
        double score = 0.0;
        if (s1.equals(s2)) {
            return score;
        }
        if (technique == 0) {
            score = 1.0 - IdentifierSynonymizer.scoreMatch(s1, s2, ignoreCase, ignoreWhite, ignorePunc);
        } else if (technique == 1) {
            score = IdentifierSynonymizer.editDistanceScoreMatch(s1, s2, ignoreCase, ignoreWhite, ignorePunc);
        } else if (technique == 2) {
            score = IdentifierSynonymizer.dtwDist(s1, s2, "hamming", ignoreCase, true, ignorePunc);
        } else if (technique == 3) {
            score = IdentifierSynonymizer.dtwDist(s1, s2, "key", ignoreCase, true, ignorePunc);
        } else if (technique == 4) {
            score = IdentifierSynonymizer.hammingDistSoundex(s1, s2, ignoreCase, ignoreWhite, ignorePunc);
        } else if (technique == 5) {
            score = 1.0 - IdentifierSynonymizer.diceWithMetaphone(s1, s2, ignoreCase, ignoreWhite, ignorePunc);
        } else if (technique == 6) {
            score = IdentifierSynonymizer.editWithMetaphone(s1, s2, ignoreCase, ignoreWhite, ignorePunc);
        } else if (technique == 7) {
            score = 1.0 - IdentifierSynonymizer.delimiterDistance(s1, s2, ignoreCase, ignoreWhite, ignorePunc, delimiter);
        }
        return score;
    }

    public static double hammingDistSoundex(String s1, String s2, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        s1 = IdentifierSynonymizer.soundex2(s1, true, true, true);
        s2 = IdentifierSynonymizer.soundex2(s2, true, true, true);
        int sum = 0;
        for (int i = 0; i < s1.length(); ++i) {
            sum += IdentifierSynonymizer.hammingDist(s1.charAt(i), s2.charAt(i));
        }
        return sum;
    }

    public static double diceWithMetaphone(String s1, String s2, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        s1 = IdentifierSynonymizer.metaphone2(s1, true, true, true);
        s2 = IdentifierSynonymizer.metaphone2(s2, true, true, true);
        return IdentifierSynonymizer.scoreMatch(s1, s2, ignoreCase, ignoreWhite, ignorePunc);
    }

    public static double editWithMetaphone(String s1, String s2, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        s1 = IdentifierSynonymizer.metaphone2(s1, true, true, true);
        s2 = IdentifierSynonymizer.metaphone2(s2, true, true, true);
        return IdentifierSynonymizer.editDistanceScoreMatch(s1, s2, ignoreCase, ignoreWhite, ignorePunc);
    }

    private double scoreMatch2(String s1, String s2, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        int score = 0;
        s1 = IdentifierSynonymizer.cleanName(s1, ignoreCase, ignoreWhite, ignorePunc);
        s2 = IdentifierSynonymizer.cleanName(s2, ignoreCase, ignoreWhite, ignorePunc);
        block0: for (int c1 = 0; c1 < s1.length() - 1; ++c1) {
            for (int c2 = 0; c2 < s2.length() - 1; ++c2) {
                if (s1.charAt(c1) != s2.charAt(c2) || s1.charAt(c1 + 1) != s2.charAt(c2 + 1)) continue;
                ++score;
                continue block0;
            }
        }
        double sm = 2.0 * (double)score / (double)(s1.length() + s2.length() - 2);
        return sm;
    }

    public static double scoreMatch(String s1, String s2, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        s1 = IdentifierSynonymizer.cleanName(s1, ignoreCase, ignoreWhite, ignorePunc);
        s2 = IdentifierSynonymizer.cleanName(s2, ignoreCase, ignoreWhite, ignorePunc);
        ArrayList<String> pairs1 = IdentifierSynonymizer.letterPairs(s1);
        ArrayList<String> pairs2 = IdentifierSynonymizer.letterPairs(s2);
        int intersection = 0;
        int union = pairs1.size() + pairs2.size();
        block0: for (int i = 0; i < pairs1.size(); ++i) {
            String pair1 = pairs1.get(i);
            for (int j = 0; j < pairs2.size(); ++j) {
                String pair2 = pairs2.get(j);
                if (!pair1.equals(pair2)) continue;
                ++intersection;
                pairs2.remove(j);
                continue block0;
            }
        }
        return 2.0 * (double)intersection / (double)union;
    }

    public static double editDistanceScoreMatch(String s1, String s2, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        int i;
        s1 = IdentifierSynonymizer.cleanName(s1, ignoreCase, ignoreWhite, ignorePunc);
        s2 = IdentifierSynonymizer.cleanName(s2, ignoreCase, ignoreWhite, ignorePunc);
        if (s1.equals("")) {
            return s2.length();
        }
        if (s2.equals("")) {
            return s1.length();
        }
        double[][] editMatrix = new double[s1.length()][s2.length()];
        editMatrix[0][0] = s1.charAt(0) == s2.charAt(0) ? 0.0 : 1.0;
        for (i = 1; i < editMatrix.length; ++i) {
            editMatrix[i][0] = s1.charAt(i) == s2.charAt(0) ? editMatrix[i - 1][0] : editMatrix[i - 1][0] + 1.0;
        }
        for (i = 1; i < editMatrix[0].length; ++i) {
            editMatrix[0][i] = s1.charAt(0) == s2.charAt(i) ? editMatrix[0][i - 1] : editMatrix[0][i - 1] + 1.0;
        }
        for (i = 1; i < editMatrix.length; ++i) {
            for (int j = 1; j < editMatrix[i].length; ++j) {
                if (s1.charAt(i) == s2.charAt(j)) {
                    editMatrix[i][j] = editMatrix[i - 1][j - 1];
                    continue;
                }
                double diagCost = editMatrix[i - 1][j - 1];
                double upCost = editMatrix[i - 1][j];
                double leftCost = editMatrix[i][j - 1];
                editMatrix[i][j] = diagCost <= upCost && diagCost <= leftCost ? diagCost + 1.0 : (upCost <= leftCost && upCost <= diagCost ? upCost + 1.0 : leftCost + 1.0);
            }
        }
        return editMatrix[editMatrix.length - 1][editMatrix[editMatrix.length - 1].length - 1];
    }

    public static String metaphone2(String s1, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        if ((s1 = IdentifierSynonymizer.cleanName(s1, true, true, true)).equals("")) {
            return "";
        }
        ArrayList<String> parsed = new ArrayList<String>();
        String current = "";
        boolean digitMode = false;
        if (Character.isDigit(s1.charAt(0))) {
            current = current + s1.charAt(0);
            digitMode = true;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (Character.isDigit(s1.charAt(i)) && !digitMode) {
                parsed.add(current);
                current = "" + s1.charAt(i);
                digitMode = true;
                continue;
            }
            if (!Character.isDigit(s1.charAt(i)) && digitMode) {
                parsed.add(current);
                current = "" + s1.charAt(i);
                digitMode = false;
                continue;
            }
            current = current + s1.charAt(i);
        }
        parsed.add(current);
        Metaphone metaphone = new Metaphone();
        String encodedString = "";
        for (int i = 0; i < parsed.size(); ++i) {
            encodedString = !Character.isDigit(((String)parsed.get(i)).charAt(0)) ? encodedString + metaphone.encode((String)parsed.get(i)) : encodedString + (String)parsed.get(i);
        }
        return encodedString;
    }

    public static String soundex2(String s1, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        if ((s1 = IdentifierSynonymizer.cleanName(s1, true, true, true)).equals("")) {
            return "1abcd";
        }
        Soundex soundex = new Soundex();
        return soundex.soundex(s1);
    }

    private static int keyboardDist(char firstChar, char secondChar) {
        HashMap<Character, Integer[]> map = new HashMap<Character, Integer[]>();
        map.put(Character.valueOf('`'), new Integer[]{0, 0});
        map.put(Character.valueOf('~'), new Integer[]{0, 0});
        map.put(Character.valueOf('1'), new Integer[]{0, 1});
        map.put(Character.valueOf('!'), new Integer[]{0, 1});
        map.put(Character.valueOf('2'), new Integer[]{0, 2});
        map.put(Character.valueOf('@'), new Integer[]{0, 2});
        map.put(Character.valueOf('3'), new Integer[]{0, 3});
        map.put(Character.valueOf('#'), new Integer[]{0, 3});
        map.put(Character.valueOf('4'), new Integer[]{0, 4});
        map.put(Character.valueOf('$'), new Integer[]{0, 4});
        map.put(Character.valueOf('5'), new Integer[]{0, 5});
        map.put(Character.valueOf('%'), new Integer[]{0, 5});
        map.put(Character.valueOf('6'), new Integer[]{0, 6});
        map.put(Character.valueOf('^'), new Integer[]{0, 6});
        map.put(Character.valueOf('7'), new Integer[]{0, 7});
        map.put(Character.valueOf('&'), new Integer[]{0, 7});
        map.put(Character.valueOf('8'), new Integer[]{0, 8});
        map.put(Character.valueOf('*'), new Integer[]{0, 8});
        map.put(Character.valueOf('9'), new Integer[]{0, 9});
        map.put(Character.valueOf('('), new Integer[]{0, 9});
        map.put(Character.valueOf('0'), new Integer[]{0, 10});
        map.put(Character.valueOf(')'), new Integer[]{0, 10});
        map.put(Character.valueOf('-'), new Integer[]{0, 11});
        map.put(Character.valueOf('_'), new Integer[]{0, 11});
        map.put(Character.valueOf('='), new Integer[]{0, 12});
        map.put(Character.valueOf('+'), new Integer[]{0, 12});
        map.put(Character.valueOf('q'), new Integer[]{1, 1});
        map.put(Character.valueOf('Q'), new Integer[]{1, 1});
        map.put(Character.valueOf('w'), new Integer[]{1, 2});
        map.put(Character.valueOf('W'), new Integer[]{1, 2});
        map.put(Character.valueOf('e'), new Integer[]{1, 3});
        map.put(Character.valueOf('E'), new Integer[]{1, 3});
        map.put(Character.valueOf('r'), new Integer[]{1, 4});
        map.put(Character.valueOf('R'), new Integer[]{1, 4});
        map.put(Character.valueOf('t'), new Integer[]{1, 5});
        map.put(Character.valueOf('T'), new Integer[]{1, 5});
        map.put(Character.valueOf('y'), new Integer[]{1, 6});
        map.put(Character.valueOf('Y'), new Integer[]{1, 6});
        map.put(Character.valueOf('u'), new Integer[]{1, 7});
        map.put(Character.valueOf('U'), new Integer[]{1, 7});
        map.put(Character.valueOf('i'), new Integer[]{1, 8});
        map.put(Character.valueOf('I'), new Integer[]{1, 8});
        map.put(Character.valueOf('o'), new Integer[]{1, 9});
        map.put(Character.valueOf('O'), new Integer[]{1, 9});
        map.put(Character.valueOf('p'), new Integer[]{1, 10});
        map.put(Character.valueOf('P'), new Integer[]{1, 10});
        map.put(Character.valueOf('['), new Integer[]{1, 11});
        map.put(Character.valueOf('{'), new Integer[]{1, 11});
        map.put(Character.valueOf(']'), new Integer[]{1, 12});
        map.put(Character.valueOf('}'), new Integer[]{1, 12});
        map.put(Character.valueOf('\\'), new Integer[]{1, 13});
        map.put(Character.valueOf('|'), new Integer[]{1, 13});
        map.put(Character.valueOf('a'), new Integer[]{2, 1});
        map.put(Character.valueOf('A'), new Integer[]{2, 1});
        map.put(Character.valueOf('s'), new Integer[]{2, 2});
        map.put(Character.valueOf('S'), new Integer[]{2, 2});
        map.put(Character.valueOf('d'), new Integer[]{2, 3});
        map.put(Character.valueOf('D'), new Integer[]{2, 3});
        map.put(Character.valueOf('f'), new Integer[]{2, 4});
        map.put(Character.valueOf('F'), new Integer[]{2, 4});
        map.put(Character.valueOf('g'), new Integer[]{2, 5});
        map.put(Character.valueOf('G'), new Integer[]{2, 5});
        map.put(Character.valueOf('h'), new Integer[]{2, 6});
        map.put(Character.valueOf('H'), new Integer[]{2, 6});
        map.put(Character.valueOf('j'), new Integer[]{2, 7});
        map.put(Character.valueOf('J'), new Integer[]{2, 7});
        map.put(Character.valueOf('k'), new Integer[]{2, 8});
        map.put(Character.valueOf('K'), new Integer[]{2, 8});
        map.put(Character.valueOf('l'), new Integer[]{2, 9});
        map.put(Character.valueOf('L'), new Integer[]{2, 9});
        map.put(Character.valueOf(';'), new Integer[]{2, 10});
        map.put(Character.valueOf(':'), new Integer[]{2, 10});
        map.put(Character.valueOf('\''), new Integer[]{2, 11});
        map.put(Character.valueOf('\"'), new Integer[]{2, 11});
        map.put(Character.valueOf('z'), new Integer[]{3, 1});
        map.put(Character.valueOf('Z'), new Integer[]{3, 1});
        map.put(Character.valueOf('x'), new Integer[]{3, 2});
        map.put(Character.valueOf('X'), new Integer[]{3, 2});
        map.put(Character.valueOf('c'), new Integer[]{3, 3});
        map.put(Character.valueOf('C'), new Integer[]{3, 3});
        map.put(Character.valueOf('v'), new Integer[]{3, 4});
        map.put(Character.valueOf('V'), new Integer[]{3, 4});
        map.put(Character.valueOf('b'), new Integer[]{3, 5});
        map.put(Character.valueOf('B'), new Integer[]{3, 5});
        map.put(Character.valueOf('n'), new Integer[]{3, 6});
        map.put(Character.valueOf('N'), new Integer[]{3, 6});
        map.put(Character.valueOf('m'), new Integer[]{3, 7});
        map.put(Character.valueOf('M'), new Integer[]{3, 7});
        map.put(Character.valueOf(','), new Integer[]{3, 8});
        map.put(Character.valueOf('<'), new Integer[]{3, 8});
        map.put(Character.valueOf('.'), new Integer[]{3, 9});
        map.put(Character.valueOf('>'), new Integer[]{3, 9});
        map.put(Character.valueOf('/'), new Integer[]{3, 10});
        map.put(Character.valueOf('?'), new Integer[]{3, 10});
        Integer[] coords1 = (Integer[])map.get(Character.valueOf(firstChar));
        Integer[] coords2 = (Integer[])map.get(Character.valueOf(secondChar));
        return Math.abs(coords1[0] - coords2[0]) + Math.abs(coords1[1] - coords2[1]);
    }

    private static int hammingDist(char firstChar, char secondChar) {
        if (firstChar == secondChar) {
            return 0;
        }
        return 1;
    }

    private static double dtwDist(String str1, String str2, String distMeas, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        int i;
        int i2;
        str1 = IdentifierSynonymizer.cleanName(str1, ignoreCase, ignoreWhite, ignorePunc);
        str2 = IdentifierSynonymizer.cleanName(str2, ignoreCase, ignoreWhite, ignorePunc);
        double[][] costMat = new double[str1.length() + 1][str2.length() + 1];
        for (i2 = 0; i2 < costMat.length; ++i2) {
            costMat[i2][0] = Double.POSITIVE_INFINITY;
        }
        for (i2 = 0; i2 < costMat[0].length; ++i2) {
            costMat[0][i2] = Double.POSITIVE_INFINITY;
        }
        double currDist = 0.0;
        if (distMeas.equals("key")) {
            costMat[1][1] = IdentifierSynonymizer.keyboardDist(str1.charAt(0), str2.charAt(0));
        } else if (distMeas.equals("hamming")) {
            costMat[1][1] = IdentifierSynonymizer.hammingDist(str1.charAt(0), str2.charAt(0));
        }
        for (i = 2; i < costMat[1].length; ++i) {
            if (distMeas.equals("key")) {
                costMat[1][i] = costMat[1][i - 1] + (double)IdentifierSynonymizer.keyboardDist(str1.charAt(0), str2.charAt(i - 1));
                continue;
            }
            if (!distMeas.equals("hamming")) continue;
            costMat[1][i] = costMat[1][i - 1] + (double)IdentifierSynonymizer.hammingDist(str1.charAt(0), str2.charAt(i - 1));
        }
        for (i = 2; i < costMat.length; ++i) {
            if (distMeas.equals("key")) {
                costMat[i][1] = costMat[i - 1][1] + (double)IdentifierSynonymizer.keyboardDist(str1.charAt(i - 1), str2.charAt(0));
                continue;
            }
            if (!distMeas.equals("hamming")) continue;
            costMat[i][1] = costMat[i - 1][1] + (double)IdentifierSynonymizer.hammingDist(str1.charAt(i - 1), str2.charAt(0));
        }
        for (i = 2; i < costMat.length; ++i) {
            for (int j = 2; j < costMat[i].length; ++j) {
                currDist = 0.0;
                if (distMeas.equals("key")) {
                    currDist = IdentifierSynonymizer.keyboardDist(str1.charAt(i - 1), str2.charAt(j - 1));
                } else if (distMeas.equals("hamming")) {
                    currDist = IdentifierSynonymizer.hammingDist(str1.charAt(i - 1), str2.charAt(j - 1));
                }
                costMat[i][j] = costMat[i - 1][j - 1] < costMat[i - 1][j] && costMat[i - 1][j - 1] < costMat[i][j - 1] ? costMat[i - 1][j - 1] + currDist : (costMat[i - 1][j] < costMat[i - 1][j - 1] && costMat[i - 1][j] < costMat[i][j - 1] ? costMat[i - 1][j] + currDist : costMat[i][j - 1] + currDist);
            }
        }
        return costMat[costMat.length - 1][costMat[costMat.length - 1].length - 1];
    }

    private static double subSetDist(String str1, String str2, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        str1 = IdentifierSynonymizer.cleanName(str1, ignoreCase, ignoreWhite, ignorePunc);
        str2 = IdentifierSynonymizer.cleanName(str2, ignoreCase, ignoreWhite, ignorePunc);
        double distance = 0.0;
        int length = str1.length() > str2.length() ? str2.length() : str1.length();
        int errorCount = 0;
        for (int i = 0; i < length; ++i) {
            if (str1.charAt(i) == str2.charAt(i)) continue;
            ++errorCount;
        }
        distance = (double)errorCount / (double)length;
        return distance;
    }

    private static double delimiterDistance(String str1, String str2, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc, String delimiter) {
        String[] str2Split;
        double distance = 0.0;
        String[] str1Split = str1.split(delimiter);
        if (str1Split.length == (str2Split = str2.split(delimiter)).length) {
            for (int i = 0; i < str1Split.length; ++i) {
                distance += IdentifierSynonymizer.scoreMatch(str1Split[i], str2Split[i], ignoreCase, ignoreWhite, ignorePunc);
            }
            return distance /= (double)str1Split.length;
        }
        if (str1Split.length < str2Split.length) {
            String[] temp = str1Split;
            str1Split = str2Split;
            str2Split = temp;
        }
        for (int i = 0; i < str1Split.length - str2Split.length; ++i) {
            double currDist = 0.0;
            for (int j = 0; j < str2Split.length; ++j) {
                currDist += IdentifierSynonymizer.scoreMatch(str1Split[i + j], str2Split[j], ignoreCase, ignoreWhite, ignorePunc);
            }
            if (!((currDist /= (double)str2Split.length) > distance)) continue;
            distance = currDist;
        }
        return distance;
    }

    private static ArrayList<String> letterPairs(String str) {
        ArrayList<String> allPairs = new ArrayList<String>();
        for (int i = 0; i < str.length() - 1; ++i) {
            allPairs.add(str.substring(i, i + 2));
        }
        return allPairs;
    }

    private static String cleanName(String s, boolean ignoreCase, boolean ignoreWhite, boolean ignorePunc) {
        if (ignoreCase) {
            s = s.toUpperCase();
        }
        if (ignoreWhite) {
            s.replaceAll("\\s", "");
        }
        if (ignorePunc) {
            s = s.replaceAll("[^a-zA-Z0-9]", "");
        }
        return s;
    }

    public void changeAlignmentIdentifiers(TaxaList alternateIdGroups) {
        TaxaList[] aidg = new TaxaList[]{alternateIdGroups};
        this.changeAlignmentIdentifiers(aidg[0]);
    }

    public String toString() {
        String s = "Synonym Table\n";
        int counter = 0;
        for (TaxaList tl : this.taxaListSynonymized) {
            s = s + "SynonymFile " + counter + ":\n";
            for (Taxon tx : tl) {
                s = s + "Name: " + tx.getName() + ", Synonyms: ";
                for (String syn : tx.getAnnotation().getTextAnnotation("SYNONYM")) {
                    s = s + syn + ", ";
                }
                s = s + "\n";
            }
            ++counter;
        }
        return s;
    }

    public void deleteByThreshold(double threshold) {
        ImmutableMultimap.Builder removeBuilder = new ImmutableMultimap.Builder();
        for (Taxon tx : this.tempTaxaList) {
            String taxonName = tx.getName();
            for (String synName : tx.getAnnotation().getTextAnnotation("SYNONYM")) {
                double score = 0.0;
                score = this.technique == 7 ? IdentifierSynonymizer.getScore(taxonName, synName, true, false, false, this.technique, this.delimiter) : IdentifierSynonymizer.getScore(taxonName, synName, true, false, false, this.technique);
                if (this.technique == 4) {
                    this.globalMax = 4.0;
                }
                if (!((score = 1.0 - (score - this.globalMin) / (this.globalMax - this.globalMin)) < threshold)) continue;
                removeBuilder.put((Object)taxonName, (Object)synName);
            }
        }
        ImmutableMultimap removeMap = removeBuilder.build();
        TaxaListBuilder tlb = new TaxaListBuilder();
        for (Taxon tx : this.tempTaxaList) {
            GeneralAnnotation ga = tx.getAnnotation();
            Taxon.Builder tb = new Taxon.Builder(tx.getName());
            Set<String> keys = ga.getAnnotationKeys();
            for (String key : keys) {
                String[] values;
                if (key.equals("SYNONYM")) continue;
                for (String value : values = ga.getTextAnnotation(key)) {
                    tb.addAnno(key, value);
                }
            }
            if (removeMap.keySet().contains((Object)tx.getName())) {
                for (String value : ga.getTextAnnotation("SYNONYM")) {
                    if (removeMap.get((Object)tx.getName()).contains((Object)value)) continue;
                    tb.addAnno("SYNONYM", value);
                }
            } else {
                for (String value : ga.getTextAnnotation("SYNONYM")) {
                    tb.addAnno("SYNONYM", value);
                }
            }
            tlb.add(tb.build());
        }
        this.tempTaxaList = tlb.build();
    }

    public Object[] getRealNames() {
        Object[] idArray = new Object[this.referenceIDGroup.numberOfTaxa()];
        for (int i = 0; i < this.referenceIDGroup.numberOfTaxa(); ++i) {
            idArray[i] = ((Taxon)this.referenceIDGroup.get(i)).toString();
        }
        return idArray;
    }

    public void report(PrintWriter out) {
        out.println("Synonym Table");
        out.println(this.matchCount + " unique matches");
        out.println(this.unmatchCount + " multiple matches:");
    }

    @Override
    public Object[] getTableColumnNames() {
        Object[] cn = new String[]{"TaxaName", "Synonyms", "MatchScore"};
        return cn;
    }

    @Override
    public Object[] getRow(long rowLong) {
        int row = (int)rowLong;
        Object[] data = new Object[3];
        TaxaList tl = this.tempTaxaList;
        Taxon tx = (Taxon)tl.get(row);
        data[0] = tx.getName();
        String synString = "";
        String firstMatch = "";
        boolean first = true;
        for (String syn : tx.getAnnotation().getTextAnnotation("SYNONYM")) {
            synString = synString + syn + ",";
            if (!first) continue;
            firstMatch = syn;
            first = false;
        }
        data[2] = "";
        if (firstMatch.equals("")) {
            data[1] = "";
            data[2] = "1.0";
        } else {
            data[1] = synString.substring(0, synString.length() - 1);
            if (this.technique == 4) {
                this.globalMax = 4.0;
            }
            data[2] = this.technique == 0 ? "" + IdentifierSynonymizer.scoreMatch("" + data[0], "" + firstMatch, true, false, false) : (this.technique == 5 ? "" + (1.0 - IdentifierSynonymizer.getScore("" + data[0], "" + firstMatch, true, false, false, this.technique)) : (this.technique == 7 ? "" + (1.0 - IdentifierSynonymizer.getScore("" + data[0], "" + firstMatch, true, false, false, this.technique, this.delimiter)) : (1.0 - (IdentifierSynonymizer.getScore("" + data[0], "" + firstMatch, true, false, false, this.technique) - this.globalMin) / (this.globalMax - this.globalMin) < 0.0 ? (1.0 - (IdentifierSynonymizer.getScore("" + data[0], "" + firstMatch, true, true, false, this.technique) - this.globalMin) / (this.globalMax - this.globalMin) < 0.0 ? (1.0 - (IdentifierSynonymizer.getScore("" + data[0], "" + firstMatch, true, true, true, this.technique) - this.globalMin) / (this.globalMax - this.globalMin) < 0.0 ? "0.0" : "" + (1.0 - (IdentifierSynonymizer.getScore("" + data[0], "" + firstMatch, true, true, true, this.technique) - this.globalMin) / (this.globalMax - this.globalMin))) : "" + (1.0 - (IdentifierSynonymizer.getScore("" + data[0], "" + firstMatch, true, true, false, this.technique) - this.globalMin) / (this.globalMax - this.globalMin))) : "" + (1.0 - (IdentifierSynonymizer.getScore("" + data[0], "" + firstMatch, true, false, false, this.technique) - this.globalMin) / (this.globalMax - this.globalMin)))));
        }
        return data;
    }

    public void resetTempTaxaList() {
        TaxaListBuilder tlb = new TaxaListBuilder();
        for (Taxon tx : this.taxaListSynonymized.get(0)) {
            tlb.add(tx);
        }
        this.tempTaxaList = tlb.build();
    }

    public void saveTempTaxaList() {
        this.taxaListSynonymized.set(0, this.tempTaxaList);
        this.resetTempTaxaList();
    }

    public void removeSynonyms(int rowNumber) {
        TaxaListBuilder tlb = new TaxaListBuilder();
        int rowCounter = 0;
        for (Taxon tx : this.tempTaxaList) {
            if (rowNumber == rowCounter) {
                GeneralAnnotation ga = tx.getAnnotation();
                Taxon.Builder tb = new Taxon.Builder(tx.getName());
                Set<String> keys = ga.getAnnotationKeys();
                for (String key : keys) {
                    String[] values;
                    if (key.equals("SYNONYM")) continue;
                    for (String value : values = ga.getTextAnnotation(key)) {
                        tb.addAnno(key, value);
                    }
                }
                tlb.add(tb.build());
            } else {
                tlb.add(tx);
            }
            ++rowCounter;
        }
        this.tempTaxaList = tlb.build();
    }

    public void updateSynonym(int rowNumber, String newName) {
        TaxaListBuilder tlb = new TaxaListBuilder();
        int rowCounter = 0;
        for (Taxon tx : this.tempTaxaList) {
            if (rowNumber == rowCounter) {
                GeneralAnnotation ga = tx.getAnnotation();
                Taxon.Builder tb = new Taxon.Builder(tx.getName());
                Set<String> keys = ga.getAnnotationKeys();
                for (String key : keys) {
                    String[] values;
                    if (key.equals("SYNONYM")) continue;
                    for (String value : values = ga.getTextAnnotation(key)) {
                        tb.addAnno(key, value);
                    }
                }
                tb.addAnno("SYNONYM", newName);
                tlb.add(tb.build());
            } else {
                tlb.add(tx);
            }
            ++rowCounter;
        }
        this.tempTaxaList = tlb.build();
    }

    public void deleteElements(String name) {
        TaxaListBuilder tlb = new TaxaListBuilder();
        for (Taxon tx : this.tempTaxaList) {
            if (tx.getName().equals(name)) continue;
            tlb.add(tx);
        }
        this.tempTaxaList = tlb.build();
    }

    public boolean checkSynForDups() {
        for (TaxaList tl : this.taxaListSynonymized) {
            ArrayList<String> viewedTaxa = new ArrayList<String>();
            for (Taxon tx : tl) {
                GeneralAnnotation ga = tx.getAnnotation();
                String[] values = ga.getTextAnnotation("SYNONYM");
                if (values.length == 0 || values == null) {
                    viewedTaxa.add(tx.getName());
                    continue;
                }
                if (viewedTaxa.contains(values[0])) {
                    return true;
                }
                viewedTaxa.add(values[0]);
            }
        }
        return false;
    }

    public ArrayList<TaxaList> swapSynonyms() {
        ArrayList<TaxaList> newTaxaListArray = new ArrayList<TaxaList>();
        for (TaxaList tl : this.taxaListSynonymized) {
            TaxaListBuilder tlb = new TaxaListBuilder();
            for (Taxon tx : tl) {
                GeneralAnnotation ga = tx.getAnnotation();
                Taxon.Builder tb = null;
                Set<String> keys = ga.getAnnotationKeys();
                if (ga.getTextAnnotation("SYNONYM").length == 0) {
                    tb = new Taxon.Builder(tx);
                } else {
                    tb = new Taxon.Builder(ga.getTextAnnotation("SYNONYM")[0]);
                    for (String key : keys) {
                        String[] values;
                        if (key.equals("SYNONYM")) continue;
                        for (String value : values = ga.getTextAnnotation(key)) {
                            tb.addAnno(key, value);
                        }
                    }
                    String[] synVals = ga.getTextAnnotation("SYNONYM");
                    tb.addAnno("SYNONYM", tx.getName());
                    for (int i = 1; i < synVals.length; ++i) {
                        tb.addAnno("SYNONYM", synVals[i]);
                    }
                }
                tlb.add(tb.build());
            }
            newTaxaListArray.add(tlb.build());
        }
        return newTaxaListArray;
    }

    @Override
    public String getTableTitle() {
        return "Taxa Synonym Table";
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public long getRowCount() {
        return this.tempTaxaList.size();
    }

    @Override
    public long getElementCount() {
        return (long)this.getColumnCount() * this.getRowCount();
    }
}

