/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import net.maizegenetics.taxa.TaxaNoIndexList;
import net.maizegenetics.taxa.Taxon;
import org.apache.log4j.Logger;

class TaxaArrayList
extends TaxaNoIndexList {
    private static final Logger myLogger = Logger.getLogger(TaxaArrayList.class);
    private final Map<String, Integer> myNameToIndex = new Object2IntOpenHashMap(this.numberOfTaxa());

    TaxaArrayList(List<Taxon> srcList) {
        super(srcList);
        for (int i = 0; i < this.numberOfTaxa(); ++i) {
            this.myNameToIndex.put(srcList.get(i).getName(), i);
        }
    }

    @Override
    public int indexOf(String name) {
        Integer index = this.myNameToIndex.get(name);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof String) {
            Integer index = this.myNameToIndex.get((String)o);
            return index != null;
        }
        if (o instanceof Taxon) {
            Integer index = this.myNameToIndex.get(((Taxon)o).getName());
            return index != null;
        }
        return false;
    }
}

