/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.distance;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.distance.DistanceMatrixBuilder;
import net.maizegenetics.util.FormattedOutput;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.TableReport;

public class DistanceMatrix
implements TableReport {
    private final TaxaList myTaxaList;
    private final int myNumTaxa;
    private final GeneralAnnotation myAnnotations;
    private final float[][] myDistances;

    DistanceMatrix(float[][] distances, TaxaList taxa, GeneralAnnotation annotations) {
        this.myDistances = distances;
        this.myTaxaList = taxa;
        this.myNumTaxa = this.myTaxaList.numberOfTaxa();
        this.myAnnotations = annotations;
    }

    public DistanceMatrix(double[][] distance, TaxaList taxa) {
        this(distance, taxa, null);
    }

    public DistanceMatrix(double[][] distances, TaxaList taxa, GeneralAnnotation annotations) {
        this.myNumTaxa = taxa.numberOfTaxa();
        if (distances == null || distances.length != this.myNumTaxa || distances[0].length != this.myNumTaxa) {
            throw new IllegalArgumentException("DistanceMatrix: init: dimensions of distances aren't correct.");
        }
        this.myDistances = new float[this.myNumTaxa][];
        for (int i = 0; i < this.myNumTaxa; ++i) {
            this.myDistances[i] = new float[i + 1];
        }
        for (int x = 0; x < this.myNumTaxa; ++x) {
            for (int y = 0; y <= x; ++y) {
                if (Math.abs(distances[x][y] - distances[y][x]) > 1.0E-7) {
                    throw new IllegalStateException("DistanceMatrix: init: values passed in are not symmetrical: " + distances[x][y] + " and: " + distances[y][x]);
                }
                this.myDistances[x][y] = (float)distances[x][y];
            }
        }
        this.myTaxaList = taxa;
        this.myAnnotations = annotations;
    }

    public DistanceMatrix(DistanceMatrix dm) {
        this.myNumTaxa = dm.numberOfTaxa();
        this.myDistances = new float[this.myNumTaxa][];
        for (int i = 0; i < this.myNumTaxa; ++i) {
            this.myDistances[i] = new float[i + 1];
        }
        for (int x = 0; x < this.myNumTaxa; ++x) {
            for (int y = 0; y <= x; ++y) {
                this.myDistances[x][y] = dm.myDistances[x][y];
            }
        }
        this.myTaxaList = dm.myTaxaList;
        this.myAnnotations = dm.myAnnotations;
    }

    public DistanceMatrix(DistanceMatrix dm, TaxaList subset) {
        int i;
        this.myNumTaxa = subset.numberOfTaxa();
        this.myDistances = new float[this.myNumTaxa][];
        for (i = 0; i < this.myNumTaxa; ++i) {
            this.myDistances[i] = new float[i + 1];
        }
        for (i = 0; i < this.myNumTaxa; ++i) {
            int index1 = dm.whichIdNumber(subset.taxaName(i));
            this.myDistances[i][i] = dm.myDistances[index1][index1];
            for (int j = 0; j < i; ++j) {
                int index2 = dm.whichIdNumber(subset.taxaName(j));
                this.myDistances[i][j] = dm.getDistance(index1, index2);
            }
        }
        this.myTaxaList = subset;
        this.myAnnotations = dm.myAnnotations;
    }

    public void printPHYLIP(PrintWriter out) throws IOException {
        out.println("  " + this.myNumTaxa);
        FormattedOutput format = FormattedOutput.getInstance();
        for (int i = 0; i < this.myNumTaxa; ++i) {
            format.displayLabel(out, this.myTaxaList.taxaName(i), 10);
            out.print("      ");
            for (int j = 0; j < this.myNumTaxa; ++j) {
                if (j % 6 == 0 && j != 0) {
                    out.println();
                    out.print("                ");
                }
                out.print("  ");
                format.displayDecimal(out, this.getDistance(i, j), 5);
            }
            out.println();
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.printPHYLIP(new PrintWriter(sw));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public double squaredDistance(DistanceMatrix mat, boolean weighted) {
        double sum = 0.0;
        for (int i = 0; i < this.myNumTaxa - 1; ++i) {
            for (int j = 0; j < i; ++j) {
                double weight;
                double diff = this.myDistances[i][j] - mat.getDistance(i, j);
                if (weighted) {
                    float distance = this.myDistances[i][j];
                    weight = 1.0 / (double)distance * (double)distance;
                } else {
                    weight = 1.0;
                }
                sum += weight * diff * diff;
            }
        }
        return 2.0 * sum;
    }

    public double absoluteDistance(DistanceMatrix mat) {
        double sum = 0.0;
        for (int i = 0; i < this.myNumTaxa - 1; ++i) {
            for (int j = 0; j < i; ++j) {
                double diff = Math.abs(this.myDistances[i][j] - mat.getDistance(i, j));
                sum += diff;
            }
        }
        return 2.0 * sum;
    }

    public int getSize() {
        return this.myNumTaxa;
    }

    public final double[][] getClonedDistances() {
        double[][] copy = new double[this.myNumTaxa][this.myNumTaxa];
        for (int i = 0; i < this.myNumTaxa; ++i) {
            for (int j = 0; j <= i; ++j) {
                copy[i][j] = this.myDistances[i][j];
                copy[j][i] = copy[i][j];
            }
        }
        return copy;
    }

    public final double[][] getDistances() {
        return this.getClonedDistances();
    }

    public final float getDistance(int row, int col) {
        if (row > col) {
            return this.myDistances[row][col];
        }
        return this.myDistances[col][row];
    }

    public double meanDistance() {
        double dist = 0.0;
        int count = 0;
        for (int i = 1; i < this.myNumTaxa; ++i) {
            for (int j = 0; j < i; ++j) {
                float distance = this.myDistances[i][j];
                if (Float.isNaN(distance)) continue;
                dist += (double)distance;
                ++count;
            }
        }
        return dist / (double)count;
    }

    public Taxon getTaxon(int i) {
        return (Taxon)this.myTaxaList.get(i);
    }

    public int numberOfTaxa() {
        return this.myTaxaList.numberOfTaxa();
    }

    public int whichIdNumber(String name) {
        return this.myTaxaList.indexOf(name);
    }

    public int whichIdNumber(Taxon id) {
        return this.myTaxaList.indexOf(id);
    }

    public TaxaList getTaxaList() {
        return this.myTaxaList;
    }

    public boolean isSymmetric() {
        for (int i = 0; i < this.myNumTaxa; ++i) {
            if (this.myDistances[i][i] == 0.0f) continue;
            return false;
        }
        return true;
    }

    private boolean isIn(int value, int[] set) {
        if (set == null) {
            return false;
        }
        for (int i = 0; i < set.length; ++i) {
            if (set[i] != value) continue;
            return true;
        }
        return false;
    }

    public int getClosestIndex(int fromIndex, int[] exclusion) {
        float min = Float.POSITIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < this.myNumTaxa; ++i) {
            float d;
            if (i == fromIndex || this.isIn(i, exclusion) || !((d = this.getDistance(fromIndex, i)) < min)) continue;
            min = d;
            index = i;
        }
        return index;
    }

    public static DistanceMatrix hadamardProduct(DistanceMatrix m0, DistanceMatrix m1) {
        int n = m0.numberOfTaxa();
        if (m1.numberOfTaxa() != n) {
            throw new IllegalArgumentException("Matrices must be of the same dimensions to compute a Hadamard product.");
        }
        DistanceMatrixBuilder builder = DistanceMatrixBuilder.getInstance(m0.getTaxaList());
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c <= r; ++c) {
                builder.set(r, c, m0.myDistances[r][c] * m1.myDistances[r][c]);
            }
        }
        return builder.build();
    }

    @Override
    public Object[] getTableColumnNames() {
        Object[] colNames = new String[this.getSize() + 1];
        colNames[0] = "Taxa";
        for (int i = 0; i < this.myNumTaxa; ++i) {
            colNames[i + 1] = this.getTaxon(i).toString();
        }
        return colNames;
    }

    @Override
    public Object[] getRow(long rowLong) {
        int row = (int)rowLong;
        Object[] result = new Object[this.myNumTaxa + 1];
        result[0] = this.getTaxon(row);
        for (int j = 1; j <= this.myNumTaxa; ++j) {
            result[j] = String.valueOf(this.getDistance(row, j - 1));
        }
        return result;
    }

    @Override
    public String getTableTitle() {
        return "Distance Matrix";
    }

    @Override
    public long getRowCount() {
        return this.myNumTaxa;
    }

    @Override
    public long getElementCount() {
        return this.getRowCount() * (long)this.getColumnCount();
    }

    @Override
    public int getColumnCount() {
        return this.myNumTaxa + 1;
    }

    @Override
    public Object getValueAt(long rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.getTaxon((int)rowIndex);
        }
        return Float.valueOf(this.getDistance((int)rowIndex, columnIndex - 1));
    }

    public String getColumnName(int col) {
        if (col == 0) {
            return "Taxa";
        }
        return this.getTaxon(col - 1).toString();
    }

    public GeneralAnnotation annotations() {
        return this.myAnnotations;
    }
}

