/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.tree.NewickUtils;
import net.maizegenetics.taxa.tree.Node;
import net.maizegenetics.taxa.tree.SimpleNode;
import net.maizegenetics.taxa.tree.SimpleTree;
import net.maizegenetics.taxa.tree.Tree;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a$\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\rH\u0002\u001a\u0016\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0001\u001a \u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013\u001a\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0001\u001a\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u001c\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013\u001a\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c\u001a \u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u001e\u001a\u00020\u001f\u001a \u0010\u001d\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u0013*\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"MERGE_ROOT_NODE", "", "myLogger", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "addChildren", "", "nodes", "", "Lnet/maizegenetics/taxa/tree/Node;", "node", "convertNames", "conversions", "", "Lnet/maizegenetics/taxa/tree/Tree;", "tree", "filename", "keepNode", "namesToKeep", "", "makeNode", "newick", "mergeTrees", "trees", "read", "removeBranchLengths", "subsetTree", "taxaList", "Lnet/maizegenetics/taxa/TaxaList;", "write", "includeBranchLengths", "", "writer", "Ljava/io/BufferedWriter;", "tassel"})
@JvmName(name="NewickUtils")
public final class NewickUtils {
    private static final Logger myLogger = Logger.getLogger((String)"net.maizegenetics.taxa.tree.NewickUtils");
    @NotNull
    private static final String MERGE_ROOT_NODE = "MERGE_ROOT_NODE";

    @NotNull
    public static final Tree read(@NotNull String filename) {
        char it;
        char element$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String newick2 = CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)new File(filename), null, (int)1, null), (CharSequence)"", null, null, (int)0, null, (Function1)read.newick.1.INSTANCE, (int)30, null);
        CharSequence $this$count$iv = newick2;
        boolean $i$f$count = false;
        int count$iv = 0;
        CharSequence charSequence = $this$count$iv;
        for (n = 0; n < charSequence.length(); ++n) {
            element$iv = charSequence.charAt(n);
            it = element$iv;
            boolean bl = false;
            if (!(it == '(')) continue;
            ++count$iv;
        }
        $this$count$iv = newick2;
        int n2 = count$iv;
        $i$f$count = false;
        count$iv = 0;
        charSequence = $this$count$iv;
        for (n = 0; n < charSequence.length(); ++n) {
            element$iv = charSequence.charAt(n);
            it = element$iv;
            boolean bl = false;
            if (!(it == ')')) continue;
            ++count$iv;
        }
        int n3 = count$iv;
        if (n2 != n3) {
            throw new IllegalArgumentException("NewickUtils: read: " + filename + ": number of open parenthesis doesn't match number of close parenthesis.");
        }
        if (StringsKt.last((CharSequence)newick2) != ';') {
            throw new IllegalArgumentException("NewickUtils: read: " + filename + ": doesn't end with semicolon.");
        }
        charSequence = newick2.substring(0, newick2.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return new SimpleTree(NewickUtils.makeNode((String)charSequence));
    }

    private static final Node makeNode(String newick2) {
        String string;
        String nameBranchLength = StringsKt.substringAfterLast$default((String)newick2, (char)')', null, (int)2, null);
        String it = StringsKt.replace$default((String)StringsKt.substringBefore$default((String)nameBranchLength, (char)':', null, (int)2, null), (String)"'", (String)"", (boolean)false, (int)4, null);
        boolean bl = false;
        try {
            Double.parseDouble(it);
            string = "";
        }
        catch (NumberFormatException ne) {
            string = StringsKt.replace$default((String)it, (String)"_", (String)" ", (boolean)false, (int)4, null);
        }
        String name = string;
        double branchLength = StringsKt.contains$default((CharSequence)nameBranchLength, (char)':', (boolean)false, (int)2, null) ? Double.parseDouble(StringsKt.substringAfter$default((String)nameBranchLength, (char)':', null, (int)2, null)) : 0.0;
        SimpleNode result = new SimpleNode(name, branchLength);
        if (!Intrinsics.areEqual((Object)nameBranchLength, (Object)newick2)) {
            int parenthesisCount = 0;
            StringBuilder currentStr = null;
            currentStr = new StringBuilder();
            CharSequence $this$forEach$iv = StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)newick2, (char)'(', null, (int)2, null), (char)')', null, (int)2, null);
            boolean $i$f$forEach = false;
            CharSequence charSequence = $this$forEach$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it2 = element$iv;
                boolean bl2 = false;
                char c = it2;
                if (c == '(') {
                    int n = parenthesisCount;
                    parenthesisCount = n + 1;
                    currentStr.append(it2);
                    continue;
                }
                if (c == ')') {
                    int n = parenthesisCount;
                    parenthesisCount = n + -1;
                    currentStr.append(it2);
                    continue;
                }
                if (c == ',') {
                    if (parenthesisCount == 0) {
                        String string2 = currentStr.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currentStr.toString()");
                        result.addChild(NewickUtils.makeNode(string2));
                        currentStr = new StringBuilder();
                        continue;
                    }
                    currentStr.append(it2);
                    continue;
                }
                currentStr.append(it2);
            }
            if (((CharSequence)currentStr).length() > 0) {
                String string3 = currentStr.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"currentStr.toString()");
                result.addChild(NewickUtils.makeNode(string3));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void write(@NotNull String filename, @NotNull Tree tree, boolean includeBranchLengths) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        try {
            Object object = new File(filename);
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object3 = new FileOutputStream((File)object3);
            Writer writer = new OutputStreamWriter((OutputStream)object3, (Charset)object2);
            object = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            object2 = null;
            try {
                BufferedWriter writer2 = (BufferedWriter)object;
                boolean bl = false;
                object3 = tree.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"tree.root");
                NewickUtils.write((Node)object3, writer2, includeBranchLengths);
                Writer writer3 = writer2.append(";\n");
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("NewickUtils: write: problem writing: " + filename + ".\n" + e.getMessage());
        }
    }

    public static /* synthetic */ void write$default(String string, Tree tree, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        NewickUtils.write(string, tree, bl);
    }

    private static final void write(Node node, BufferedWriter writer, boolean includeBranchLengths) {
        Object object;
        if (!node.isLeaf()) {
            writer.append("(");
            int n = 0;
            int n2 = node.getChildCount();
            while (n < n2) {
                int i;
                if ((i = n++) != 0) {
                    writer.append(",");
                }
                object = node.getChild(i);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.getChild(i)");
                NewickUtils.write((Node)object, writer, includeBranchLengths);
            }
            writer.append(")");
        }
        Taxon taxon = node.getIdentifier();
        if (taxon != null) {
            String string = taxon.getName();
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (((CharSequence)it).length() > 0) {
                    String name = StringsKt.replace$default((String)it, (char)' ', (char)'_', (boolean)false, (int)4, null);
                    writer.append("'");
                    writer.append(name);
                    writer.append("'");
                }
            }
        }
        if (includeBranchLengths && !(node.getBranchLength() == 0.0)) {
            writer.append(":");
            Object[] objectArray = new Object[]{node.getBranchLength()};
            object = String.format("%.7f", Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(this, *args)");
            Object lengthStr = object;
            String string = StringUtils.stripEnd((String)lengthStr, (String)"0");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stripEnd(lengthStr, \"0\")");
            lengthStr = string;
            string = StringUtils.stripEnd((String)lengthStr, (String)".");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stripEnd(lengthStr, \".\")");
            lengthStr = string;
            writer.append((CharSequence)lengthStr);
        }
    }

    @NotNull
    public static final Tree mergeTrees(@NotNull List<? extends Tree> trees) {
        Node node;
        Intrinsics.checkNotNullParameter(trees, (String)"trees");
        if (trees.size() < 2) {
            throw new IllegalArgumentException("NewickUtils: mergeTrees: must supply at least 2 trees.");
        }
        HashMap nameToNode = new HashMap();
        IdentityHashMap nodeToNode = new IdentityHashMap();
        Node rootNode = null;
        Iterable $this$forEach$iv = trees;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tree tree = (Tree)element$iv;
            boolean bl = false;
            List<Node> nodes = NewickUtils.nodes(tree);
            Iterable $this$forEach$iv2 = nodes;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                Object object2;
                String parentName;
                String string;
                String string2;
                Node existingParentNode;
                Node node2 = (Node)element$iv2;
                boolean bl2 = false;
                String nodeName = node2.getIdentifier().getName();
                Node existingNode = (Node)nameToNode.get(nodeName);
                Node node3 = existingParentNode = (Node)nodeToNode.get(node2.getParent());
                if (node3 == null) {
                    string2 = null;
                } else {
                    Taxon taxon = node3.getIdentifier();
                    string2 = taxon == null ? null : taxon.getName();
                }
                String existingParentName = string2;
                Node node4 = node2.getParent();
                if (node4 == null) {
                    string = null;
                } else {
                    Taxon taxon = node4.getIdentifier();
                    string = parentName = taxon == null ? null : taxon.getName();
                }
                if (nodeToNode.isEmpty()) {
                    rootNode = new SimpleNode(nodeName, node2.getBranchLength());
                    Map map = nodeToNode;
                    object2 = rootNode;
                    map.put(node2, object2);
                    Intrinsics.checkNotNullExpressionValue((Object)nodeName, (String)"nodeName");
                    if (!(((CharSequence)nodeName).length() > 0)) continue;
                    map = nameToNode;
                    object2 = nodeName;
                    object = rootNode;
                    map.put(object2, object);
                    continue;
                }
                if (existingNode != null) {
                    if (existingParentName != null && parentName != null && !Intrinsics.areEqual((Object)existingParentName, (Object)parentName)) {
                        throw new IllegalArgumentException("NewickUtils: mergeTrees: node: " + nodeName + " has different parents (" + parentName + ", " + existingParentName + ") in different trees.");
                    }
                    if (!(existingNode.getBranchLength() == node2.getBranchLength())) {
                        myLogger.warn((Object)("mergeTrees: nodes named: " + nodeName + " in different trees have different branch lengths."));
                    }
                    ((Map)nodeToNode).put(node2, existingNode);
                    continue;
                }
                if (existingParentNode == null) {
                    Node node5;
                    Object object3;
                    Node node6;
                    if (nameToNode.get(MERGE_ROOT_NODE) != null) {
                        Object v = nameToNode.get(MERGE_ROOT_NODE);
                        Intrinsics.checkNotNull(v);
                        node6 = (Node)v;
                    } else {
                        SimpleNode temp = new SimpleNode("", 0.0);
                        object3 = nameToNode;
                        String string3 = MERGE_ROOT_NODE;
                        object3.put(string3, temp);
                        node6 = temp;
                    }
                    object2 = node6;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"if (nameToNode[MERGE_ROO\u2026   temp\n                }");
                    Node mergeRoot = object2;
                    SimpleNode simpleNode = rootNode;
                    if (simpleNode == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"rootNode");
                        node5 = null;
                    } else {
                        node5 = simpleNode;
                    }
                    if (!Intrinsics.areEqual((Object)node5, (Object)mergeRoot)) {
                        mergeRoot.addChild(rootNode);
                    }
                    SimpleNode newChild = new SimpleNode(nodeName, node2.getBranchLength());
                    ((Map)nodeToNode).put(node2, newChild);
                    Intrinsics.checkNotNullExpressionValue((Object)nodeName, (String)"nodeName");
                    if (((CharSequence)nodeName).length() > 0) {
                        object = nameToNode;
                        object3 = nodeName;
                        object.put(object3, newChild);
                    }
                    mergeRoot.addChild(newChild);
                    rootNode = mergeRoot;
                    continue;
                }
                SimpleNode newChild = new SimpleNode(nodeName, node2.getBranchLength());
                ((Map)nodeToNode).put(node2, newChild);
                Intrinsics.checkNotNullExpressionValue((Object)nodeName, (String)"nodeName");
                if (((CharSequence)nodeName).length() > 0) {
                    object2 = nameToNode;
                    object = nodeName;
                    object2.put(object, newChild);
                }
                existingParentNode.addChild(newChild);
            }
        }
        SimpleNode simpleNode = rootNode;
        if (simpleNode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootNode");
            node = null;
        } else {
            node = simpleNode;
        }
        return new SimpleTree(node);
    }

    @NotNull
    public static final List<Node> nodes(@NotNull Tree $this$nodes) {
        Intrinsics.checkNotNullParameter((Object)$this$nodes, (String)"<this>");
        List result = new ArrayList();
        Node node = $this$nodes.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"this.root");
        result.add(node);
        node = $this$nodes.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"this.root");
        NewickUtils.addChildren(result, node);
        return result;
    }

    private static final void addChildren(List<Node> nodes, Node node) {
        int n = 0;
        int n2 = node.getChildCount();
        while (n < n2) {
            int i = n++;
            Node node2 = node.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node.getChild(i)");
            nodes.add(node2);
            node2 = node.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node.getChild(i)");
            NewickUtils.addChildren(nodes, node2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Tree subsetTree(@NotNull Tree tree, @NotNull TaxaList taxaList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)taxaList, (String)"taxaList");
        Iterable $this$map$iv = taxaList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Taxon taxon = (Taxon)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List nameList = (List)destination$iv$iv;
        return NewickUtils.subsetTree(tree, nameList);
    }

    @NotNull
    public static final Tree subsetTree(@NotNull Tree tree, @NotNull List<String> namesToKeep) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter(namesToKeep, (String)"namesToKeep");
        Node node = tree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"tree.root");
        return new SimpleTree(NewickUtils.keepNode(node, namesToKeep));
    }

    private static final Node keepNode(Node node, List<String> namesToKeep) {
        if (node.isLeaf()) {
            Taxon taxon = node.getIdentifier();
            if (taxon != null) {
                String string = taxon.getName();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    if (namesToKeep.contains(it)) {
                        Taxon taxon2 = node.getIdentifier();
                        return new SimpleNode((String)(taxon2 == null ? null : taxon2.getName()), node.getBranchLength());
                    }
                }
            }
        } else {
            List childNodesToKeep = new ArrayList();
            int n = 0;
            int n2 = node.getChildCount();
            while (n < n2) {
                Node it;
                int i = n++;
                Node node2 = node.getChild(i);
                Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node.getChild(i)");
                if (NewickUtils.keepNode(node2, namesToKeep) == null) continue;
                boolean bl = false;
                childNodesToKeep.add(it);
            }
            switch (childNodesToKeep.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    Node node3 = (Node)childNodesToKeep.get(0);
                    node3.setBranchLength(node3.getBranchLength() + node.getBranchLength());
                    return (Node)childNodesToKeep.get(0);
                }
            }
            Taxon taxon = node.getIdentifier();
            SimpleNode parent = new SimpleNode((String)(taxon == null ? null : taxon.getName()), node.getBranchLength());
            Iterable $this$forEach$iv = childNodesToKeep;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node it = (Node)element$iv;
                boolean bl = false;
                parent.addChild(it);
            }
            return parent;
        }
        return null;
    }

    @NotNull
    public static final Tree removeBranchLengths(@NotNull Tree tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Node node = tree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"tree.root");
        return new SimpleTree(NewickUtils.removeBranchLengths(node));
    }

    private static final Node removeBranchLengths(Node node) {
        Taxon taxon = node.getIdentifier();
        SimpleNode result = new SimpleNode((String)(taxon == null ? null : taxon.getName()), 0.0);
        int n = 0;
        int n2 = node.getChildCount();
        while (n < n2) {
            int i = n++;
            Node node2 = node.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node.getChild(i)");
            result.addChild(NewickUtils.removeBranchLengths(node2));
        }
        return result;
    }

    @NotNull
    public static final Tree convertNames(@NotNull Tree tree, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Map conversions = new LinkedHashMap();
        Serializable serializable = new File(filename);
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        Object object = serializable;
        object = new FileInputStream((File)object);
        Reader reader = new InputStreamReader((InputStream)object, charset);
        (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).lines().forEach(arg_0 -> NewickUtils.convertNames$lambda-12(filename, conversions, arg_0));
        serializable = tree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"tree.root");
        return new SimpleTree(NewickUtils.convertNames((Node)serializable, conversions));
    }

    private static final Node convertNames(Node node, Map<String, String> conversions) {
        Taxon taxon = node.getIdentifier();
        String string = conversions.get(taxon == null ? null : taxon.getName());
        if (string == null) {
            Taxon taxon2 = node.getIdentifier();
            string = taxon2 == null ? null : taxon2.getName();
        }
        String name = string;
        SimpleNode result = new SimpleNode(name, 0.0);
        int n = 0;
        int n2 = node.getChildCount();
        while (n < n2) {
            int i = n++;
            Node node2 = node.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node.getChild(i)");
            result.addChild(NewickUtils.convertNames(node2, conversions));
        }
        return result;
    }

    private static final void convertNames$lambda-12(String $filename, Map $conversions, String it) {
        Intrinsics.checkNotNullParameter((Object)$filename, (String)"$filename");
        Intrinsics.checkNotNullParameter((Object)$conversions, (String)"$conversions");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        String[] stringArray = new String[]{"\t"};
        List temp = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (temp.size() != 2) {
            throw new IllegalArgumentException("NewickUtils: convertNames: each line of file: " + $filename + " should have two names separated by a tab.\nOffending line: " + it);
        }
        $conversions.put(StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)((String)temp.get(0)))).toString(), (char)'_', (char)' ', (boolean)false, (int)4, null), StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)((String)temp.get(1)))).toString(), (char)'_', (char)' ', (boolean)false, (int)4, null));
    }
}

