/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.maizegenetics.util.TableReport;

public class HDF5TableReport
implements TableReport {
    private final IHDF5Reader myReader;
    private final Map<Integer, List<String>> myData = new HashMap<Integer, List<String>>();
    private final String[] myColumnHeadings;

    public HDF5TableReport(String filename) {
        this.myReader = HDF5Factory.openForReading((String)filename);
        this.traverseNode("/", 0);
        this.myColumnHeadings = new String[this.myData.size()];
        for (int i = 0; i < this.myData.size(); ++i) {
            this.myColumnHeadings[i] = String.valueOf(i);
        }
    }

    @Override
    public Object[] getTableColumnNames() {
        return this.myColumnHeadings;
    }

    @Override
    public String getTableTitle() {
        return "HDF5 Schema";
    }

    @Override
    public int getColumnCount() {
        return this.myData.size();
    }

    @Override
    public long getRowCount() {
        return this.myData.get(0).size();
    }

    @Override
    public long getElementCount() {
        return (long)this.getColumnCount() * this.getRowCount();
    }

    @Override
    public Object[] getRow(long row) {
        Object[] result = new Object[this.getColumnCount()];
        for (int i = 0; i < this.getColumnCount(); ++i) {
            result[i] = this.getValueAt(row, i);
        }
        return result;
    }

    @Override
    public Object getValueAt(long row, int col) {
        return this.myData.get(col).get((int)row);
    }

    private void traverseNode(String node, int column) {
        this.addAttributes(node, column);
        List members = this.myReader.object().getAllGroupMembers(node);
        for (String str : members) {
            StringBuilder builder = new StringBuilder();
            builder.append(str);
            String path = node + "/" + str;
            if (this.myReader.isGroup(path)) {
                this.setValue(column, builder.toString());
                this.traverseNode(path, column + 1);
                continue;
            }
            if (this.myReader.object().isDataSet(path)) {
                HDF5DataSetInformation info = this.myReader.getDataSetInformation(path);
                builder.append(" : ").append(this.myReader.getDataSetInformation(path).getTypeInformation().tryGetJavaType().getName());
                long[] dimensions = info.getDimensions();
                if (dimensions.length != 0) {
                    builder.append(" [");
                    boolean first = true;
                    for (long dimension : dimensions) {
                        if (!first) {
                            builder.append(", ");
                        } else {
                            first = false;
                        }
                        builder.append(dimension);
                    }
                    builder.append("]");
                }
                this.setValue(column, builder.toString());
                this.addAttributes(path, column + 1);
                continue;
            }
            this.setValue(column, builder.toString());
        }
    }

    private void addAttributes(String path, int column) {
        List attributes = this.myReader.object().getAttributeNames(path);
        for (String attribute : attributes) {
            StringBuilder builder = new StringBuilder();
            HDF5DataTypeInformation info = this.myReader.object().getAttributeInformation(path, attribute);
            builder.append(attribute);
            Class clazz = info.tryGetJavaType();
            if (clazz.isAssignableFrom(Integer.TYPE)) {
                int value = this.myReader.int32().getAttr(path, attribute);
                builder.append(" : ").append(value);
            } else if (clazz.isAssignableFrom(Boolean.TYPE)) {
                boolean value = this.myReader.bool().getAttr(path, attribute);
                builder.append(" : ").append(value);
            } else if (clazz.isAssignableFrom(String.class)) {
                String value = this.myReader.string().getAttr(path, attribute);
                builder.append(" : ").append(value);
            }
            builder.append(" (").append(clazz.getName()).append(" attribute)");
            this.setValue(column, builder.toString());
        }
    }

    private void setValue(int column, String value) {
        List<String> currentColumn = this.myData.get(column);
        if (currentColumn == null) {
            currentColumn = new ArrayList<String>();
            if (!this.myData.isEmpty()) {
                currentColumn.add("");
                for (int i = 1; i < this.myData.get(0).size(); ++i) {
                    currentColumn.add(null);
                }
            }
        }
        this.myData.put(column, currentColumn);
        for (List<String> currentList : this.myData.values()) {
            if (currentList == currentColumn) {
                currentColumn.add(value);
                continue;
            }
            currentList.add(null);
        }
    }
}

