/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.text.NumberFormat;
import net.maizegenetics.util.Utils;

public class Sizeof {
    private static final Runtime s_runtime = Runtime.getRuntime();

    public static void main(String[] args) throws Exception {
        Sizeof.printMemoryUse();
    }

    public static void printMemoryUse() {
        NumberFormat format = NumberFormat.getInstance();
        try {
            System.out.println("-------------------------------");
            System.out.print("Current Heap Size: ");
            long current = Sizeof.getMemoryUse() / 0x100000L;
            String currentStr = format.format(current);
            System.out.print(currentStr);
            System.out.println(" MB");
            System.out.print("Max Available Heap: ");
            System.out.print(Utils.getMaxHeapSizeMB());
            System.out.println(" MB");
            System.out.println("-------------------------------");
        }
        catch (Exception e) {
            System.out.println("Problem getting heap size: " + e.getMessage());
        }
    }

    public static long getMemoryUse() throws Exception {
        Sizeof.runGC();
        Sizeof.usedMemory();
        Sizeof.runGC();
        return Sizeof.usedMemory();
    }

    private static void runGC() throws Exception {
        for (int i = 0; i < 4; ++i) {
            Sizeof._runGC();
        }
    }

    private static void _runGC() throws Exception {
        long usedMem1 = Sizeof.usedMemory();
        long usedMem2 = Long.MAX_VALUE;
        for (int i = 0; usedMem1 < usedMem2 && i < 500; ++i) {
            s_runtime.runFinalization();
            s_runtime.gc();
            Thread.currentThread();
            Thread.yield();
            usedMem2 = usedMem1;
            usedMem1 = Sizeof.usedMemory();
        }
    }

    private static long usedMemory() {
        return s_runtime.totalMemory() - s_runtime.freeMemory();
    }
}

