/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.frontendbase.logging;

import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.mamoe.mirai.console.frontendbase.FrontendBase;
import net.mamoe.mirai.console.frontendbase.logging.LogRecorder;
import net.mamoe.mirai.console.util.AnsiMessageBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0004J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u00108\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00128\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/mamoe/mirai/console/frontendbase/logging/DailySplitLogRecorder;", "Lnet/mamoe/mirai/console/frontendbase/logging/LogRecorder;", "directory", "Ljava/nio/file/Path;", "base", "Lnet/mamoe/mirai/console/frontendbase/FrontendBase;", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "(Ljava/nio/file/Path;Lnet/mamoe/mirai/console/frontendbase/FrontendBase;Ljava/time/format/DateTimeFormatter;)V", "getBase", "()Lnet/mamoe/mirai/console/frontendbase/FrontendBase;", "getDateFormatter", "()Ljava/time/format/DateTimeFormatter;", "getDirectory", "()Ljava/nio/file/Path;", "lastDate", "", "writer", "Ljava/io/Writer;", "acquireFileWriter", "", "record", "msg", "", "mirai-console-frontend-base"})
public class DailySplitLogRecorder
extends LogRecorder {
    @NotNull
    private final Path directory;
    @NotNull
    private final FrontendBase base;
    @NotNull
    private final DateTimeFormatter dateFormatter;
    @JvmField
    @Nullable
    protected Writer writer;
    @JvmField
    protected int lastDate;

    public DailySplitLogRecorder(@NotNull Path directory, @NotNull FrontendBase base, @NotNull DateTimeFormatter dateFormatter) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)dateFormatter, (String)"dateFormatter");
        this.directory = directory;
        this.base = base;
        this.dateFormatter = dateFormatter;
        this.lastDate = -1;
    }

    public /* synthetic */ DailySplitLogRecorder(Path path, FrontendBase frontendBase, DateTimeFormatter dateTimeFormatter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ofPattern("YYYY-MM-dd'.log'");
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter2, (String)"ofPattern(\n        \"YYYY-MM-dd'.log'\"\n    )");
            dateTimeFormatter = dateTimeFormatter2;
        }
        this(path, frontendBase, dateTimeFormatter);
    }

    @NotNull
    protected final Path getDirectory() {
        return this.directory;
    }

    @NotNull
    protected final FrontendBase getBase() {
        return this.base;
    }

    @NotNull
    protected final DateTimeFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    protected final void acquireFileWriter() {
        ZonedDateTime instantNow = Instant.now().atZone(ZoneId.systemDefault());
        int dayNow = instantNow.getDayOfYear();
        if (dayNow != this.lastDate) {
            this.lastDate = dayNow;
            Writer writer = this.writer;
            if (writer != null) {
                writer.close();
            }
            Path logPath = this.directory.resolve(this.dateFormatter.format(instantNow));
            Path path = logPath.getParent();
            if (path != null) {
                Path pt = path;
                boolean bl = false;
                if (!Files.isDirectory(pt, new LinkOption[0])) {
                    Files.createDirectories(pt, new FileAttribute[0]);
                }
            }
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
            this.writer = Files.newBufferedWriter(logPath, Charsets.UTF_8, openOptionArray);
        }
    }

    @Override
    public void record(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        try {
            this.acquireFileWriter();
            Writer writer = this.writer;
            if (writer == null) {
                throw new IllegalStateException("Writer not setup".toString());
            }
            writer.append(this.base.getLogDropAnsi() ? AnsiMessageBuilder.Companion.dropAnsi(msg) : msg).append('\n').flush();
        }
        catch (Throwable e) {
            this.base.printToScreenDirectly(ExceptionsKt.stackTraceToString((Throwable)e));
        }
    }
}

