/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.logging;

import java.util.BitSet;
import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.mamoe.mirai.console.logging.LoggerController;
import net.mamoe.mirai.console.util.ConsoleExperimentalApi;
import net.mamoe.mirai.utils.SimpleLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH$J\u001a\u0010\u000e\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u00078\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/mamoe/mirai/console/logging/AbstractLoggerController;", "Lnet/mamoe/mirai/console/logging/LoggerController;", "()V", "isLoggerControlStateSupported", "", "()Z", "loggerConfigUpdateTime", "", "getLoggerControlState", "Lnet/mamoe/mirai/console/logging/LoggerController$LoggerControlState;", "identity", "", "getPriority", "Lnet/mamoe/mirai/console/logging/AbstractLoggerController$LogPriority;", "shouldLog", "priority", "Lnet/mamoe/mirai/utils/SimpleLogger$LogPriority;", "settings", "LogPriority", "PathBased", "mirai-console"})
@ConsoleExperimentalApi
public abstract class AbstractLoggerController
implements LoggerController {
    @JvmField
    protected volatile transient long loggerConfigUpdateTime;

    protected boolean shouldLog(@NotNull LogPriority priority, @NotNull LogPriority settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        return settings.compareTo((Enum)priority) <= 0;
    }

    @NotNull
    protected abstract LogPriority getPriority(@Nullable String var1);

    @Override
    public boolean shouldLog(@Nullable String identity, @NotNull SimpleLogger.LogPriority priority) {
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        return this.shouldLog(LogPriority.Companion.by(priority), this.getPriority(identity));
    }

    protected boolean isLoggerControlStateSupported() {
        return false;
    }

    @Override
    @NotNull
    public LoggerController.LoggerControlState getLoggerControlState(@Nullable String identity) {
        if (this.isLoggerControlStateSupported()) {
            return new LoggerController.LoggerControlState(this, identity){
                @NotNull
                private final BitSet status;
                private volatile transient long lastUpdateTime;
                final /* synthetic */ AbstractLoggerController this$0;
                final /* synthetic */ String $identity;
                {
                    this.this$0 = $receiver;
                    this.$identity = $identity;
                    this.status = new BitSet(SimpleLogger.LogPriority.values().length);
                    this.lastUpdateTime = -1L;
                }

                public boolean shouldLog(@NotNull SimpleLogger.LogPriority priority) {
                    Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
                    if (this.lastUpdateTime != this.this$0.loggerConfigUpdateTime) {
                        this.updateProperties();
                    }
                    return this.status.get(priority.ordinal());
                }

                /*
                 * WARNING - void declaration
                 */
                private final synchronized void updateProperties() {
                    void $this$forEach$iv;
                    this.lastUpdateTime = this.this$0.loggerConfigUpdateTime;
                    SimpleLogger.LogPriority[] logPriorityArray = SimpleLogger.LogPriority.values();
                    AbstractLoggerController abstractLoggerController = this.this$0;
                    String string = this.$identity;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void prio = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        this.status.set(prio.ordinal(), abstractLoggerController.shouldLog(string, (SimpleLogger.LogPriority)prio));
                    }
                }
            };
        }
        return LoggerController.super.getLoggerControlState(identity);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0087\u0001\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u0011\b\u0012\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lnet/mamoe/mirai/console/logging/AbstractLoggerController$LogPriority;", "", "void", "", "(Ljava/lang/String;ILjava/lang/Void;)V", "(Ljava/lang/String;I)V", "mapped", "Lnet/mamoe/mirai/utils/SimpleLogger$LogPriority;", "ALL", "VERBOSE", "DEBUG", "INFO", "WARNING", "ERROR", "NONE", "Companion", "mirai-console"})
    @ConsoleExperimentalApi
    public static final class LogPriority
    extends Enum<LogPriority> {
        @NotNull
        public static final Companion Companion;
        @Nullable
        private SimpleLogger.LogPriority mapped;
        @NotNull
        private static final EnumMap<SimpleLogger.LogPriority, LogPriority> mapping;
        public static final /* enum */ LogPriority ALL;
        public static final /* enum */ LogPriority VERBOSE;
        public static final /* enum */ LogPriority DEBUG;
        public static final /* enum */ LogPriority INFO;
        public static final /* enum */ LogPriority WARNING;
        public static final /* enum */ LogPriority ERROR;
        public static final /* enum */ LogPriority NONE;
        private static final /* synthetic */ LogPriority[] $VALUES;

        private LogPriority(Void void_) {
        }

        private LogPriority() {
            this.mapped = SimpleLogger.LogPriority.valueOf((String)this.name());
        }

        public static LogPriority[] values() {
            return (LogPriority[])$VALUES.clone();
        }

        public static LogPriority valueOf(String value2) {
            return Enum.valueOf(LogPriority.class, value2);
        }

        static {
            ALL = new LogPriority(null);
            VERBOSE = new LogPriority();
            DEBUG = new LogPriority();
            INFO = new LogPriority();
            WARNING = new LogPriority();
            ERROR = new LogPriority();
            NONE = new LogPriority(null);
            $VALUES = logPriorityArray = new LogPriority[]{LogPriority.ALL, LogPriority.VERBOSE, LogPriority.DEBUG, LogPriority.INFO, LogPriority.WARNING, LogPriority.ERROR, LogPriority.NONE};
            Companion = new Companion(null);
            mapping = new EnumMap(SimpleLogger.LogPriority.class);
            LogPriority[] $this$forEach$iv = LogPriority.values();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                LogPriority element$iv;
                LogPriority priority = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Map map2 = mapping;
                SimpleLogger.LogPriority logPriority = priority.mapped;
                if (logPriority == null) continue;
                map2.put(logPriority, priority);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/mamoe/mirai/console/logging/AbstractLoggerController$LogPriority$Companion;", "", "()V", "mapping", "Ljava/util/EnumMap;", "Lnet/mamoe/mirai/utils/SimpleLogger$LogPriority;", "Lnet/mamoe/mirai/console/logging/AbstractLoggerController$LogPriority;", "by", "priority", "mirai-console"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LogPriority by(@NotNull SimpleLogger.LogPriority priority) {
                Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
                Object v = mapping.get(priority);
                Intrinsics.checkNotNull(v);
                return (LogPriority)((Object)v);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH$J\u0012\u0010\u000e\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\rH\u0014R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lnet/mamoe/mirai/console/logging/AbstractLoggerController$PathBased;", "Lnet/mamoe/mirai/console/logging/AbstractLoggerController;", "spliterator", "", "(C)V", "defaultPriority", "Lnet/mamoe/mirai/console/logging/AbstractLoggerController$LogPriority;", "getDefaultPriority", "()Lnet/mamoe/mirai/console/logging/AbstractLoggerController$LogPriority;", "getSpliterator", "()C", "findPriority", "identity", "", "getPriority", "nextPath", "path", "mirai-console"})
    @ConsoleExperimentalApi
    public static abstract class PathBased
    extends AbstractLoggerController {
        private final char spliterator;

        @JvmOverloads
        public PathBased(char spliterator) {
            this.spliterator = spliterator;
        }

        public /* synthetic */ PathBased(char c, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                c = (char)46;
            }
            this(c);
        }

        protected char getSpliterator() {
            return this.spliterator;
        }

        @NotNull
        protected abstract LogPriority getDefaultPriority();

        @Nullable
        protected abstract LogPriority findPriority(@Nullable String var1);

        @Nullable
        protected String nextPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            int lastIndex = StringsKt.lastIndexOf$default((CharSequence)path, (char)this.getSpliterator(), (int)0, (boolean)false, (int)6, null);
            if (lastIndex == -1) {
                return null;
            }
            String string = path.substring(0, lastIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }

        @Override
        @NotNull
        protected LogPriority getPriority(@Nullable String identity) {
            if (identity == null) {
                LogPriority logPriority = this.findPriority(null);
                if (logPriority == null) {
                    logPriority = this.getDefaultPriority();
                }
                return logPriority;
            }
            String path = identity;
            while (true) {
                LogPriority logPriority = this.findPriority(path);
                if (logPriority != null) {
                    LogPriority it = logPriority;
                    boolean bl = false;
                    return it;
                }
                if (this.nextPath(path) != null) continue;
                LogPriority logPriority2 = this.findPriority(null);
                if (logPriority2 == null) {
                    logPriority2 = this.getDefaultPriority();
                }
                return logPriority2;
            }
        }

        @JvmOverloads
        public PathBased() {
            this('\u0000', 1, null);
        }
    }
}

