/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.internal.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.mamoe.mirai.console.command.Command;
import net.mamoe.mirai.console.permission.Permission;
import net.mamoe.mirai.console.permission.PermissionId;
import net.mamoe.mirai.console.permission.PermissionService;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.Member;
import net.mamoe.mirai.contact.NormalMember;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u001aD\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\n0\t*\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u0005H\u0000\u001a*\u0010\u0011\u001a\u00020\u0012*\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0013H\u0080\u0004\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"findOrCreateCommandPermission", "Lnet/mamoe/mirai/console/permission/Permission;", "Lnet/mamoe/mirai/console/command/Command;", "parent", "fuzzyMatchWith", "", "", "target", "fuzzySearchMember", "", "Lkotlin/Pair;", "Lnet/mamoe/mirai/contact/Member;", "Lnet/mamoe/mirai/contact/Group;", "nameCardTarget", "minRate", "matchRate", "disambiguationRate", "intersectsIgnoringCase", "", "", "other", "([Ljava/lang/String;[Ljava/lang/String;)Z", "mirai-console"})
@SourceDebugExtension(value={"SMAP\ninternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 internal.kt\nnet/mamoe/mirai/console/internal/command/InternalKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n759#2,2:89\n775#2,4:91\n515#3:95\n500#3,6:96\n1054#4:102\n766#4:103\n857#4,2:104\n*S KotlinDebug\n*F\n+ 1 internal.kt\nnet/mamoe/mirai/console/internal/command/InternalKt\n*L\n61#1:89,2\n61#1:91,4\n62#1:95\n62#1:96,6\n64#1:102\n66#1:103\n66#1:104,2\n*E\n"})
public final class InternalKt {
    public static final boolean intersectsIgnoringCase(@NotNull String[] $this$intersectsIgnoringCase, @NotNull String[] other) {
        Intrinsics.checkNotNullParameter((Object)$this$intersectsIgnoringCase, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int max = RangesKt.coerceAtMost((int)$this$intersectsIgnoringCase.length, (int)other.length);
        for (int i2 = 0; i2 < max; ++i2) {
            if (!StringsKt.equals((String)$this$intersectsIgnoringCase[i2], (String)other[i2], (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public static final double fuzzyMatchWith(@NotNull String $this$fuzzyMatchWith, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)$this$fuzzyMatchWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (Intrinsics.areEqual((Object)$this$fuzzyMatchWith, (Object)target)) {
            return 1.0;
        }
        int match = 0;
        int i2 = 0;
        int n = Math.max(StringsKt.getLastIndex((CharSequence)$this$fuzzyMatchWith), StringsKt.getLastIndex((CharSequence)target));
        if (i2 <= n) {
            while (true) {
                char t;
                Character c = StringsKt.getOrNull((CharSequence)target, (int)match);
                if (c == null) {
                    break;
                }
                Character c2 = StringsKt.getOrNull((CharSequence)$this$fuzzyMatchWith, (int)i2);
                if (c2 != null && (t = c.charValue()) == c2.charValue()) {
                    ++match;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        int longerLength = Math.max($this$fuzzyMatchWith.length(), target.length());
        int shorterLength = Math.min($this$fuzzyMatchWith.length(), target.length());
        return (double)match / (double)(longerLength + (shorterLength - match));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<Member, Double>> fuzzySearchMember(@NotNull Group $this$fuzzySearchMember, @NotNull String nameCardTarget, double minRate, double matchRate, double disambiguationRate) {
        void $this$filterTo$iv$iv;
        void $this$sortedByDescending$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv;
        Object it;
        Map $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)$this$fuzzySearchMember, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)nameCardTarget, (String)"nameCardTarget");
        Sequence sequence = SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)$this$fuzzySearchMember.getMembers())), (Object)$this$fuzzySearchMember.getBotAsMember());
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            NormalMember normalMember = (NormalMember)element$iv$iv;
            Object e = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Double d = InternalKt.fuzzyMatchWith(it.getNameCard(), nameCardTarget);
            map2.put(e, d);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$filter = false;
        result$iv = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((Number)it.getValue()).doubleValue() >= minRate)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = MapsKt.toList((Map)destination$iv$iv);
        boolean $i$f$sortedByDescending = false;
        List candidates2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                Pair it = (Pair)b2;
                boolean bl = false;
                Comparable comparable = (Double)it.getSecond();
                it = (Pair)a2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getSecond()));
            }
        });
        Iterable $this$filter$iv2 = candidates2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it2 = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it2.getSecond()).doubleValue() >= matchRate)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List bestMatches = (List)destination$iv$iv2;
        return bestMatches.isEmpty() ? candidates2 : (bestMatches.size() == 1 ? CollectionsKt.listOf((Object)TuplesKt.to((Object)((Pair)CollectionsKt.single((List)bestMatches)).getFirst(), (Object)1.0)) : (((Number)((Pair)CollectionsKt.first((List)bestMatches)).getSecond()).doubleValue() - ((Number)((Pair)CollectionsKt.last((List)bestMatches)).getSecond()).doubleValue() <= disambiguationRate ? candidates2 : CollectionsKt.listOf((Object)TuplesKt.to((Object)((Pair)CollectionsKt.first((List)bestMatches)).getFirst(), (Object)1.0))));
    }

    public static /* synthetic */ List fuzzySearchMember$default(Group group, String string, double d, double d2, double d3, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.2;
        }
        if ((n & 4) != 0) {
            d2 = 0.6;
        }
        if ((n & 8) != 0) {
            d3 = 0.1;
        }
        return InternalKt.fuzzySearchMember(group, string, d, d2, d3);
    }

    @NotNull
    public static final Permission findOrCreateCommandPermission(@NotNull Command $this$findOrCreateCommandPermission, @NotNull Permission parent) {
        Intrinsics.checkNotNullParameter((Object)$this$findOrCreateCommandPermission, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        PermissionId id = $this$findOrCreateCommandPermission.getOwner().permissionId("command." + $this$findOrCreateCommandPermission.getPrimaryName());
        Permission permission2 = PermissionService.Companion.getInstance().get(id);
        if (permission2 == null) {
            permission2 = PermissionService.Companion.getInstance().register(id, $this$findOrCreateCommandPermission.getDescription(), parent);
        }
        return permission2;
    }
}

