/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.internal.plugin;

import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.mamoe.mirai.console.MiraiConsoleImplementation;
import net.mamoe.mirai.console.fontend.ProcessProgress;
import net.mamoe.mirai.console.internal.MiraiConsoleBuildDependencies;
import net.mamoe.mirai.console.internal.data.builtins.ConsoleDataScopeImplKt;
import net.mamoe.mirai.console.internal.data.builtins.PluginDependenciesConfig;
import net.mamoe.mirai.console.internal.plugin.JvmPluginDependencyDownloader;
import net.mamoe.mirai.console.plugin.PluginManager;
import net.mamoe.mirai.console.util.MemoryFormatKt;
import net.mamoe.mirai.utils.MiraiLogger;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transfer.TransferResource;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\"\"\u00020\u0006\u00a2\u0006\u0002\u0010#R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006$"}, d2={"Lnet/mamoe/mirai/console/internal/plugin/JvmPluginDependencyDownloader;", "", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "(Lnet/mamoe/mirai/utils/MiraiLogger;)V", "dependencyFilter", "Lorg/eclipse/aether/graph/DependencyFilter;", "getDependencyFilter", "()Lorg/eclipse/aether/graph/DependencyFilter;", "locator", "Lorg/eclipse/aether/spi/locator/ServiceLocator;", "getLocator", "()Lorg/eclipse/aether/spi/locator/ServiceLocator;", "getLogger", "()Lnet/mamoe/mirai/utils/MiraiLogger;", "repositories", "", "Lorg/eclipse/aether/repository/RemoteRepository;", "getRepositories", "()Ljava/util/List;", "repository", "Lorg/eclipse/aether/RepositorySystem;", "getRepository", "()Lorg/eclipse/aether/RepositorySystem;", "session", "Lorg/eclipse/aether/RepositorySystemSession;", "getSession", "()Lorg/eclipse/aether/RepositorySystemSession;", "resolveDependencies", "Lorg/eclipse/aether/resolution/DependencyResult;", "deps", "", "", "filters", "", "(Ljava/lang/Iterable;[Lorg/eclipse/aether/graph/DependencyFilter;)Lorg/eclipse/aether/resolution/DependencyResult;", "mirai-console"})
@SourceDebugExtension(value={"SMAP\nJvmPluginDependencyDownload.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmPluginDependencyDownload.kt\nnet/mamoe/mirai/console/internal/plugin/JvmPluginDependencyDownloader\n+ 2 MiraiLogger.kt\nnet/mamoe/mirai/utils/Utils__MiraiLoggerKt\n+ 3 MiraiConsoleImplementation.kt\nnet/mamoe/mirai/console/MiraiConsoleImplementation$ConsoleDataScope$Companion\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,295:1\n196#2,2:296\n196#2,2:298\n196#2,2:305\n292#3:300\n1549#4:301\n1620#4,3:302\n13579#5,2:307\n*S KotlinDebug\n*F\n+ 1 JvmPluginDependencyDownload.kt\nnet/mamoe/mirai/console/internal/plugin/JvmPluginDependencyDownloader\n*L\n218#1:296,2\n219#1:298,2\n263#1:305,2\n256#1:300\n259#1:301\n259#1:302,3\n285#1:307,2\n*E\n"})
public final class JvmPluginDependencyDownloader {
    @NotNull
    private final MiraiLogger logger;
    @NotNull
    private final List<RemoteRepository> repositories;
    @NotNull
    private final RepositorySystemSession session;
    @NotNull
    private final ServiceLocator locator;
    @NotNull
    private final RepositorySystem repository;
    @NotNull
    private final DependencyFilter dependencyFilter;

    /*
     * WARNING - void declaration
     */
    public JvmPluginDependencyDownloader(@NotNull MiraiLogger logger2) {
        Collection<RemoteRepository> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
        this.dependencyFilter = JvmPluginDependencyDownloader::dependencyFilter$lambda$0;
        DefaultServiceLocator defaultServiceLocator = MavenRepositorySystemUtils.newServiceLocator();
        Intrinsics.checkNotNullExpressionValue((Object)defaultServiceLocator, (String)"newServiceLocator()");
        this.locator = (ServiceLocator)defaultServiceLocator;
        ((DefaultServiceLocator)this.locator).addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        ((DefaultServiceLocator)this.locator).addService(TransporterFactory.class, HttpTransporterFactory.class);
        Object object2 = this.locator.getService(RepositorySystem.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"locator.getService(RepositorySystem::class.java)");
        this.repository = (RepositorySystem)object2;
        DefaultRepositorySystemSession defaultRepositorySystemSession = MavenRepositorySystemUtils.newSession();
        Intrinsics.checkNotNullExpressionValue((Object)defaultRepositorySystemSession, (String)"newSession()");
        this.session = (RepositorySystemSession)defaultRepositorySystemSession;
        ((DefaultRepositorySystemSession)this.session).setChecksumPolicy("fail");
        ((DefaultRepositorySystemSession)this.session).setLocalRepositoryManager(this.repository.newLocalRepositoryManager(this.session, new LocalRepository(PluginManager.INSTANCE.getPluginLibrariesFolder())));
        ((DefaultRepositorySystemSession)this.session).setTransferListener((TransferListener)new AbstractTransferListener(){
            @NotNull
            private final Map<File, ProcessProgress> dwnProgresses = new ConcurrentHashMap();

            public void transferStarted(@NotNull TransferEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                MiraiLogger $this$verbose$iv = this.getLogger();
                boolean $i$f$verbose = false;
                if ($this$verbose$iv.isVerboseEnabled()) {
                    MiraiLogger miraiLogger = $this$verbose$iv;
                    boolean bl = false;
                    TransferResource transferResource = event.getResource();
                    TransferResource transferResource2 = event.getResource();
                    miraiLogger.verbose("Downloading " + (transferResource != null ? transferResource.getRepositoryUrl() : null) + (transferResource2 != null ? transferResource2.getResourceName() : null));
                }
                ProcessProgress nw = MiraiConsoleImplementation.Companion.getInstance().createNewProcessProgress();
                File file = event.getResource().getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"event.resource.file");
                ProcessProgress processProgress = this.dwnProgresses.put(file, nw);
                if (processProgress != null) {
                    processProgress.close();
                }
                nw.setTotalSize(event.getResource().getContentLength());
                nw.updateText("Downloading " + event.getResource().getResourceName() + "....");
            }

            /*
             * WARNING - void declaration
             */
            public void transferSucceeded(@NotNull TransferEvent event) {
                block0: {
                    void $this$transferSucceeded_u24lambda_u242_u24lambda_u241;
                    StringBuilder stringBuilder;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    ProcessProgress processProgress = this.dwnProgresses.remove(event.getResource().getFile());
                    if (processProgress == null) break block0;
                    ProcessProgress dp = processProgress;
                    boolean bl = false;
                    StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                    ProcessProgress processProgress2 = dp;
                    boolean bl2 = false;
                    $this$transferSucceeded_u24lambda_u242_u24lambda_u241.append("Downloaded  ");
                    $this$transferSucceeded_u24lambda_u242_u24lambda_u241.append(event.getResource().getResourceName());
                    $this$transferSucceeded_u24lambda_u242_u24lambda_u241.append(" (");
                    MemoryFormatKt.renderMemoryUsageNumber((StringBuilder)$this$transferSucceeded_u24lambda_u242_u24lambda_u241, event.getResource().getContentLength());
                    $this$transferSucceeded_u24lambda_u242_u24lambda_u241.append(")");
                    String string = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                    processProgress2.updateText(string);
                    dp.close();
                }
            }

            /*
             * WARNING - void declaration
             */
            public void transferProgressed(@NotNull TransferEvent event) {
                block1: {
                    void $this$transferProgressed_u24lambda_u245_u24lambda_u244;
                    StringBuilder stringBuilder;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    ProcessProgress processProgress = this.dwnProgresses.get(event.getResource().getFile());
                    if (processProgress == null) break block1;
                    ProcessProgress pg = processProgress;
                    boolean bl = false;
                    pg.update(event.getTransferredBytes());
                    StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                    ProcessProgress processProgress2 = pg;
                    boolean bl2 = false;
                    $this$transferProgressed_u24lambda_u245_u24lambda_u244.append("Downloading ");
                    $this$transferProgressed_u24lambda_u245_u24lambda_u244.append(event.getResource().getResourceName());
                    $this$transferProgressed_u24lambda_u245_u24lambda_u244.append(" (");
                    int sz = $this$transferProgressed_u24lambda_u245_u24lambda_u244.length();
                    MemoryFormatKt.renderMemoryUsageNumber((StringBuilder)$this$transferProgressed_u24lambda_u245_u24lambda_u244, event.getTransferredBytes());
                    int n = Math.max(0, 7 - ($this$transferProgressed_u24lambda_u245_u24lambda_u244.length() - sz));
                    int n2 = 0;
                    while (n2 < n) {
                        int it = n2++;
                        boolean bl3 = false;
                        $this$transferProgressed_u24lambda_u245_u24lambda_u244.append(' ');
                    }
                    $this$transferProgressed_u24lambda_u245_u24lambda_u244.append(" / ");
                    MemoryFormatKt.renderMemoryUsageNumber((StringBuilder)$this$transferProgressed_u24lambda_u245_u24lambda_u244, event.getResource().getContentLength());
                    $this$transferProgressed_u24lambda_u245_u24lambda_u244.append(")");
                    String string = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                    processProgress2.updateText(string);
                    pg.rerender();
                }
            }

            public void transferFailed(@NotNull TransferEvent event) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.getLogger().warning((Throwable)event.getException());
                    ProcessProgress processProgress = this.dwnProgresses.remove(event.getResource().getFile());
                    if (processProgress == null) break block0;
                    ProcessProgress it = processProgress;
                    boolean bl = false;
                    it.markFailed();
                    it.close();
                }
            }
        });
        String userHome = System.getProperty("user.home");
        final File mavenLocRepo = JvmPluginDependencyDownloader._init_$findMavenLocal(userHome, this);
        final File gradleLocRepo = JvmPluginDependencyDownloader._init_$findGradleDepCache(userHome);
        MiraiLogger $this$debug$iv = this.logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            object = $this$debug$iv;
            boolean bl = false;
            object.debug("Maven        local: " + mavenLocRepo);
        }
        $this$debug$iv = this.logger;
        $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            object = $this$debug$iv;
            boolean bl = false;
            object.debug("Gradle cache local: " + gradleLocRepo);
        }
        ((DefaultRepositorySystemSession)this.session).setWorkspaceReader(new WorkspaceReader(){
            @NotNull
            private final WorkspaceRepository repository = new WorkspaceRepository("default");

            @NotNull
            public WorkspaceRepository getRepository() {
                return this.repository;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public File findArtifact(@NotNull Artifact artifact) {
                File file;
                File file2;
                Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
                String path = ((DefaultRepositorySystemSession)this.getSession()).getLocalRepositoryManager().getPathForLocalArtifact(artifact);
                File it = file2 = new File(mavenLocRepo, path);
                boolean bl = false;
                File file3 = file = it.isFile() ? file2 : null;
                if (file != null) {
                    it = file;
                    boolean bl2 = false;
                    return it;
                }
                String string = artifact.getGroupId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.groupId");
                File file4 = FilesKt.resolve((File)gradleLocRepo, (String)string);
                String string2 = artifact.getArtifactId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"artifact.artifactId");
                File file5 = FilesKt.resolve((File)file4, (String)string2);
                String string3 = artifact.getBaseVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"artifact.baseVersion");
                File gradleDep = FilesKt.resolve((File)file5, (String)string3);
                if (gradleDep.isDirectory()) {
                    Object v8;
                    Comparable<StringBuilder> comparable;
                    block6: {
                        void $this$firstOrNull$iv;
                        Object it2;
                        StringBuilder $this$findArtifact_u24lambda_u244 = comparable = new StringBuilder();
                        boolean bl3 = false;
                        $this$findArtifact_u24lambda_u244.append(artifact.getArtifactId());
                        $this$findArtifact_u24lambda_u244.append('-');
                        $this$findArtifact_u24lambda_u244.append(artifact.getBaseVersion());
                        String string4 = artifact.getClassifier();
                        Object object = string4;
                        if (object != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classifier");
                            String string5 = string4;
                            it2 = string5;
                            boolean bl4 = false;
                            object = ((CharSequence)it2).length() > 0 ? string5 : null;
                            if (object != null) {
                                String c = object;
                                boolean bl5 = false;
                                $this$findArtifact_u24lambda_u244.append('-').append(c);
                            }
                        }
                        $this$findArtifact_u24lambda_u244.append('.').append(artifact.getExtension());
                        String string6 = comparable.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"StringBuilder().apply(builderAction).toString()");
                        String fileName = string6;
                        $this$findArtifact_u24lambda_u244 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)gradleDep, null, (int)1, null).maxDepth(2)), (Function1)findArtifact.3.INSTANCE);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it2 = (File)element$iv;
                            boolean bl6 = false;
                            if (!Intrinsics.areEqual((Object)((File)it2).getName(), (Object)fileName)) continue;
                            v8 = element$iv;
                            break block6;
                        }
                        v8 = null;
                    }
                    comparable = v8;
                    if (comparable != null) {
                        Comparable<StringBuilder> it3 = comparable;
                        boolean bl7 = false;
                        return it3;
                    }
                }
                return null;
            }

            @NotNull
            public List<String> findVersions(@Nullable Artifact artifact) {
                return new ArrayList();
            }
        });
        ((DefaultRepositorySystemSession)this.session).setReadOnly();
        MiraiConsoleImplementation.ConsoleDataScope.Companion $i$f$debug2 = MiraiConsoleImplementation.ConsoleDataScope.Companion;
        Object $this$get$iv = ConsoleDataScopeImplKt.getDataScope();
        boolean $i$f$get = false;
        PluginDependenciesConfig config2 = (PluginDependenciesConfig)$this$get$iv.get(Reflection.getOrCreateKotlinClass(PluginDependenciesConfig.class));
        $this$get$iv = config2.getRepoLoc();
        RepositorySystemSession repositorySystemSession = this.session;
        RepositorySystem repositorySystem = this.repository;
        object = this;
        boolean $i$f$map = false;
        void var9_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void url;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new RemoteRepository.Builder((String)url, "default", (String)url).build());
        }
        collection = (List)destination$iv$iv;
        List list2 = repositorySystem.newResolutionRepositories(repositorySystemSession, (List)collection);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"repository.newResolution\u2026)\n            }\n        )");
        object.repositories = list2;
        MiraiLogger $this$debug$iv2 = this.logger;
        boolean $i$f$debug3 = false;
        if ($this$debug$iv2.isDebugEnabled()) {
            object = $this$debug$iv2;
            boolean bl = false;
            object.debug("Remote server: " + config2.getRepoLoc());
        }
    }

    @NotNull
    public final MiraiLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    @NotNull
    public final RepositorySystemSession getSession() {
        return this.session;
    }

    @NotNull
    public final ServiceLocator getLocator() {
        return this.locator;
    }

    @NotNull
    public final RepositorySystem getRepository() {
        return this.repository;
    }

    @NotNull
    public final DependencyFilter getDependencyFilter() {
        return this.dependencyFilter;
    }

    @NotNull
    public final DependencyResult resolveDependencies(@NotNull Iterable<String> deps, DependencyFilter ... filters) {
        Intrinsics.checkNotNullParameter(deps, (String)"deps");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        List dependencies = new ArrayList();
        for (String library : deps) {
            DefaultArtifact defaultArtifact = new DefaultArtifact(library);
            Dependency dependency = new Dependency((Artifact)defaultArtifact, null);
            dependencies.add(dependency);
        }
        DependencyResult dependencyResult = this.repository.resolveDependencies(this.session, new DependencyRequest(new CollectRequest(null, dependencies, this.repositories), filters.length == 0 ? this.dependencyFilter : (arg_0, arg_1) -> JvmPluginDependencyDownloader.resolveDependencies$lambda$9(this, filters, arg_0, arg_1)));
        Intrinsics.checkNotNullExpressionValue((Object)dependencyResult, (String)"repository.resolveDepend\u2026}\n            )\n        )");
        return dependencyResult;
    }

    private static final boolean dependencyFilter$lambda$0(DependencyNode node, List list2) {
        Object[] objectArray;
        if (node == null || node.getArtifact() == null) {
            return true;
        }
        String artGroup = node.getArtifact().getGroupId();
        String artId = node.getArtifact().getArtifactId();
        if (Intrinsics.areEqual((Object)artGroup, (Object)"net.mamoe") && CollectionsKt.listOf((Object[])(objectArray = new String[]{"mirai-core", "mirai-core-jvm", "mirai-core-android", "mirai-core-api", "mirai-core-api-jvm", "mirai-core-api-android", "mirai-core-utils", "mirai-core-utils-jvm", "mirai-core-utils-android", "mirai-console", "mirai-console-terminal", "mirai-console-frontend-base"})).contains(artId)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)artGroup, (Object)"org.slf4j") && Intrinsics.areEqual((Object)artId, (Object)"slf4j-api")) {
            return false;
        }
        return !MiraiConsoleBuildDependencies.INSTANCE.getDependencies().contains(artGroup + ':' + artId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final File findMavenLocal$findFromSettingsXml(File mavenHome) {
        File settings = new File(mavenHome, "settings.xml");
        if (!settings.isFile()) {
            return null;
        }
        Closeable closeable = (Closeable)ReaderFactory.newXmlReader((File)settings);
        Throwable throwable = null;
        try {
            XmlStreamReader reader = (XmlStreamReader)closeable;
            boolean bl = false;
            MXParser parser = new MXParser();
            parser.setInput((Reader)reader);
            int eventType = parser.getEventType();
            boolean joinedSettings = false;
            while (eventType != 1) {
                if (eventType == 2) {
                    if (!joinedSettings) {
                        if (!Intrinsics.areEqual((Object)parser.getName(), (Object)"settings")) {
                            File file = null;
                            return file;
                        }
                        joinedSettings = true;
                    } else {
                        if (Intrinsics.areEqual((Object)parser.getName(), (Object)"localRepository")) {
                            File loc = new File(parser.nextText());
                            if (loc.isDirectory()) {
                                File file = loc;
                                return file;
                            }
                            File file = null;
                            return file;
                        }
                        parser.skipSubTree();
                    }
                }
                eventType = parser.next();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return null;
    }

    private static final File _init_$findMavenLocal(String userHome, JvmPluginDependencyDownloader this$0) {
        File file;
        Object object;
        File mavenHome = new File(userHome, ".m2");
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)JvmPluginDependencyDownloader.findMavenLocal$findFromSettingsXml(mavenHome));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            boolean bl = false;
            this$0.logger.warning(error);
        }
        if ((file = (File)(Result.isFailure-impl((Object)object) ? null : object)) == null) {
            file = new File(mavenHome, "repository");
        }
        return file;
    }

    private static final File _init_$findGradleDepCache(String userHome) {
        String gradleEnvHome;
        File gradleHome = new File(userHome, ".gradle");
        String string = System.getenv("GRADLE_USER_HOME");
        if (string == null) {
            string = "";
        }
        if (!StringsKt.isBlank((CharSequence)(gradleEnvHome = string))) {
            gradleHome = new File(gradleEnvHome);
        }
        return new File(gradleHome, "caches/modules-2/files-2.1");
    }

    private static final boolean resolveDependencies$lambda$9(JvmPluginDependencyDownloader this$0, DependencyFilter[] $filters, DependencyNode node, List parents) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$filters, (String)"$filters");
        if (node == null || node.getArtifact() == null) {
            return true;
        }
        if (!this$0.dependencyFilter.accept(node, parents)) {
            return false;
        }
        DependencyFilter[] $this$forEach$iv = $filters;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DependencyFilter element$iv;
            DependencyFilter filter = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            if (filter.accept(node, parents)) continue;
            return false;
        }
        return true;
    }
}

