/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.plugin.description;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.mamoe.mirai.console.compiler.common.CheckerConstants;
import net.mamoe.mirai.console.compiler.common.ResolveContext;
import net.mamoe.mirai.console.plugin.description.IllegalPluginDescriptionException;
import net.mamoe.mirai.console.plugin.description.PluginDependency;
import net.mamoe.mirai.console.util.SemVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u00038&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u0005R\u0012\u0010\u000f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0005R\u001a\u0010\u0011\u001a\u00020\u00038&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\r\u001a\u0004\b\u0013\u0010\u0005R\u001a\u0010\u0014\u001a\u00020\u00158&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\r\u001a\u0004\b\u0017\u0010\u0018\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001a\u00c0\u0006\u0001"}, d2={"Lnet/mamoe/mirai/console/plugin/description/PluginDescription;", "", "author", "", "getAuthor", "()Ljava/lang/String;", "dependencies", "", "Lnet/mamoe/mirai/console/plugin/description/PluginDependency;", "getDependencies", "()Ljava/util/Set;", "id", "getId$annotations", "()V", "getId", "info", "getInfo", "name", "getName$annotations", "getName", "version", "Lnet/mamoe/mirai/console/util/SemVersion;", "getVersion$annotations", "getVersion", "()Lnet/mamoe/mirai/console/util/SemVersion;", "Companion", "mirai-console"})
public interface PluginDescription {
    @NotNull
    public static final Companion Companion = net.mamoe.mirai.console.plugin.description.PluginDescription$Companion.$$INSTANCE;

    @NotNull
    public String getId();

    @ResolveContext(kinds={ResolveContext.Kind.PLUGIN_ID})
    public static /* synthetic */ void getId$annotations() {
    }

    @NotNull
    public String getName();

    @ResolveContext(kinds={ResolveContext.Kind.PLUGIN_NAME})
    public static /* synthetic */ void getName$annotations() {
    }

    @NotNull
    public String getAuthor();

    @NotNull
    public SemVersion getVersion();

    @ResolveContext(kinds={ResolveContext.Kind.SEMANTIC_VERSION})
    public static /* synthetic */ void getVersion$annotations() {
    }

    @NotNull
    public String getInfo();

    @NotNull
    public Set<PluginDependency> getDependencies();

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0005R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lnet/mamoe/mirai/console/plugin/description/PluginDescription$Companion;", "", "()V", "FORBIDDEN_ID_NAMES", "", "", "getFORBIDDEN_ID_NAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "ID_REGEX", "Lkotlin/text/Regex;", "getID_REGEX", "()Lkotlin/text/Regex;", "checkDependencies", "", "pluginId", "dependencies", "", "Lnet/mamoe/mirai/console/plugin/description/PluginDependency;", "checkPluginDescription", "instance", "Lnet/mamoe/mirai/console/plugin/description/PluginDescription;", "checkPluginId", "id", "checkPluginName", "name", "mirai-console"})
    @SourceDebugExtension(value={"SMAP\nPluginDescription.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginDescription.kt\nnet/mamoe/mirai/console/plugin/description/PluginDescription$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n1766#2,2:207\n1282#3,2:209\n1282#3,2:211\n1620#4,3:213\n1747#4,3:216\n*S KotlinDebug\n*F\n+ 1 PluginDescription.kt\nnet/mamoe/mirai/console/plugin/description/PluginDescription$Companion\n*L\n160#1:207,2\n168#1:209,2\n182#1:211,2\n195#1:213,3\n200#1:216,3\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Regex ID_REGEX;
        @NotNull
        private static final String[] FORBIDDEN_ID_NAMES;

        private Companion() {
        }

        @NotNull
        public final Regex getID_REGEX() {
            return ID_REGEX;
        }

        @NotNull
        public final String[] getFORBIDDEN_ID_NAMES() {
            return FORBIDDEN_ID_NAMES;
        }

        public final void checkPluginDescription(@NotNull PluginDescription instance2) throws IllegalPluginDescriptionException {
            Object object;
            Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
            try {
                boolean bl = false;
                $$INSTANCE.checkPluginId(instance2.getId());
                $$INSTANCE.checkPluginName(instance2.getName());
                $$INSTANCE.checkDependencies(instance2.getId(), instance2.getDependencies());
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                throw new IllegalPluginDescriptionException("Illegal PluginDescription. Plugin " + instance2.getName() + " (" + instance2.getId() + ')', it);
            }
        }

        public final void checkPluginId(@NotNull String id) throws IllegalPluginDescriptionException {
            String string;
            block7: {
                String string2;
                boolean bl;
                int it;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                    if (StringsKt.isBlank((CharSequence)id)) {
                        throw new IllegalPluginDescriptionException("Plugin id cannot be blank");
                    }
                    CharSequence $this$none$iv = id;
                    boolean $i$f$none = false;
                    for (int j = 0; j < $this$none$iv.length(); ++j) {
                        int element$iv;
                        it = element$iv = $this$none$iv.charAt(j);
                        boolean bl2 = false;
                        if (!(it == 46)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
                if (bl) {
                    throw new IllegalPluginDescriptionException('\'' + id + "' is illegal. Plugin id must consist of both domain and name. ");
                }
                String string3 = id.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                String lowercaseId = string3;
                if (ID_REGEX.matchEntire((CharSequence)id) == null) {
                    throw new IllegalPluginDescriptionException("Plugin does not match regex '" + ID_REGEX.getPattern() + "'.");
                }
                String[] $this$firstOrNull$iv = FORBIDDEN_ID_NAMES;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (it = 0; it < n; ++it) {
                    String element$iv;
                    String it2 = element$iv = $this$firstOrNull$iv[it];
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it2, (Object)lowercaseId)) continue;
                    string2 = element$iv;
                    break block7;
                }
                string2 = string = null;
            }
            if (string != null) {
                String illegal = string;
                boolean bl = false;
                throw new IllegalPluginDescriptionException("Plugin id contains illegal word: '" + illegal + "'.");
            }
        }

        public final void checkPluginName(@NotNull String name) throws IllegalPluginDescriptionException {
            String string;
            block3: {
                String string2;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                if (StringsKt.isBlank((CharSequence)name)) {
                    throw new IllegalPluginDescriptionException("Plugin name cannot be blank");
                }
                String string3 = name.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                String lowercaseName = string3;
                String[] $this$firstOrNull$iv = FORBIDDEN_ID_NAMES;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int j = 0; j < n; ++j) {
                    String element$iv;
                    String it = element$iv = $this$firstOrNull$iv[j];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)lowercaseName)) continue;
                    string2 = element$iv;
                    break block3;
                }
                string2 = string = null;
            }
            if (string != null) {
                String illegal = string;
                boolean bl = false;
                throw new IllegalPluginDescriptionException("Plugin name is illegal: '" + illegal + "'.");
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void checkDependencies(@NotNull String pluginId, @NotNull Set<PluginDependency> dependencies) throws IllegalPluginDescriptionException {
            boolean bl;
            block6: {
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
                Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
                String string = pluginId.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                String lowercaseId = string;
                Iterable iterable = dependencies;
                Collection destination$iv = new LinkedHashSet(dependencies.size());
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    PluginDependency pluginDependency = (PluginDependency)item$iv;
                    Collection collection = destination$iv;
                    boolean bl2 = false;
                    String string2 = it.getId().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    collection.add(string2);
                }
                LinkedHashSet lowercaseDependencies = (LinkedHashSet)destination$iv;
                if (lowercaseDependencies.size() != dependencies.size()) {
                    throw new IllegalPluginDescriptionException("Duplicated dependency detected: A plugin cannot depend on different versions of dependencies of the same id");
                }
                Iterable $this$any$iv = lowercaseDependencies;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)lowercaseId)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new IllegalPluginDescriptionException("Recursive dependency detected: A plugin cannot depend on itself");
            }
        }

        static {
            $$INSTANCE = new Companion();
            ID_REGEX = CheckerConstants.PLUGIN_ID_REGEX;
            FORBIDDEN_ID_NAMES = CheckerConstants.PLUGIN_FORBIDDEN_NAMES;
        }
    }
}

