/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.internal.logging;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.console.logging.LoggerController;
import net.mamoe.mirai.utils.MiraiLogger;
import net.mamoe.mirai.utils.MiraiLoggerPlatformBase;
import net.mamoe.mirai.utils.SimpleLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\u001c\u0010\u001c\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\u001c\u0010\u001d\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\u001c\u0010\u001e\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\u001c\u0010\u001f\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lnet/mamoe/mirai/console/internal/logging/MiraiConsoleLogger;", "Lnet/mamoe/mirai/utils/MiraiLoggerPlatformBase;", "controller", "Lnet/mamoe/mirai/console/logging/LoggerController;", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "(Lnet/mamoe/mirai/console/logging/LoggerController;Lnet/mamoe/mirai/utils/MiraiLogger;)V", "identity", "", "getIdentity", "()Ljava/lang/String;", "isDebugEnabled", "", "()Z", "isEnabled", "isErrorEnabled", "isInfoEnabled", "isVerboseEnabled", "isWarningEnabled", "logState", "Lnet/mamoe/mirai/console/logging/LoggerController$LoggerControlState;", "getLogger", "()Lnet/mamoe/mirai/utils/MiraiLogger;", "debug0", "", "message", "e", "", "error0", "info0", "verbose0", "warning0", "mirai-console"})
public final class MiraiConsoleLogger
extends MiraiLoggerPlatformBase {
    @NotNull
    private final MiraiLogger logger;
    @NotNull
    private final LoggerController.LoggerControlState logState;

    public MiraiConsoleLogger(@NotNull LoggerController controller, @NotNull MiraiLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
        this.logState = controller.getLoggerControlState(this.getIdentity());
    }

    @NotNull
    public final MiraiLogger getLogger() {
        return this.logger;
    }

    @Nullable
    public String getIdentity() {
        return this.logger.getIdentity();
    }

    public boolean isEnabled() {
        return this.logger.isEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logState.shouldLog(SimpleLogger.LogPriority.INFO);
    }

    public boolean isWarningEnabled() {
        return this.logState.shouldLog(SimpleLogger.LogPriority.WARNING);
    }

    public boolean isDebugEnabled() {
        return this.logState.shouldLog(SimpleLogger.LogPriority.DEBUG);
    }

    public boolean isErrorEnabled() {
        return this.logState.shouldLog(SimpleLogger.LogPriority.ERROR);
    }

    public boolean isVerboseEnabled() {
        return this.logState.shouldLog(SimpleLogger.LogPriority.VERBOSE);
    }

    protected void info0(@Nullable String message, @Nullable Throwable e) {
        if (this.logState.shouldLog(SimpleLogger.LogPriority.INFO)) {
            this.logger.info(message, e);
        }
    }

    protected void warning0(@Nullable String message, @Nullable Throwable e) {
        if (this.logState.shouldLog(SimpleLogger.LogPriority.WARNING)) {
            this.logger.warning(message, e);
        }
    }

    protected void debug0(@Nullable String message, @Nullable Throwable e) {
        if (this.logState.shouldLog(SimpleLogger.LogPriority.DEBUG)) {
            this.logger.debug(message, e);
        }
    }

    protected void error0(@Nullable String message, @Nullable Throwable e) {
        if (this.logState.shouldLog(SimpleLogger.LogPriority.ERROR)) {
            this.logger.error(message, e);
        }
    }

    protected void verbose0(@Nullable String message, @Nullable Throwable e) {
        if (this.logState.shouldLog(SimpleLogger.LogPriority.VERBOSE)) {
            this.logger.verbose(message, e);
        }
    }
}

