/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CookieDateParser;
import io.ktor.http.InvalidCookieDateException;
import io.ktor.util.date.GMTDate;
import io.ktor.util.date.GMTDateParser;
import io.ktor.util.date.InvalidDateStringException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\u0002\u001a\u0014\u0010\b\u001a\u00020\u0002*\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a\n\u0010\u000b\u001a\u00020\u0002*\u00020\u0006\"\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0003\u0010\u0004\u00a8\u0006\f"}, d2={"HTTP_DATE_FORMATS", "", "", "getHTTP_DATE_FORMATS$annotations", "()V", "fromCookieToGmtDate", "Lio/ktor/util/date/GMTDate;", "fromHttpToGmtDate", "padZero", "", "length", "toHttpDate", "ktor-http"})
public final class DateUtilsKt {
    private static final List<String> HTTP_DATE_FORMATS = CollectionsKt.listOf("***, dd MMM YYYY hh:mm:ss zzz", "****, dd-MMM-YYYY hh:mm:ss zzz", "*** MMM d hh:mm:ss YYYY", "***, dd-MMM-YYYY hh:mm:ss zzz", "***, dd-MMM-YYYY hh-mm-ss zzz", "***, dd MMM YYYY hh:mm:ss zzz", "*** dd-MMM-YYYY hh:mm:ss zzz", "*** dd MMM YYYY hh:mm:ss zzz", "*** dd-MMM-YYYY hh-mm-ss zzz", "***,dd-MMM-YYYY hh:mm:ss zzz", "*** MMM d YYYY hh:mm:ss zzz");

    private static /* synthetic */ void getHTTP_DATE_FORMATS$annotations() {
    }

    @NotNull
    public static final GMTDate fromHttpToGmtDate(@NotNull String $this$fromHttpToGmtDate) {
        Intrinsics.checkNotNullParameter($this$fromHttpToGmtDate, "$this$fromHttpToGmtDate");
        String string = $this$fromHttpToGmtDate;
        boolean bl = false;
        string = ((Object)StringsKt.trim((CharSequence)string)).toString();
        bl = false;
        boolean bl2 = false;
        String $this$with = string;
        boolean bl3 = false;
        for (String format2 : HTTP_DATE_FORMATS) {
            try {
                GMTDateParser parser = new GMTDateParser(format2);
                return parser.parse($this$fromHttpToGmtDate);
            }
            catch (InvalidDateStringException invalidDateStringException) {
            }
        }
        String string2 = "Failed to parse date: " + $this$with;
        boolean bl4 = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    @NotNull
    public static final GMTDate fromCookieToGmtDate(@NotNull String $this$fromCookieToGmtDate) {
        Intrinsics.checkNotNullParameter($this$fromCookieToGmtDate, "$this$fromCookieToGmtDate");
        String string = $this$fromCookieToGmtDate;
        boolean bl = false;
        string = ((Object)StringsKt.trim((CharSequence)string)).toString();
        bl = false;
        boolean bl2 = false;
        String $this$with = string;
        boolean bl3 = false;
        try {
            CookieDateParser parser = new CookieDateParser();
            return parser.parse($this$with);
        }
        catch (InvalidCookieDateException invalidCookieDateException) {
            return DateUtilsKt.fromHttpToGmtDate($this$with);
        }
    }

    @NotNull
    public static final String toHttpDate(@NotNull GMTDate $this$toHttpDate) {
        Intrinsics.checkNotNullParameter($this$toHttpDate, "$this$toHttpDate");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        $this$buildString.append($this$toHttpDate.getDayOfWeek().getValue() + ", ");
        $this$buildString.append(DateUtilsKt.padZero($this$toHttpDate.getDayOfMonth(), 2) + ' ');
        $this$buildString.append($this$toHttpDate.getMonth().getValue() + ' ');
        $this$buildString.append(DateUtilsKt.padZero($this$toHttpDate.getYear(), 4));
        $this$buildString.append(' ' + DateUtilsKt.padZero($this$toHttpDate.getHours(), 2) + ':' + DateUtilsKt.padZero($this$toHttpDate.getMinutes(), 2) + ':' + DateUtilsKt.padZero($this$toHttpDate.getSeconds(), 2) + ' ');
        $this$buildString.append("GMT");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final String padZero(int $this$padZero, int length2) {
        return StringsKt.padStart(String.valueOf($this$padZero), length2, '0');
    }
}

