/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio;

import io.ktor.http.cio.ConnectionOptions;
import io.ktor.http.cio.internals.AsciiCharTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\bH\u0002J\u0013\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lio/ktor/http/cio/ConnectionOptions;", "", "close", "", "keepAlive", "upgrade", "extraOptions", "", "", "(ZZZLjava/util/List;)V", "getClose", "()Z", "getExtraOptions", "()Ljava/util/List;", "getKeepAlive", "getUpgrade", "buildToString", "equals", "other", "hashCode", "", "toString", "Companion", "ktor-http-cio"})
public final class ConnectionOptions {
    private final boolean close;
    private final boolean keepAlive;
    private final boolean upgrade;
    @NotNull
    private final List<String> extraOptions;
    @NotNull
    private static final ConnectionOptions Close;
    @NotNull
    private static final ConnectionOptions KeepAlive;
    @NotNull
    private static final ConnectionOptions Upgrade;
    private static final AsciiCharTree<Pair<String, ConnectionOptions>> knownTypes;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String toString() {
        return this.extraOptions.isEmpty() ? (this.close && !this.keepAlive && !this.upgrade ? "close" : (!this.close && this.keepAlive && !this.upgrade ? "keep-alive" : (!this.close && this.keepAlive && this.upgrade ? "keep-alive, Upgrade" : this.buildToString()))) : this.buildToString();
    }

    private final String buildToString() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        ArrayList<String> items2 = new ArrayList<String>(this.extraOptions.size() + 3);
        if (this.close) {
            items2.add("close");
        }
        if (this.keepAlive) {
            items2.add("keep-alive");
        }
        if (this.upgrade) {
            items2.add("Upgrade");
        }
        Collection collection = this.extraOptions;
        boolean bl6 = false;
        if (!collection.isEmpty()) {
            items2.addAll((Collection)this.extraOptions);
        }
        CollectionsKt.joinTo$default(items2, $this$buildString, null, null, null, 0, null, null, 126, null);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(Reflection.getOrCreateKotlinClass(this.getClass()), Reflection.getOrCreateKotlinClass(other.getClass())) ^ true) {
            return false;
        }
        ConnectionOptions cfr_ignored_0 = (ConnectionOptions)other;
        if (this.close != ((ConnectionOptions)other).close) {
            return false;
        }
        if (this.keepAlive != ((ConnectionOptions)other).keepAlive) {
            return false;
        }
        if (this.upgrade != ((ConnectionOptions)other).upgrade) {
            return false;
        }
        return !(Intrinsics.areEqual(this.extraOptions, ((ConnectionOptions)other).extraOptions) ^ true);
    }

    public int hashCode() {
        int result2 = ((Object)this.close).hashCode();
        result2 = 31 * result2 + ((Object)this.keepAlive).hashCode();
        result2 = 31 * result2 + ((Object)this.upgrade).hashCode();
        result2 = 31 * result2 + ((Object)this.extraOptions).hashCode();
        return result2;
    }

    public final boolean getClose() {
        return this.close;
    }

    public final boolean getKeepAlive() {
        return this.keepAlive;
    }

    public final boolean getUpgrade() {
        return this.upgrade;
    }

    @NotNull
    public final List<String> getExtraOptions() {
        return this.extraOptions;
    }

    public ConnectionOptions(boolean close2, boolean keepAlive, boolean upgrade, @NotNull List<String> extraOptions) {
        Intrinsics.checkNotNullParameter(extraOptions, "extraOptions");
        this.close = close2;
        this.keepAlive = keepAlive;
        this.upgrade = upgrade;
        this.extraOptions = extraOptions;
    }

    public /* synthetic */ ConnectionOptions(boolean bl, boolean bl2, boolean bl3, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(bl, bl2, bl3, list2);
    }

    public ConnectionOptions() {
        this(false, false, false, null, 15, null);
    }

    static {
        Companion = new Companion(null);
        Close = new ConnectionOptions(true, false, false, null, 14, null);
        KeepAlive = new ConnectionOptions(false, true, false, null, 13, null);
        Upgrade = new ConnectionOptions(false, false, true, null, 11, null);
        knownTypes = AsciiCharTree.Companion.build(CollectionsKt.listOf(TuplesKt.to("close", Close), TuplesKt.to("keep-alive", KeepAlive), TuplesKt.to("upgrade", Upgrade)), Companion.knownTypes.1.INSTANCE, Companion.knownTypes.2.INSTANCE);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ktor/http/cio/ConnectionOptions$Companion;", "", "()V", "Close", "Lio/ktor/http/cio/ConnectionOptions;", "getClose", "()Lio/ktor/http/cio/ConnectionOptions;", "KeepAlive", "getKeepAlive", "Upgrade", "getUpgrade", "knownTypes", "Lio/ktor/http/cio/internals/AsciiCharTree;", "Lkotlin/Pair;", "", "parse", "connection", "", "parseSlow", "ktor-http-cio"})
    public static final class Companion {
        @NotNull
        public final ConnectionOptions getClose() {
            return Close;
        }

        @NotNull
        public final ConnectionOptions getKeepAlive() {
            return KeepAlive;
        }

        @NotNull
        public final ConnectionOptions getUpgrade() {
            return Upgrade;
        }

        @Nullable
        public final ConnectionOptions parse(@Nullable CharSequence connection2) {
            if (connection2 == null) {
                return null;
            }
            List known2 = AsciiCharTree.search$default(knownTypes, connection2, 0, 0, true, parse.known.1.INSTANCE, 6, null);
            if (known2.size() == 1) {
                return (ConnectionOptions)((Pair)known2.get(0)).getSecond();
            }
            return this.parseSlow(connection2);
        }

        private final ConnectionOptions parseSlow(CharSequence connection2) {
            int idx = 0;
            int start2 = 0;
            int length2 = connection2.length();
            ConnectionOptions connectionOptions = null;
            ArrayList<String> hopHeadersList = null;
            while (idx < length2) {
                char ch;
                do {
                    if ((ch = connection2.charAt(idx)) == ' ' || ch == ',') continue;
                    start2 = idx;
                    break;
                } while (++idx < length2);
                while (idx < length2 && (ch = connection2.charAt(idx)) != ' ' && ch != ',') {
                    ++idx;
                }
                Pair detected2 = (Pair)CollectionsKt.singleOrNull(knownTypes.search(connection2, start2, idx, true, parseSlow.detected.1.INSTANCE));
                if (detected2 == null) {
                    if (hopHeadersList == null) {
                        hopHeadersList = new ArrayList<String>();
                    }
                    CharSequence charSequence = connection2;
                    boolean bl = false;
                    hopHeadersList.add(((Object)charSequence.subSequence(start2, idx)).toString());
                    continue;
                }
                if (connectionOptions == null) {
                    connectionOptions = (ConnectionOptions)detected2.getSecond();
                    continue;
                }
                connectionOptions = new ConnectionOptions(connectionOptions.getClose() || ((ConnectionOptions)detected2.getSecond()).getClose(), connectionOptions.getKeepAlive() || ((ConnectionOptions)detected2.getSecond()).getKeepAlive(), connectionOptions.getUpgrade() || ((ConnectionOptions)detected2.getSecond()).getUpgrade(), CollectionsKt.<String>emptyList());
            }
            if (connectionOptions == null) {
                connectionOptions = this.getKeepAlive();
            }
            return hopHeadersList == null ? connectionOptions : new ConnectionOptions(connectionOptions.getClose(), connectionOptions.getKeepAlive(), connectionOptions.getUpgrade(), (List<String>)hopHeadersList);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

