/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.ComposedLastHttpContent;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpMessage;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public abstract class HttpContentDecoder
extends MessageToMessageDecoder<HttpObject> {
    static final String IDENTITY = HttpHeaderValues.IDENTITY.toString();
    protected ChannelHandlerContext ctx;
    private EmbeddedChannel decoder;
    private boolean continueResponse;
    private boolean needRead = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out2) throws Exception {
        try {
            if (msg instanceof HttpResponse && ((HttpResponse)msg).status().code() == 100) {
                if (!(msg instanceof LastHttpContent)) {
                    this.continueResponse = true;
                }
                out2.add(ReferenceCountUtil.retain(msg));
                return;
            }
            if (this.continueResponse) {
                if (msg instanceof LastHttpContent) {
                    this.continueResponse = false;
                }
                out2.add(ReferenceCountUtil.retain(msg));
                return;
            }
            if (msg instanceof HttpMessage) {
                String targetContentEncoding;
                int idx;
                String transferEncoding;
                this.cleanup();
                HttpMessage message2 = (HttpMessage)msg;
                HttpHeaders headers = message2.headers();
                String contentEncoding = headers.get(HttpHeaderNames.CONTENT_ENCODING);
                contentEncoding = contentEncoding != null ? contentEncoding.trim() : ((transferEncoding = headers.get(HttpHeaderNames.TRANSFER_ENCODING)) != null ? ((idx = transferEncoding.indexOf(",")) != -1 ? transferEncoding.substring(0, idx).trim() : transferEncoding.trim()) : IDENTITY);
                this.decoder = this.newContentDecoder(contentEncoding);
                if (this.decoder == null) {
                    if (message2 instanceof HttpContent) {
                        ((HttpContent)((Object)message2)).retain();
                    }
                    out2.add(message2);
                    return;
                }
                if (headers.contains(HttpHeaderNames.CONTENT_LENGTH)) {
                    headers.remove(HttpHeaderNames.CONTENT_LENGTH);
                    headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                }
                if (HttpHeaderValues.IDENTITY.contentEquals(targetContentEncoding = this.getTargetContentEncoding(contentEncoding))) {
                    headers.remove(HttpHeaderNames.CONTENT_ENCODING);
                } else {
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)targetContentEncoding);
                }
                if (message2 instanceof HttpContent) {
                    DefaultHttpMessage copy2;
                    if (message2 instanceof HttpRequest) {
                        HttpRequest r = (HttpRequest)message2;
                        copy2 = new DefaultHttpRequest(r.protocolVersion(), r.method(), r.uri());
                    } else if (message2 instanceof HttpResponse) {
                        HttpResponse r = (HttpResponse)message2;
                        copy2 = new DefaultHttpResponse(r.protocolVersion(), r.status());
                    } else {
                        throw new CodecException("Object of class " + message2.getClass().getName() + " is not an HttpRequest or HttpResponse");
                    }
                    copy2.headers().set(message2.headers());
                    copy2.setDecoderResult(message2.decoderResult());
                    out2.add(copy2);
                } else {
                    out2.add(message2);
                }
            }
            if (msg instanceof HttpContent) {
                HttpContent c = (HttpContent)msg;
                if (this.decoder == null) {
                    out2.add(c.retain());
                } else {
                    this.decodeContent(c, out2);
                }
            }
        }
        finally {
            this.needRead = out2.isEmpty();
        }
    }

    private void decodeContent(HttpContent c, List<Object> out2) {
        ByteBuf content2 = c.content();
        this.decode(content2, out2);
        if (c instanceof LastHttpContent) {
            this.finishDecode(out2);
            LastHttpContent last2 = (LastHttpContent)c;
            HttpHeaders headers = last2.trailingHeaders();
            if (headers.isEmpty()) {
                out2.add(LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                out2.add(new ComposedLastHttpContent(headers, DecoderResult.SUCCESS));
            }
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        boolean needRead = this.needRead;
        this.needRead = true;
        try {
            ctx.fireChannelReadComplete();
        }
        finally {
            if (needRead && !ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
        }
    }

    protected abstract EmbeddedChannel newContentDecoder(String var1) throws Exception;

    protected String getTargetContentEncoding(String contentEncoding) throws Exception {
        return IDENTITY;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.cleanupSafely(ctx);
        super.handlerRemoved(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cleanupSafely(ctx);
        super.channelInactive(ctx);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        super.handlerAdded(ctx);
    }

    private void cleanup() {
        if (this.decoder != null) {
            this.decoder.finishAndReleaseAll();
            this.decoder = null;
        }
    }

    private void cleanupSafely(ChannelHandlerContext ctx) {
        try {
            this.cleanup();
        }
        catch (Throwable cause) {
            ctx.fireExceptionCaught(cause);
        }
    }

    private void decode(ByteBuf in, List<Object> out2) {
        this.decoder.writeInbound(in.retain());
        this.fetchDecoderOutput(out2);
    }

    private void finishDecode(List<Object> out2) {
        if (this.decoder.finish()) {
            this.fetchDecoderOutput(out2);
        }
        this.decoder = null;
    }

    private void fetchDecoderOutput(List<Object> out2) {
        ByteBuf buf;
        while ((buf = (ByteBuf)this.decoder.readInbound()) != null) {
            if (!buf.isReadable()) {
                buf.release();
                continue;
            }
            out2.add(new DefaultHttpContent(buf));
        }
    }
}

