/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;

public class InboundHttpToHttp2Adapter
extends ChannelInboundHandlerAdapter {
    private final Http2Connection connection;
    private final Http2FrameListener listener;

    public InboundHttpToHttp2Adapter(Http2Connection connection2, Http2FrameListener listener2) {
        this.connection = connection2;
        this.listener = listener2;
    }

    private static int getStreamId(Http2Connection connection2, HttpHeaders httpHeaders) {
        return httpHeaders.getInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), connection2.remote().incrementAndGetNextStreamId());
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpMessage) {
            InboundHttpToHttp2Adapter.handle(ctx, this.connection, this.listener, (FullHttpMessage)msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handle(ChannelHandlerContext ctx, Http2Connection connection2, Http2FrameListener listener2, FullHttpMessage message2) throws Http2Exception {
        try {
            int streamId = InboundHttpToHttp2Adapter.getStreamId(connection2, message2.headers());
            Http2Stream stream = connection2.stream(streamId);
            if (stream == null) {
                stream = connection2.remote().createStream(streamId, false);
            }
            message2.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)HttpScheme.HTTP.name());
            Http2Headers messageHeaders = HttpConversionUtil.toHttp2Headers(message2, true);
            boolean hasContent = message2.content().isReadable();
            boolean hasTrailers = !message2.trailingHeaders().isEmpty();
            listener2.onHeadersRead(ctx, streamId, messageHeaders, 0, !hasContent && !hasTrailers);
            if (hasContent) {
                listener2.onDataRead(ctx, streamId, message2.content(), 0, !hasTrailers);
            }
            if (hasTrailers) {
                Http2Headers headers = HttpConversionUtil.toHttp2Headers(message2.trailingHeaders(), true);
                listener2.onHeadersRead(ctx, streamId, headers, 0, true);
            }
            stream.closeRemoteSide();
        }
        finally {
            message2.release();
        }
    }
}

