/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.memcache.AbstractMemcacheObjectAggregator;
import io.netty.handler.codec.memcache.FullMemcacheMessage;
import io.netty.handler.codec.memcache.MemcacheObject;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheMessage;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheResponse;
import io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheResponse;
import io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;

public class BinaryMemcacheObjectAggregator
extends AbstractMemcacheObjectAggregator<BinaryMemcacheMessage> {
    public BinaryMemcacheObjectAggregator(int maxContentLength) {
        super(maxContentLength);
    }

    @Override
    protected boolean isStartMessage(MemcacheObject msg) throws Exception {
        return msg instanceof BinaryMemcacheMessage;
    }

    @Override
    protected FullMemcacheMessage beginAggregation(BinaryMemcacheMessage start2, ByteBuf content2) throws Exception {
        if (start2 instanceof BinaryMemcacheRequest) {
            return BinaryMemcacheObjectAggregator.toFullRequest((BinaryMemcacheRequest)start2, content2);
        }
        if (start2 instanceof BinaryMemcacheResponse) {
            return BinaryMemcacheObjectAggregator.toFullResponse((BinaryMemcacheResponse)start2, content2);
        }
        throw new Error();
    }

    private static FullBinaryMemcacheRequest toFullRequest(BinaryMemcacheRequest request2, ByteBuf content2) {
        ByteBuf key = request2.key() == null ? null : request2.key().retain();
        ByteBuf extras = request2.extras() == null ? null : request2.extras().retain();
        DefaultFullBinaryMemcacheRequest fullRequest = new DefaultFullBinaryMemcacheRequest(key, extras, content2);
        fullRequest.setMagic(request2.magic());
        fullRequest.setOpcode(request2.opcode());
        fullRequest.setKeyLength(request2.keyLength());
        fullRequest.setExtrasLength(request2.extrasLength());
        fullRequest.setDataType(request2.dataType());
        fullRequest.setTotalBodyLength(request2.totalBodyLength());
        fullRequest.setOpaque(request2.opaque());
        fullRequest.setCas(request2.cas());
        fullRequest.setReserved(request2.reserved());
        return fullRequest;
    }

    private static FullBinaryMemcacheResponse toFullResponse(BinaryMemcacheResponse response2, ByteBuf content2) {
        ByteBuf key = response2.key() == null ? null : response2.key().retain();
        ByteBuf extras = response2.extras() == null ? null : response2.extras().retain();
        DefaultFullBinaryMemcacheResponse fullResponse = new DefaultFullBinaryMemcacheResponse(key, extras, content2);
        fullResponse.setMagic(response2.magic());
        fullResponse.setOpcode(response2.opcode());
        fullResponse.setKeyLength(response2.keyLength());
        fullResponse.setExtrasLength(response2.extrasLength());
        fullResponse.setDataType(response2.dataType());
        fullResponse.setTotalBodyLength(response2.totalBodyLength());
        fullResponse.setOpaque(response2.opaque());
        fullResponse.setCas(response2.cas());
        fullResponse.setStatus(response2.status());
        return fullResponse;
    }
}

