/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.resolver.dns.AuthoritativeDnsServerCache;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.SequentialDnsServerAddressStream;
import io.netty.util.internal.ObjectUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

final class AuthoritativeDnsServerCacheAdapter
implements AuthoritativeDnsServerCache {
    private static final DnsRecord[] EMPTY = new DnsRecord[0];
    private final DnsCache cache;

    AuthoritativeDnsServerCacheAdapter(DnsCache cache2) {
        this.cache = ObjectUtil.checkNotNull(cache2, "cache");
    }

    @Override
    public DnsServerAddressStream get(String hostname) {
        List<? extends DnsCacheEntry> entries2 = this.cache.get(hostname, EMPTY);
        if (entries2 == null || entries2.isEmpty()) {
            return null;
        }
        if (entries2.get(0).cause() != null) {
            return null;
        }
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>(entries2.size());
        int i2 = 0;
        do {
            InetAddress addr = entries2.get(i2).address();
            addresses.add(new InetSocketAddress(addr, 53));
        } while (++i2 < entries2.size());
        return new SequentialDnsServerAddressStream(addresses, 0);
    }

    @Override
    public void cache(String hostname, InetSocketAddress address, long originalTtl, EventLoop loop2) {
        if (!address.isUnresolved()) {
            this.cache.cache(hostname, EMPTY, address.getAddress(), originalTtl, loop2);
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public boolean clear(String hostname) {
        return this.cache.clear(hostname);
    }
}

