/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.DefaultProgressivePromise;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.FailedFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ProgressivePromise;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseTask;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.SucceededFuture;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class UnorderedThreadPoolEventExecutor
extends ScheduledThreadPoolExecutor
implements EventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(UnorderedThreadPoolEventExecutor.class);
    private final Promise<?> terminationFuture = GlobalEventExecutor.INSTANCE.newPromise();
    private final Set<EventExecutor> executorSet = Collections.singleton(this);

    public UnorderedThreadPoolEventExecutor(int corePoolSize) {
        this(corePoolSize, new DefaultThreadFactory(UnorderedThreadPoolEventExecutor.class));
    }

    public UnorderedThreadPoolEventExecutor(int corePoolSize, ThreadFactory threadFactory2) {
        super(corePoolSize, threadFactory2);
    }

    public UnorderedThreadPoolEventExecutor(int corePoolSize, RejectedExecutionHandler handler2) {
        this(corePoolSize, new DefaultThreadFactory(UnorderedThreadPoolEventExecutor.class), handler2);
    }

    public UnorderedThreadPoolEventExecutor(int corePoolSize, ThreadFactory threadFactory2, RejectedExecutionHandler handler2) {
        super(corePoolSize, threadFactory2, handler2);
    }

    @Override
    public EventExecutor next() {
        return this;
    }

    @Override
    public EventExecutorGroup parent() {
        return this;
    }

    @Override
    public boolean inEventLoop() {
        return false;
    }

    @Override
    public boolean inEventLoop(Thread thread2) {
        return false;
    }

    @Override
    public <V> Promise<V> newPromise() {
        return new DefaultPromise(this);
    }

    @Override
    public <V> ProgressivePromise<V> newProgressivePromise() {
        return new DefaultProgressivePromise(this);
    }

    @Override
    public <V> Future<V> newSucceededFuture(V result2) {
        return new SucceededFuture<V>(this, result2);
    }

    @Override
    public <V> Future<V> newFailedFuture(Throwable cause) {
        return new FailedFuture(this, cause);
    }

    @Override
    public boolean isShuttingDown() {
        return this.isShutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> tasks = super.shutdownNow();
        this.terminationFuture.trySuccess(null);
        return tasks;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.terminationFuture.trySuccess(null);
    }

    @Override
    public Future<?> shutdownGracefully() {
        return this.shutdownGracefully(2L, 15L, TimeUnit.SECONDS);
    }

    @Override
    public Future<?> shutdownGracefully(long quietPeriod, long timeout2, TimeUnit unit) {
        this.shutdown();
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return this.executorSet.iterator();
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable2, RunnableScheduledFuture<V> task2) {
        return runnable2 instanceof NonNotifyRunnable ? task2 : new RunnableScheduledFutureTask((EventExecutor)this, task2, false);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task2) {
        return new RunnableScheduledFutureTask<V>((EventExecutor)this, task2, true);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command2, long delay, TimeUnit unit) {
        return (ScheduledFuture)super.schedule(command2, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return (ScheduledFuture)super.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command2, long initialDelay, long period, TimeUnit unit) {
        return (ScheduledFuture)super.scheduleAtFixedRate(command2, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command2, long initialDelay, long delay, TimeUnit unit) {
        return (ScheduledFuture)super.scheduleWithFixedDelay(command2, initialDelay, delay, unit);
    }

    @Override
    public Future<?> submit(Runnable task2) {
        return (Future)super.submit(task2);
    }

    @Override
    public <T> Future<T> submit(Runnable task2, T result2) {
        return (Future)super.submit(task2, result2);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task2) {
        return (Future)super.submit(task2);
    }

    @Override
    public void execute(Runnable command2) {
        super.schedule(new NonNotifyRunnable(command2), 0L, TimeUnit.NANOSECONDS);
    }

    private static final class NonNotifyRunnable
    implements Runnable {
        private final Runnable task;

        NonNotifyRunnable(Runnable task2) {
            this.task = task2;
        }

        @Override
        public void run() {
            this.task.run();
        }
    }

    private static final class RunnableScheduledFutureTask<V>
    extends PromiseTask<V>
    implements RunnableScheduledFuture<V>,
    ScheduledFuture<V> {
        private final RunnableScheduledFuture<V> future;
        private final boolean wasCallable;

        RunnableScheduledFutureTask(EventExecutor executor, RunnableScheduledFuture<V> future2, boolean wasCallable) {
            super(executor, future2);
            this.future = future2;
            this.wasCallable = wasCallable;
        }

        @Override
        V runTask() throws Throwable {
            Object result2 = super.runTask();
            if (result2 == null && this.wasCallable) {
                assert (this.future.isDone());
                try {
                    return this.future.get();
                }
                catch (ExecutionException e) {
                    throw e.getCause();
                }
            }
            return result2;
        }

        @Override
        public void run() {
            block5: {
                if (!this.isPeriodic()) {
                    super.run();
                } else if (!this.isDone()) {
                    try {
                        this.runTask();
                    }
                    catch (Throwable cause) {
                        if (this.tryFailureInternal(cause)) break block5;
                        logger.warn("Failure during execution of task", cause);
                    }
                }
            }
        }

        @Override
        public boolean isPeriodic() {
            return this.future.isPeriodic();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.future.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.future.compareTo(o);
        }
    }
}

