/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.JdkLoggerFactory;
import io.netty.util.internal.logging.Log4J2LoggerFactory;
import io.netty.util.internal.logging.Log4JLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;

public abstract class InternalLoggerFactory {
    private static volatile InternalLoggerFactory defaultFactory;

    private static InternalLoggerFactory newDefaultFactory(String name2) {
        InternalLoggerFactory f = InternalLoggerFactory.useSlf4JLoggerFactory(name2);
        if (f != null) {
            return f;
        }
        f = InternalLoggerFactory.useLog4J2LoggerFactory(name2);
        if (f != null) {
            return f;
        }
        f = InternalLoggerFactory.useLog4JLoggerFactory(name2);
        if (f != null) {
            return f;
        }
        return InternalLoggerFactory.useJdkLoggerFactory(name2);
    }

    private static InternalLoggerFactory useSlf4JLoggerFactory(String name2) {
        try {
            Slf4JLoggerFactory f = new Slf4JLoggerFactory(true);
            ((InternalLoggerFactory)f).newInstance(name2).debug("Using SLF4J as the default logging framework");
            return f;
        }
        catch (LinkageError ignore2) {
            return null;
        }
        catch (Exception ignore3) {
            return null;
        }
    }

    private static InternalLoggerFactory useLog4J2LoggerFactory(String name2) {
        try {
            InternalLoggerFactory f = Log4J2LoggerFactory.INSTANCE;
            f.newInstance(name2).debug("Using Log4J2 as the default logging framework");
            return f;
        }
        catch (LinkageError ignore2) {
            return null;
        }
        catch (Exception ignore3) {
            return null;
        }
    }

    private static InternalLoggerFactory useLog4JLoggerFactory(String name2) {
        try {
            InternalLoggerFactory f = Log4JLoggerFactory.INSTANCE;
            f.newInstance(name2).debug("Using Log4J as the default logging framework");
            return f;
        }
        catch (LinkageError ignore2) {
            return null;
        }
        catch (Exception ignore3) {
            return null;
        }
    }

    private static InternalLoggerFactory useJdkLoggerFactory(String name2) {
        InternalLoggerFactory f = JdkLoggerFactory.INSTANCE;
        f.newInstance(name2).debug("Using java.util.logging as the default logging framework");
        return f;
    }

    public static InternalLoggerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = InternalLoggerFactory.newDefaultFactory(InternalLoggerFactory.class.getName());
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(InternalLoggerFactory defaultFactory) {
        InternalLoggerFactory.defaultFactory = ObjectUtil.checkNotNull(defaultFactory, "defaultFactory");
    }

    public static InternalLogger getInstance(Class<?> clazz) {
        return InternalLoggerFactory.getInstance(clazz.getName());
    }

    public static InternalLogger getInstance(String name2) {
        return InternalLoggerFactory.getDefaultFactory().newInstance(name2);
    }

    protected abstract InternalLogger newInstance(String var1);
}

