/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.IOException;
import java.io.InputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.AbstractMessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.InvalidProtocolBufferException;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.Parser;
import kotlin.reflect.jvm.internal.impl.protobuf.UninitializedMessageException;

public abstract class AbstractParser<MessageType extends MessageLite>
implements Parser<MessageType> {
    private static final ExtensionRegistryLite EMPTY_REGISTRY = ExtensionRegistryLite.getEmptyRegistry();

    private UninitializedMessageException newUninitializedMessageException(MessageType message2) {
        if (message2 instanceof AbstractMessageLite) {
            return ((AbstractMessageLite)message2).newUninitializedMessageException();
        }
        return new UninitializedMessageException((MessageLite)message2);
    }

    private MessageType checkMessageInitialized(MessageType message2) throws InvalidProtocolBufferException {
        if (message2 != null && !message2.isInitialized()) {
            throw this.newUninitializedMessageException(message2).asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)message2);
        }
        return message2;
    }

    public MessageType parsePartialFrom(ByteString data2, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        CodedInputStream input2 = data2.newCodedInput();
        MessageLite message2 = (MessageLite)this.parsePartialFrom(input2, extensionRegistry);
        try {
            input2.checkLastTagWas(0);
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(message2);
        }
        return (MessageType)message2;
    }

    @Override
    public MessageType parseFrom(ByteString data2, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.checkMessageInitialized(this.parsePartialFrom(data2, extensionRegistry));
    }

    public MessageType parsePartialFrom(InputStream input2, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        CodedInputStream codedInput = CodedInputStream.newInstance(input2);
        MessageLite message2 = (MessageLite)this.parsePartialFrom(codedInput, extensionRegistry);
        try {
            codedInput.checkLastTagWas(0);
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(message2);
        }
        return (MessageType)message2;
    }

    @Override
    public MessageType parseFrom(InputStream input2, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.checkMessageInitialized(this.parsePartialFrom(input2, extensionRegistry));
    }

    public MessageType parsePartialDelimitedFrom(InputStream input2, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        int size2;
        try {
            int firstByte = input2.read();
            if (firstByte == -1) {
                return null;
            }
            size2 = CodedInputStream.readRawVarint32(firstByte, input2);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e.getMessage());
        }
        AbstractMessageLite.Builder.LimitedInputStream limitedInput = new AbstractMessageLite.Builder.LimitedInputStream(input2, size2);
        return this.parsePartialFrom(limitedInput, extensionRegistry);
    }

    @Override
    public MessageType parseDelimitedFrom(InputStream input2, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.checkMessageInitialized(this.parsePartialDelimitedFrom(input2, extensionRegistry));
    }
}

