/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.message;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.ByteReadPacketExtensionsKt;
import kotlinx.io.core.Input;
import kotlinx.io.core.InputKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.internal.message.ContextualBugReportExceptionKt;
import net.mamoe.mirai.internal.message.FileMessageImpl;
import net.mamoe.mirai.internal.message.ForwardMessageInternal;
import net.mamoe.mirai.internal.message.LightAppInternal;
import net.mamoe.mirai.internal.message.LongMessageInternal;
import net.mamoe.mirai.internal.message.MarketFaceInternal;
import net.mamoe.mirai.internal.message.MessageToElemsKt;
import net.mamoe.mirai.internal.message.OfflineSourceImplKt;
import net.mamoe.mirai.internal.message.OnlineAudioImpl;
import net.mamoe.mirai.internal.message.OnlineFriendImageImpl;
import net.mamoe.mirai.internal.message.OnlineGroupImageImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromFriendImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromGroupImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromStrangerImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromTempImpl;
import net.mamoe.mirai.internal.message.ReceiveMessageTransformer;
import net.mamoe.mirai.internal.message.UnsupportedMessageImpl;
import net.mamoe.mirai.internal.network.protocol.data.proto.CustomFace;
import net.mamoe.mirai.internal.network.protocol.data.proto.HummerCommelem;
import net.mamoe.mirai.internal.network.protocol.data.proto.ImMsgBody;
import net.mamoe.mirai.internal.network.protocol.data.proto.MsgComm;
import net.mamoe.mirai.internal.network.protocol.data.proto.ObjMsg;
import net.mamoe.mirai.internal.utils.io.serialization.SerializationUtils;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.AtAll;
import net.mamoe.mirai.message.data.Audio;
import net.mamoe.mirai.message.data.AudioCodec;
import net.mamoe.mirai.message.data.CustomMessage;
import net.mamoe.mirai.message.data.Face;
import net.mamoe.mirai.message.data.FlashImage;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.message.data.MessageSourceKind;
import net.mamoe.mirai.message.data.OnlineMessageSource;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.PokeMessage;
import net.mamoe.mirai.message.data.QuoteReply;
import net.mamoe.mirai.message.data.ServiceMessage;
import net.mamoe.mirai.message.data.ShowImageFlag;
import net.mamoe.mirai.message.data.SimpleServiceMessage;
import net.mamoe.mirai.message.data.SingleMessage;
import net.mamoe.mirai.message.data.VipFace;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J0\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J4\u0010.\u001a\u00020\u00112\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u000e2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0015J0\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u0002002\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\n\u00103\u001a\u000204*\u000204J\n\u00105\u001a\u00020\u0011*\u00020\u0015J\n\u00106\u001a\u000207*\u000208R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lnet/mamoe/mirai/internal/message/ReceiveMessageTransformer;", "", "()V", "jsonForFileDecode", "Lkotlinx/serialization/json/Json;", "createMessageSource", "Lnet/mamoe/mirai/message/data/MessageSource;", "bot", "Lnet/mamoe/mirai/Bot;", "onlineSource", "", "messageSourceKind", "Lnet/mamoe/mirai/message/data/MessageSourceKind;", "messageList", "", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/MsgComm$Msg;", "decodeCommonElem", "", "commonElem", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$CommonElem;", "list", "Lnet/mamoe/mirai/message/data/MessageChainBuilder;", "decodeCustomElem", "customElem", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$CustomElem;", "decodeCustomFace", "customFace", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$CustomFace;", "builder", "decodeLightApp", "lightApp", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$LightAppElem;", "decodeRichMessage", "richMsg", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$RichMsg;", "decodeSrcMsg", "srcMsg", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$SourceMsg;", "groupIdOrZero", "", "decodeText", "text", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$Text;", "decodeTransElem", "transElement", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$TransElem;", "joinToMessageChain", "elements", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$Elem;", "transformElement", "element", "cleanupRubbishMessageElements", "Lnet/mamoe/mirai/message/data/MessageChain;", "compressContinuousPlainText", "toAudio", "Lnet/mamoe/mirai/internal/message/OnlineAudioImpl;", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$Ptt;", "mirai-core"})
public final class ReceiveMessageTransformer {
    @NotNull
    public static final ReceiveMessageTransformer INSTANCE = new ReceiveMessageTransformer();
    @NotNull
    private static final Json jsonForFileDecode = JsonKt.Json$default(null, jsonForFileDecode.1.INSTANCE, 1, null);

    private ReceiveMessageTransformer() {
    }

    @NotNull
    public final MessageSource createMessageSource(@NotNull Bot bot, boolean onlineSource, @NotNull MessageSourceKind messageSourceKind, @NotNull List<MsgComm.Msg> messageList) {
        MessageSource messageSource;
        Intrinsics.checkNotNullParameter(bot, "bot");
        Intrinsics.checkNotNullParameter((Object)messageSourceKind, "messageSourceKind");
        Intrinsics.checkNotNullParameter(messageList, "messageList");
        boolean bl = onlineSource;
        if (bl) {
            OnlineMessageSource.Incoming incoming;
            MessageSourceKind messageSourceKind2 = messageSourceKind;
            int n = WhenMappings.$EnumSwitchMapping$0[messageSourceKind2.ordinal()];
            switch (n) {
                case 1: {
                    incoming = new OnlineMessageSourceFromTempImpl(bot, messageList);
                    break;
                }
                case 2: {
                    incoming = new OnlineMessageSourceFromGroupImpl(bot, messageList);
                    break;
                }
                case 3: {
                    incoming = new OnlineMessageSourceFromFriendImpl(bot, messageList);
                    break;
                }
                case 4: {
                    incoming = new OnlineMessageSourceFromStrangerImpl(bot, messageList);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            messageSource = incoming;
        } else if (!bl) {
            messageSource = OfflineSourceImplKt.OfflineMessageSourceImplData(bot, messageList, messageSourceKind);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return messageSource;
    }

    public final void joinToMessageChain(@NotNull List<ImMsgBody.Elem> elements, long groupIdOrZero, @NotNull MessageSourceKind messageSourceKind, @NotNull Bot bot, @NotNull MessageChainBuilder builder) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Intrinsics.checkNotNullParameter((Object)messageSourceKind, "messageSourceKind");
        Intrinsics.checkNotNullParameter(bot, "bot");
        Intrinsics.checkNotNullParameter(builder, "builder");
        for (ImMsgBody.Elem element : elements) {
            this.transformElement(element, groupIdOrZero, messageSourceKind, bot, builder);
            if (element.richMsg == null) continue;
            this.decodeRichMessage(element.richMsg, builder);
        }
    }

    private final void transformElement(ImMsgBody.Elem element, long groupIdOrZero, MessageSourceKind messageSourceKind, Bot bot, MessageChainBuilder builder) {
        if (element.srcMsg != null) {
            this.decodeSrcMsg(element.srcMsg, builder, bot, messageSourceKind, groupIdOrZero);
        } else if (element.notOnlineImage != null) {
            builder.add(new OnlineFriendImageImpl(element.notOnlineImage));
        } else if (element.customFace != null) {
            this.decodeCustomFace(element.customFace, builder);
        } else if (element.face != null) {
            builder.add(new Face(element.face.index));
        } else if (element.text != null) {
            this.decodeText(element.text, builder);
        } else if (element.marketFace != null) {
            builder.add(new MarketFaceInternal(element.marketFace));
        } else if (element.lightApp != null) {
            this.decodeLightApp(element.lightApp, builder);
        } else if (element.customElem != null) {
            this.decodeCustomElem(element.customElem, builder);
        } else if (element.commonElem != null) {
            this.decodeCommonElem(element.commonElem, builder);
        } else if (element.transElemInfo != null) {
            this.decodeTransElem(element.transElemInfo, builder);
        } else if (element.elemFlags2 == null && element.extraInfo == null && element.generalFlags == null && element.anonGroupMsg == null) {
            UnsupportedMessageImpl unsupportedMessageImpl;
            UnsupportedMessageImpl unsupportedMessageImpl2 = new UnsupportedMessageImpl(element);
            boolean bl = false;
            boolean bl2 = false;
            UnsupportedMessageImpl it = unsupportedMessageImpl2;
            boolean bl3 = false;
            byte[] byArray = it.getStruct();
            boolean bl4 = false;
            byte[] byArray2 = byArray;
            boolean bl5 = false;
            UnsupportedMessageImpl unsupportedMessageImpl3 = unsupportedMessageImpl = !(byArray2.length == 0) ? unsupportedMessageImpl2 : null;
            if (unsupportedMessageImpl != null) {
                unsupportedMessageImpl2 = unsupportedMessageImpl;
                bl = false;
                bl2 = false;
                SingleMessage p0 = unsupportedMessageImpl2;
                boolean bl6 = false;
                builder.add(p0);
            }
        }
    }

    public final void compressContinuousPlainText(@NotNull MessageChainBuilder $this$compressContinuousPlainText) {
        Intrinsics.checkNotNullParameter($this$compressContinuousPlainText, "<this>");
        int index = 0;
        StringBuilder builder = new StringBuilder();
        while (index + 1 < $this$compressContinuousPlainText.size()) {
            SingleMessage elm0 = $this$compressContinuousPlainText.get(index);
            SingleMessage elm1 = $this$compressContinuousPlainText.get(index + 1);
            if (elm0 instanceof PlainText && elm1 instanceof PlainText) {
                builder.setLength(0);
                int end2 = -1;
                int n = index;
                int n2 = $this$compressContinuousPlainText.size();
                if (n < n2) {
                    int i2;
                    SingleMessage elm;
                    while ((elm = $this$compressContinuousPlainText.get(i2 = n++)) instanceof PlainText) {
                        end2 = i2;
                        builder.append(((PlainText)elm).getContent());
                        if (n < n2) continue;
                    }
                }
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue(string, "builder.toString()");
                $this$compressContinuousPlainText.set(index, new PlainText(string));
                int index1 = index + 1;
                n2 = end2 - index;
                boolean bl = false;
                int n3 = 0;
                n3 = 0;
                int n4 = n2;
                while (n3 < n4) {
                    int it = n3++;
                    boolean bl2 = false;
                    $this$compressContinuousPlainText.remove(index1);
                }
            }
            int n = index;
            index = n + 1;
        }
        CollectionsKt.removeAll($this$compressContinuousPlainText, (Function1)compressContinuousPlainText.2.INSTANCE);
    }

    @NotNull
    public final MessageChain cleanupRubbishMessageElements(@NotNull MessageChain $this$cleanupRubbishMessageElements) {
        int n;
        int n2;
        Collection collection;
        Collection builder;
        block31: {
            int n3;
            List $this$indexOfFirst$iv;
            int index$iv;
            boolean $i$f$indexOfFirst;
            block30: {
                int vipFaceIndex;
                block29: {
                    int n4;
                    boolean bl;
                    boolean $i$f$any;
                    List $this$indexOfFirst$iv2;
                    SingleMessage it;
                    int index$iv2;
                    block28: {
                        int quoteReplyIndex;
                        block27: {
                            int n5;
                            int quoteReplyIndex2;
                            int exceptedQuoteReplyIndex;
                            boolean bl2;
                            boolean bl3;
                            block26: {
                                int n6;
                                int n7;
                                block25: {
                                    Intrinsics.checkNotNullParameter($this$cleanupRubbishMessageElements, "<this>");
                                    Collection collection2 = $this$cleanupRubbishMessageElements;
                                    bl3 = false;
                                    collection2 = new MessageChainBuilder(collection2.size());
                                    bl3 = false;
                                    boolean bl4 = false;
                                    Collection it2 = collection2;
                                    boolean bl5 = false;
                                    ((MessageChainBuilder)it2).addAll($this$cleanupRubbishMessageElements);
                                    builder = collection2;
                                    bl2 = false;
                                    bl3 = false;
                                    boolean bl6 = false;
                                    List $this$indexOfFirst$iv3 = (List)builder;
                                    boolean $i$f$indexOfFirst2 = false;
                                    index$iv2 = 0;
                                    for (Object item$iv : $this$indexOfFirst$iv3) {
                                        it = (SingleMessage)item$iv;
                                        boolean bl7 = false;
                                        if (it instanceof MessageSource) {
                                            n7 = index$iv2;
                                            break block25;
                                        }
                                        ++index$iv2;
                                    }
                                    n7 = -1;
                                }
                                exceptedQuoteReplyIndex = n7 + 1;
                                List $this$indexOfFirst$iv4 = (List)builder;
                                boolean $i$f$indexOfFirst3 = false;
                                int index$iv3 = 0;
                                for (Object item$iv : $this$indexOfFirst$iv4) {
                                    SingleMessage it3 = (SingleMessage)item$iv;
                                    boolean bl8 = false;
                                    if (it3 instanceof QuoteReply) {
                                        n6 = index$iv3;
                                        break block26;
                                    }
                                    ++index$iv3;
                                }
                                n6 = quoteReplyIndex2 = -1;
                            }
                            if (quoteReplyIndex2 >= 1 && quoteReplyIndex2 != exceptedQuoteReplyIndex) {
                                SingleMessage qr = ((MessageChainBuilder)builder).get(quoteReplyIndex2);
                                ((MessageChainBuilder)builder).remove(quoteReplyIndex2);
                                ((MessageChainBuilder)builder).add(exceptedQuoteReplyIndex, qr);
                            }
                            bl2 = false;
                            bl3 = false;
                            boolean bl9 = false;
                            $this$indexOfFirst$iv2 = (List)builder;
                            boolean $i$f$indexOfFirst4 = false;
                            index$iv2 = 0;
                            for (Object item$iv : $this$indexOfFirst$iv2) {
                                it = (SingleMessage)item$iv;
                                boolean bl10 = false;
                                if (it instanceof QuoteReply) {
                                    n5 = index$iv2;
                                    break block27;
                                }
                                ++index$iv2;
                            }
                            n5 = quoteReplyIndex = -1;
                        }
                        if (quoteReplyIndex >= 0 && quoteReplyIndex < ((MessageChainBuilder)builder).size() - 1) {
                            SingleMessage elm;
                            if (((MessageChainBuilder)builder).get(quoteReplyIndex + 1) instanceof At) {
                                ((MessageChainBuilder)builder).remove(quoteReplyIndex + 1);
                            }
                            if (quoteReplyIndex < ((MessageChainBuilder)builder).size() - 1 && (elm = ((MessageChainBuilder)builder).get(quoteReplyIndex + 1)) instanceof PlainText && StringsKt.startsWith$default((CharSequence)((PlainText)elm).getContent(), ' ', false, 2, null)) {
                                if (((PlainText)elm).getContent().length() == 1) {
                                    ((MessageChainBuilder)builder).remove(quoteReplyIndex + 1);
                                } else {
                                    String $i$f$indexOfFirst4 = ((PlainText)elm).getContent();
                                    index$iv2 = 1;
                                    boolean index$iv3 = false;
                                    String string = $i$f$indexOfFirst4;
                                    if (string == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    String string2 = string.substring(index$iv2);
                                    Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.String).substring(startIndex)");
                                    ((MessageChainBuilder)builder).set(quoteReplyIndex + 1, new PlainText(string2));
                                }
                            }
                        }
                        Iterable $this$any$iv = builder;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                SingleMessage it4 = (SingleMessage)element$iv;
                                boolean bl11 = false;
                                if (!(it4 instanceof Audio)) continue;
                                bl = true;
                                break block28;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        ((MessageChainBuilder)builder).remove((Object)MessageToElemsKt.getUNSUPPORTED_VOICE_MESSAGE_PLAIN());
                    }
                    boolean $this$any$iv = false;
                    $i$f$any = false;
                    boolean bl12 = false;
                    $this$indexOfFirst$iv2 = (List)builder;
                    boolean $i$f$indexOfFirst5 = false;
                    index$iv2 = 0;
                    for (Object item$iv : $this$indexOfFirst$iv2) {
                        it = (SingleMessage)item$iv;
                        boolean bl13 = false;
                        if (it instanceof VipFace) {
                            n4 = index$iv2;
                            break block29;
                        }
                        ++index$iv2;
                    }
                    n4 = vipFaceIndex = -1;
                }
                if (vipFaceIndex >= 0 && vipFaceIndex < ((MessageChainBuilder)builder).size() - 1) {
                    VipFace l = (VipFace)((MessageChainBuilder)builder).get(vipFaceIndex);
                    SingleMessage text = ((MessageChainBuilder)builder).get(vipFaceIndex + 1);
                    if (text instanceof PlainText && ((PlainText)text).getContent().length() == 4 + l.getCount() / 10 + l.getKind().getName().length()) {
                        ((MessageChainBuilder)builder).remove(vipFaceIndex + 1);
                    }
                }
                List $this$any$iv = (List)builder;
                collection = builder;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    SingleMessage it = (SingleMessage)item$iv;
                    boolean bl = false;
                    if (it instanceof LongMessageInternal) {
                        n3 = index$iv;
                        break block30;
                    }
                    ++index$iv;
                }
                n3 = -1;
            }
            n2 = n3;
            ReceiveMessageTransformer.cleanupRubbishMessageElements$removeSuffixText((MessageChainBuilder)collection, n2, MessageToElemsKt.getUNSUPPORTED_MERGED_MESSAGE_PLAIN());
            $this$indexOfFirst$iv = (List)builder;
            collection = builder;
            $i$f$indexOfFirst = false;
            index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                SingleMessage it = (SingleMessage)item$iv;
                boolean bl = false;
                if (it instanceof PokeMessage) {
                    n = index$iv;
                    break block31;
                }
                ++index$iv;
            }
            n = -1;
        }
        n2 = n;
        ReceiveMessageTransformer.cleanupRubbishMessageElements$removeSuffixText((MessageChainBuilder)collection, n2, MessageToElemsKt.getUNSUPPORTED_POKE_MESSAGE_PLAIN());
        this.compressContinuousPlainText((MessageChainBuilder)builder);
        return ((MessageChainBuilder)builder).asMessageChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void decodeText(ImMsgBody.Text text, MessageChainBuilder list2) {
        byte[] byArray = text.attr6Buf;
        boolean bl = false;
        if (byArray.length == 0) {
            list2.add(new PlainText(text.str));
        } else {
            void $this$withUse$iv$iv;
            long id = 0L;
            byte[] $this$read$iv = text.attr6Buf;
            boolean $i$f$read = false;
            boolean bl2 = false;
            Object $this$toReadPacket_u24default$iv$iv = $this$read$iv;
            int offset$iv$iv = 0;
            int length$iv$iv = ((byte[])$this$toReadPacket_u24default$iv$iv).length - offset$iv$iv;
            byte[] $this$toReadPacket$iv$iv$iv = $this$toReadPacket_u24default$iv$iv;
            boolean $i$f$toReadPacket = false;
            boolean $i$f$ByteReadPacket = false;
            boolean $i$f$ByteReadPacket2 = false;
            ByteBuffer byteBuffer = ByteBuffer.wrap($this$toReadPacket$iv$iv$iv, offset$iv$iv, length$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "ByteBuffer.wrap(array, offset, length)");
            $this$toReadPacket_u24default$iv$iv = ByteReadPacketExtensionsKt.ByteReadPacket(byteBuffer, (Function1<? super ByteBuffer, Unit>)new Function1<ByteBuffer, Unit>($this$toReadPacket$iv$iv$iv){
                final /* synthetic */ byte[] $array;
                {
                    this.$array = byArray;
                    super(1);
                }

                public final void invoke(@NotNull ByteBuffer it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    byte[] it2 = this.$array;
                    boolean bl = false;
                }
            });
            boolean $i$f$withUse = false;
            boolean bl3 = false;
            void var8_12 = $this$withUse$iv$iv;
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                ByteReadPacket $this$decodeText_u24lambda_u2d13 = (ByteReadPacket)var8_12;
                boolean bl6 = false;
                InputKt.discardExact((Input)$this$decodeText_u24lambda_u2d13, 7);
                Input $this$readUInt$iv = $this$decodeText_u24lambda_u2d13;
                boolean $i$f$readUInt = false;
                int n = $this$readUInt$iv.readInt();
                boolean bl7 = false;
                int n2 = UInt.constructor-impl(n);
                boolean bl8 = false;
                id = (long)n2 & 0xFFFFFFFFL;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var8_12, throwable);
            }
            if (id == 0L) {
                list2.add(AtAll.INSTANCE);
            } else {
                list2.add(new At(id));
            }
        }
    }

    private final void decodeSrcMsg(ImMsgBody.SourceMsg srcMsg, MessageChainBuilder list2, Bot bot, MessageSourceKind messageSourceKind, long groupIdOrZero) {
        list2.add(new QuoteReply(OfflineSourceImplKt.OfflineMessageSourceImplData(srcMsg, bot, messageSourceKind, groupIdOrZero)));
    }

    private final void decodeCustomFace(ImMsgBody.CustomFace customFace, MessageChainBuilder builder) {
        builder.add(new OnlineGroupImageImpl(customFace));
        byte[] byArray = customFace.pbReserve;
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        byte[] byArray2 = it;
        boolean bl4 = false;
        byte[] byArray3 = byArray2;
        boolean bl5 = false;
        if (!(byArray3.length == 0) && ((CustomFace.ResvAttr)SerializationUtils.loadAs$default((byte[])it, (DeserializationStrategy)((DeserializationStrategy)CustomFace.ResvAttr.Companion.serializer()), (int)0, (int)2, null)).msgImageShow != null) {
            builder.add(ShowImageFlag.INSTANCE);
        }
    }

    private final void decodeLightApp(ImMsgBody.LightAppElem lightApp, MessageChainBuilder list2) {
        Object object;
        String context$iv = "\u89e3\u6790 lightApp";
        boolean $i$f$runWithBugReport = false;
        boolean bl = false;
        bl = false;
        try {
            String string;
            object = Result.Companion;
            boolean bl2 = false;
            byte by = lightApp.data[0];
            switch (by) {
                case 0: {
                    string = StringsKt.decodeToString$default(lightApp.data, 1, 0, false, 6, null);
                    break;
                }
                case 1: {
                    string = StringsKt.decodeToString(MiraiUtils.unzip$default(lightApp.data, 1, 0, 2, null));
                    break;
                }
                default: {
                    String string2 = Intrinsics.stringPlus("unknown compression flag=", lightApp.data[0]);
                    boolean bl3 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
            }
            String string3 = string;
            boolean bl4 = false;
            object = Result.constructor-impl(string3);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl5 = false;
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        Object object2 = object;
        boolean bl6 = false;
        boolean bl7 = false;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable != null) {
            Throwable it$iv = throwable;
            boolean bl8 = false;
            String string = context$iv;
            boolean bl9 = false;
            String string4 = "resId=" + lightApp.msgResid + "data=" + MiraiUtils.toUHexString$default(lightApp.data, null, 0, 0, 7, null);
            throw ContextualBugReportExceptionKt.contextualBugReportException$default(string, string4, it$iv, null, 8, null);
        }
        String content2 = (String)object2;
        list2.add(new LightAppInternal(content2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void decodeCustomElem(ImMsgBody.CustomElem customElem, MessageChainBuilder list2) {
        void $this$withUse$iv$iv;
        byte[] $this$read$iv = customElem.data;
        boolean $i$f$read = false;
        boolean bl = false;
        Object $this$toReadPacket_u24default$iv$iv = $this$read$iv;
        int offset$iv$iv = 0;
        int length$iv$iv = ((byte[])$this$toReadPacket_u24default$iv$iv).length - offset$iv$iv;
        byte[] $this$toReadPacket$iv$iv$iv = $this$toReadPacket_u24default$iv$iv;
        boolean $i$f$toReadPacket = false;
        boolean $i$f$ByteReadPacket = false;
        boolean $i$f$ByteReadPacket2 = false;
        ByteBuffer byteBuffer = ByteBuffer.wrap($this$toReadPacket$iv$iv$iv, offset$iv$iv, length$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "ByteBuffer.wrap(array, offset, length)");
        $this$toReadPacket_u24default$iv$iv = ByteReadPacketExtensionsKt.ByteReadPacket(byteBuffer, (Function1<? super ByteBuffer, Unit>)new Function1<ByteBuffer, Unit>($this$toReadPacket$iv$iv$iv){
            final /* synthetic */ byte[] $array;
            {
                this.$array = byArray;
                super(1);
            }

            public final void invoke(@NotNull ByteBuffer it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                byte[] it2 = this.$array;
                boolean bl = false;
            }
        });
        boolean $i$f$withUse = false;
        boolean bl2 = false;
        void var7_9 = $this$withUse$iv$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            Object object;
            ByteReadPacket $this$decodeCustomElem_u24lambda_u2d20 = (ByteReadPacket)var7_9;
            boolean bl5 = false;
            boolean bl6 = false;
            try {
                object = Result.Companion;
                boolean bl7 = false;
                CustomMessage customMessage = CustomMessage.Companion.load($this$decodeCustomElem_u24lambda_u2d20);
                boolean bl8 = false;
                object = Result.constructor-impl(customMessage);
            }
            catch (Throwable throwable2) {
                Result.Companion companion = Result.Companion;
                boolean bl9 = false;
                object = Result.constructor-impl(ResultKt.createFailure(throwable2));
            }
            Object object2 = object;
            boolean bl10 = false;
            boolean bl11 = false;
            Throwable throwable3 = Result.exceptionOrNull-impl(object2);
            if (throwable3 == null) {
                CustomMessage it = (CustomMessage)object2;
                boolean bl12 = false;
                if (it != null) {
                    list2.add(it);
                }
            } else {
                Throwable it = throwable3;
                boolean bl13 = false;
                if (it instanceof CustomMessage.Companion.CustomMessageFullDataDeserializeInternalException) {
                    throw new IllegalStateException(Intrinsics.stringPlus("Internal error: exception while deserializing CustomMessage head data, data=", MiraiUtils.toUHexString$default(customElem.data, null, 0, 0, 7, null)), it);
                }
                CustomMessage.Companion.CustomMessageFullDataDeserializeUserException cfr_ignored_0 = (CustomMessage.Companion.CustomMessageFullDataDeserializeUserException)it;
                throw new IllegalStateException(Intrinsics.stringPlus("User error: exception while deserializing CustomMessage body, body=", MiraiUtils.toUHexString$default(((CustomMessage.Companion.CustomMessageFullDataDeserializeUserException)it).getBody(), null, 0, 0, 7, null)), it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var7_9, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void decodeTransElem(ImMsgBody.TransElem transElement, MessageChainBuilder list2) {
        int n = transElement.elemType;
        if (n == 24) {
            void $this$withUse$iv$iv;
            byte[] $this$read$iv = transElement.elemValue;
            boolean $i$f$read = false;
            boolean bl = false;
            Object $this$toReadPacket_u24default$iv$iv = $this$read$iv;
            int offset$iv$iv = 0;
            int length$iv$iv = ((byte[])$this$toReadPacket_u24default$iv$iv).length - offset$iv$iv;
            byte[] $this$toReadPacket$iv$iv$iv = $this$toReadPacket_u24default$iv$iv;
            boolean $i$f$toReadPacket = false;
            boolean $i$f$ByteReadPacket = false;
            boolean $i$f$ByteReadPacket2 = false;
            ByteBuffer byteBuffer = ByteBuffer.wrap($this$toReadPacket$iv$iv$iv, offset$iv$iv, length$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "ByteBuffer.wrap(array, offset, length)");
            $this$toReadPacket_u24default$iv$iv = ByteReadPacketExtensionsKt.ByteReadPacket(byteBuffer, (Function1<? super ByteBuffer, Unit>)new Function1<ByteBuffer, Unit>($this$toReadPacket$iv$iv$iv){
                final /* synthetic */ byte[] $array;
                {
                    this.$array = byArray;
                    super(1);
                }

                public final void invoke(@NotNull ByteBuffer it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    byte[] it2 = this.$array;
                    boolean bl = false;
                }
            });
            boolean $i$f$withUse = false;
            boolean bl2 = false;
            void var8_10 = $this$withUse$iv$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                ByteReadPacket $this$decodeTransElem_u24lambda_u2d21 = (ByteReadPacket)var8_10;
                boolean bl5 = false;
                byte var7 = $this$decodeTransElem_u24lambda_u2d21.readByte();
                if (var7 == 1) {
                    while ($this$decodeTransElem_u24lambda_u2d21.getRemaining() > 2L) {
                        ObjMsg.MsgContentInfo.MsgFile msgFile;
                        Input $this$readUShort$iv22 = $this$decodeTransElem_u24lambda_u2d21;
                        boolean $i$f$readUShort = false;
                        short s = $this$readUShort$iv22.readShort();
                        boolean bl6 = false;
                        short $this$readUShort$iv22 = UShort.constructor-impl(s);
                        boolean bl7 = false;
                        ObjMsg.ObjMsg proto = (ObjMsg.ObjMsg)SerializationUtils.readProtoBuf($this$decodeTransElem_u24lambda_u2d21, ObjMsg.ObjMsg.Companion.serializer(), $this$readUShort$iv22 & 0xFFFF);
                        ObjMsg.MsgContentInfo msgContentInfo = CollectionsKt.firstOrNull(proto.msgContentInfo);
                        ObjMsg.MsgContentInfo.MsgFile msgFile2 = msgFile = msgContentInfo == null ? null : msgContentInfo.msgFile;
                        if (msgFile == null) continue;
                        ObjMsg.MsgContentInfo.MsgFile file = msgFile;
                        list2.add(new FileMessageImpl(file.filePath, file.busId, file.fileName, file.fileSize));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var8_10, throwable);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void decodeCommonElem(ImMsgBody.CommonElem commonElem, MessageChainBuilder list) {
        var3_3 = commonElem.serviceType;
        switch (var3_3) {
            case 23: {
                proto = (HummerCommelem.MsgElemInfoServtype23)SerializationUtils.loadAs$default(commonElem.pbElem, HummerCommelem.MsgElemInfoServtype23.Companion.serializer(), 0, 2, null);
                list.add(new VipFace(new VipFace.Kind(proto.faceType, proto.faceSummary), proto.faceBubbleCount));
                break;
            }
            case 2: {
                proto = (HummerCommelem.MsgElemInfoServtype2)SerializationUtils.loadAs$default(commonElem.pbElem, HummerCommelem.MsgElemInfoServtype2.Companion.serializer(), 0, 2, null);
                var6_8 = proto.vaspokeName;
                var7_9 = false;
                var8_12 = false;
                var9_13 = var6_8;
                var15_14 = list;
                $i$a$-takeIf-ReceiveMessageTransformer$decodeCommonElem$1 = false;
                var11_16 = (CharSequence)it;
                var12_18 = false;
                var16_20 = var11_16.length() > 0;
                v0 = var15_14;
                v1 = var5_22 = var16_20 != false ? var6_8 : null;
                if (var5_22 != null) ** GOTO lbl43
                var7_10 = PokeMessage.values;
                var15_14 = v0;
                $i$f$firstOrNull = false;
                var9_13 = $this$firstOrNull$iv;
                var10_15 = ((String)var9_13).length;
                for (var11_17 = 0; var11_17 < var10_15; ++var11_17) {
                    it = element$iv = var9_13[var11_17];
                    $i$a$-firstOrNull-ReceiveMessageTransformer$decodeCommonElem$2 = false;
                    if (!(it.getId() == proto.vaspokeId && it.getPokeType() == proto.pokeType)) continue;
                    v2 = element$iv;
                    ** GOTO lbl34
                }
                v2 = null;
lbl34:
                // 2 sources

                var16_21 = v2;
                v0 = var15_14;
                var6_8 = var16_21;
                var6_8 = var6_8 == null ? null : var6_8.getName();
                var7_11 = false;
                v3 = var6_8;
                if (v3 == null) {
                    v3 = "";
                }
                ** GOTO lbl44
lbl43:
                // 1 sources

                v3 = var5_22;
lbl44:
                // 2 sources

                var17_25 = proto.vaspokeId;
                var18_26 = proto.pokeType;
                var19_27 = v3;
                v0.add(new PokeMessage(var19_27, var18_26, var17_25));
                break;
            }
            case 3: {
                proto = (HummerCommelem.MsgElemInfoServtype3)SerializationUtils.loadAs$default(commonElem.pbElem, HummerCommelem.MsgElemInfoServtype3.Companion.serializer(), 0, 2, null);
                if (proto.flashTroopPic != null) {
                    list.add(new FlashImage(new OnlineGroupImageImpl(proto.flashTroopPic)));
                }
                if (proto.flashC2cPic == null) break;
                list.add(new FlashImage(new OnlineFriendImageImpl(proto.flashC2cPic)));
                break;
            }
            case 33: {
                proto = (HummerCommelem.MsgElemInfoServtype33)SerializationUtils.loadAs$default(commonElem.pbElem, HummerCommelem.MsgElemInfoServtype33.Companion.serializer(), 0, 2, null);
                list.add(new Face(proto.index));
            }
        }
    }

    private final void decodeRichMessage(ImMsgBody.RichMsg richMsg, MessageChainBuilder builder) {
        int serviceId;
        int n;
        boolean bl10;
        boolean bl2;
        byte by;
        Object object;
        String context$iv = "\u89e3\u6790 richMsg";
        boolean $i$f$runWithBugReport = false;
        boolean bl3 = false;
        bl3 = false;
        try {
            String string;
            object = Result.Companion;
            boolean bl4 = false;
            by = richMsg.template1[0];
            switch (by) {
                case 0: {
                    string = StringsKt.decodeToString$default(richMsg.template1, 1, 0, false, 6, null);
                    break;
                }
                case 1: {
                    string = StringsKt.decodeToString(MiraiUtils.unzip$default(richMsg.template1, 1, 0, 2, null));
                    break;
                }
                default: {
                    String string2 = Intrinsics.stringPlus("unknown compression flag=", richMsg.template1[0]);
                    boolean bl5 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
            }
            String string3 = string;
            boolean bl6 = false;
            object = Result.constructor-impl(string3);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl2 = false;
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        Object object2 = object;
        boolean bl7 = false;
        boolean bl8 = false;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable != null) {
            Throwable it$iv = throwable;
            boolean bl9 = false;
            String string = context$iv;
            bl10 = false;
            String string4 = MiraiUtils.toUHexString$default(richMsg.template1, null, 0, 0, 7, null);
            throw ContextualBugReportExceptionKt.contextualBugReportException$default(string, string4, it$iv, null, 8, null);
        }
        String content2 = (String)object2;
        int sid = richMsg.serviceId;
        if (sid == 0) {
            String serviceIdStr = ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content2, "serviceID");
            Object object3 = serviceIdStr;
            bl10 = false;
            n = object3.length() == 0 || StringsKt.isBlank(serviceIdStr) ? 0 : ((object3 = StringsKt.toIntOrNull(serviceIdStr)) == null ? 0 : (Integer)object3);
        } else {
            n = sid;
        }
        int n2 = serviceId = n;
        switch (n2) {
            case 1: {
                builder.add(new SimpleServiceMessage(1, content2));
                break;
            }
            case 35: {
                ServiceMessage serviceMessage;
                String resId = ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content2, "m_resid");
                String bl10 = ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content2, "m_fileName");
                by = 0;
                int n3 = 0;
                String it = bl10;
                boolean bl11 = false;
                CharSequence charSequence = it;
                bl2 = false;
                String fileName = charSequence.length() > 0 ? bl10 : null;
                Object object4 = resId;
                n3 = 0;
                if (object4.length() == 0) {
                    serviceMessage = fileName != null && Intrinsics.areEqual(ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content2, "action"), "viewMultiMsg") ? (ServiceMessage)new ForwardMessageInternal(content2, null, fileName, null, 8, null) : (ServiceMessage)new SimpleServiceMessage(35, content2);
                } else {
                    Object object5 = object4 = StringsKt.toIntOrNull(ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content2, "multiMsgFlag"));
                    n3 = 1;
                    if (object5 != null && (Integer)object5 == n3) {
                        serviceMessage = new LongMessageInternal(content2, resId);
                    } else {
                        Object object6 = object4;
                        n3 = 0;
                        serviceMessage = object6 != null && (Integer)object6 == 0 ? (ServiceMessage)new ForwardMessageInternal(content2, resId, fileName, null, 8, null) : (Intrinsics.areEqual(ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content2, "action"), "viewMultiMsg") ? (ServiceMessage)new ForwardMessageInternal(content2, resId, fileName, null, 8, null) : (ServiceMessage)new SimpleServiceMessage(35, content2));
                    }
                }
                ServiceMessage msg = serviceMessage;
                builder.add(msg);
                break;
            }
            default: {
                builder.add(new SimpleServiceMessage(serviceId, content2));
            }
        }
    }

    @NotNull
    public final OnlineAudioImpl toAudio(@NotNull ImMsgBody.Ptt $this$toAudio) {
        Intrinsics.checkNotNullParameter($this$toAudio, "<this>");
        return new OnlineAudioImpl(StringsKt.decodeToString($this$toAudio.fileName), $this$toAudio.fileMd5, MiraiUtils.toLongUnsigned($this$toAudio.fileSize), AudioCodec.Companion.fromId($this$toAudio.format), StringsKt.decodeToString($this$toAudio.downPara), MiraiUtils.toLongUnsigned($this$toAudio.time), $this$toAudio);
    }

    private static final void cleanupRubbishMessageElements$removeSuffixText(MessageChainBuilder builder, int index, PlainText text) {
        if (index >= 0 && index < builder.size() - 1 && Intrinsics.areEqual(builder.get(index + 1), text)) {
            builder.remove(index + 1);
        }
    }

    private static final String decodeRichMessage$findStringProperty(String content2, String name2) {
        return StringsKt.substringBefore(StringsKt.substringAfter(content2, Intrinsics.stringPlus(name2, "=\""), ""), "\"", "");
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageSourceKind.values().length];
            nArray[MessageSourceKind.TEMP.ordinal()] = 1;
            nArray[MessageSourceKind.GROUP.ordinal()] = 2;
            nArray[MessageSourceKind.FRIEND.ordinal()] = 3;
            nArray[MessageSourceKind.STRANGER.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

