/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils.crypto;

import java.security.PublicKey;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.utils.crypto.ECDH;
import net.mamoe.mirai.internal.utils.crypto.ECDHInitialPublicKey;
import net.mamoe.mirai.internal.utils.crypto.ECDHKt;
import net.mamoe.mirai.internal.utils.crypto.ECDHWithPublicKey;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0011\u001a\u00060\u0007j\u0002`\u0012*\u00020\rH\u0000\u001a\u0010\u0010\u0011\u001a\u00060\u0007j\u0002`\u0012*\u00020\u0013H\u0000\"\u001b\u0010\u0000\u001a\u00020\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"#\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0005\u001a\u0004\b\t\u0010\n\"\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"defaultInitialPublicKey", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHInitialPublicKey;", "getDefaultInitialPublicKey", "()Lnet/mamoe/mirai/internal/utils/crypto/ECDHInitialPublicKey;", "defaultInitialPublicKey$delegate", "Lkotlin/Lazy;", "publicKeyForVerify", "Ljava/security/PublicKey;", "kotlin.jvm.PlatformType", "getPublicKeyForVerify", "()Ljava/security/PublicKey;", "publicKeyForVerify$delegate", "signHead", "", "ecdhWithPublicKey", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHWithPublicKey;", "initialPublicKey", "adjustToPublicKey", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHPublicKey;", "", "mirai-core"})
public final class ECDHKt {
    @NotNull
    private static final Lazy publicKeyForVerify$delegate = LazyKt.lazy(publicKeyForVerify.2.INSTANCE);
    @NotNull
    private static final Lazy defaultInitialPublicKey$delegate = LazyKt.lazy(defaultInitialPublicKey.2.INSTANCE);
    @NotNull
    private static final byte[] signHead = MiraiUtils.hexToBytes("3059301306072a8648ce3d020106082a8648ce3d030107034200");

    @NotNull
    public static final ECDHWithPublicKey ecdhWithPublicKey(@NotNull ECDHInitialPublicKey initialPublicKey) {
        Intrinsics.checkNotNullParameter(initialPublicKey, "initialPublicKey");
        return new ECDHWithPublicKey(initialPublicKey);
    }

    public static /* synthetic */ ECDHWithPublicKey ecdhWithPublicKey$default(ECDHInitialPublicKey eCDHInitialPublicKey, int n, Object object) {
        if ((n & 1) != 0) {
            eCDHInitialPublicKey = ECDHKt.getDefaultInitialPublicKey();
        }
        return ECDHKt.ecdhWithPublicKey(eCDHInitialPublicKey);
    }

    public static final PublicKey getPublicKeyForVerify() {
        Lazy lazy = publicKeyForVerify$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (PublicKey)lazy.getValue();
    }

    @NotNull
    public static final ECDHInitialPublicKey getDefaultInitialPublicKey() {
        Lazy lazy = defaultInitialPublicKey$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (ECDHInitialPublicKey)lazy.getValue();
    }

    @NotNull
    public static final PublicKey adjustToPublicKey(@NotNull String $this$adjustToPublicKey) {
        Intrinsics.checkNotNullParameter($this$adjustToPublicKey, "<this>");
        return ECDHKt.adjustToPublicKey(MiraiUtils.hexToBytes($this$adjustToPublicKey));
    }

    @NotNull
    public static final PublicKey adjustToPublicKey(@NotNull byte[] $this$adjustToPublicKey) {
        Intrinsics.checkNotNullParameter($this$adjustToPublicKey, "<this>");
        return ECDH.Companion.constructPublicKey(ArraysKt.plus(signHead, $this$adjustToPublicKey));
    }
}

