/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Protocol;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.AndroidSocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lokhttp3/internal/platform/android/DeferredSocketAdapter;", "Lokhttp3/internal/platform/android/SocketAdapter;", "socketPackage", "", "(Ljava/lang/String;)V", "delegate", "initialized", "", "configureTlsExtensions", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "hostname", "protocols", "", "Lokhttp3/Protocol;", "getDelegate", "actualSSLSocketClass", "getSelectedProtocol", "isSupported", "matchesSocket", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "okhttp"})
public final class DeferredSocketAdapter
implements SocketAdapter {
    private boolean initialized;
    private SocketAdapter delegate;
    private final String socketPackage;

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public boolean matchesSocket(@NotNull SSLSocket sslSocket) {
        Intrinsics.checkParameterIsNotNull(sslSocket, "sslSocket");
        String string = sslSocket.getClass().getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "sslSocket.javaClass.name");
        return StringsKt.startsWith$default(string, this.socketPackage, false, 2, null);
    }

    @Override
    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<? extends Protocol> protocols) {
        block0: {
            Intrinsics.checkParameterIsNotNull(sslSocket, "sslSocket");
            Intrinsics.checkParameterIsNotNull(protocols, "protocols");
            SocketAdapter socketAdapter = this.getDelegate(sslSocket);
            if (socketAdapter == null) break block0;
            socketAdapter.configureTlsExtensions(sslSocket, hostname, protocols);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket sslSocket) {
        Intrinsics.checkParameterIsNotNull(sslSocket, "sslSocket");
        SocketAdapter socketAdapter = this.getDelegate(sslSocket);
        return socketAdapter != null ? socketAdapter.getSelectedProtocol(sslSocket) : null;
    }

    private final synchronized SocketAdapter getDelegate(SSLSocket actualSSLSocketClass) {
        if (!this.initialized) {
            try {
                Class<?> possibleClass = actualSSLSocketClass.getClass();
                while (Intrinsics.areEqual(possibleClass.getName(), this.socketPackage + ".OpenSSLSocketImpl") ^ true) {
                    Intrinsics.checkExpressionValueIsNotNull(possibleClass.getSuperclass(), "possibleClass.superclass");
                    if (possibleClass != null) continue;
                    throw (Throwable)((Object)new AssertionError((Object)("No OpenSSLSocketImpl superclass of socket of type " + actualSSLSocketClass)));
                }
                this.delegate = new AndroidSocketAdapter(possibleClass);
            }
            catch (Exception e) {
                Platform.Companion.get().log("Failed to initialize DeferredSocketAdapter " + this.socketPackage, 5, e);
            }
            this.initialized = true;
        }
        return this.delegate;
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        Intrinsics.checkParameterIsNotNull(sslSocketFactory, "sslSocketFactory");
        return null;
    }

    public DeferredSocketAdapter(@NotNull String socketPackage) {
        Intrinsics.checkParameterIsNotNull(socketPackage, "socketPackage");
        this.socketPackage = socketPackage;
    }

    @Override
    public boolean matchesSocketFactory(@NotNull SSLSocketFactory sslSocketFactory) {
        Intrinsics.checkParameterIsNotNull(sslSocketFactory, "sslSocketFactory");
        return SocketAdapter.DefaultImpls.matchesSocketFactory(this, sslSocketFactory);
    }
}

