/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.tsp;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Arrays;

public class PartialHashtree
extends ASN1Object {
    private ASN1Sequence values;

    public static PartialHashtree getInstance(Object object) {
        if (object instanceof PartialHashtree) {
            return (PartialHashtree)object;
        }
        if (object != null) {
            return new PartialHashtree(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private PartialHashtree(ASN1Sequence aSN1Sequence) {
        for (int j = 0; j != aSN1Sequence.size(); ++j) {
            if (aSN1Sequence.getObjectAt(j) instanceof DEROctetString) continue;
            throw new IllegalArgumentException("unknown object in constructor: " + aSN1Sequence.getObjectAt(j).getClass().getName());
        }
        this.values = aSN1Sequence;
    }

    public PartialHashtree(byte[] byArray) {
        this(new byte[][]{byArray});
    }

    public PartialHashtree(byte[][] byArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(byArray.length);
        for (int j = 0; j != byArray.length; ++j) {
            aSN1EncodableVector.add(new DEROctetString(Arrays.clone(byArray[j])));
        }
        this.values = new DERSequence(aSN1EncodableVector);
    }

    public byte[][] getValues() {
        byte[][] byArrayArray = new byte[this.values.size()][];
        for (int j = 0; j != byArrayArray.length; ++j) {
            byArrayArray[j] = Arrays.clone(ASN1OctetString.getInstance(this.values.getObjectAt(j)).getOctets());
        }
        return byArrayArray;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.values;
    }
}

