/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class Tables8kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    public void init(byte[] byArray) {
        if (this.T == null) {
            this.T = new long[32][16][2];
        } else if (Arrays.areEqual(this.H, byArray)) {
            return;
        }
        this.H = Arrays.clone(byArray);
        for (int j = 0; j < 32; ++j) {
            long[][] lArray = this.T[j];
            if (j == 0) {
                GCMUtil.asLongs(this.H, lArray[1]);
                GCMUtil.multiplyP3(lArray[1], lArray[1]);
            } else {
                GCMUtil.multiplyP4(this.T[j - 1][1], lArray[1]);
            }
            for (int k = 2; k < 16; k += 2) {
                GCMUtil.divideP(lArray[k >> 1], lArray[k]);
                GCMUtil.xor(lArray[k], lArray[1], lArray[k + 1]);
            }
        }
    }

    public void multiplyH(byte[] byArray) {
        long l = 0L;
        long l2 = 0L;
        for (int j = 15; j >= 0; --j) {
            long[] lArray = this.T[j + j + 1][byArray[j] & 0xF];
            long[] lArray2 = this.T[j + j][(byArray[j] & 0xF0) >>> 4];
            l ^= lArray[0] ^ lArray2[0];
            l2 ^= lArray[1] ^ lArray2[1];
        }
        Pack.longToBigEndian(l, byArray, 0);
        Pack.longToBigEndian(l2, byArray, 8);
    }
}

