/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.tls.CombinedHash;
import org.bouncycastle.crypto.tls.DigestInputBuffer;
import org.bouncycastle.crypto.tls.HashAlgorithm;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsHandshakeHash;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Shorts;

class DeferredHash
implements TlsHandshakeHash {
    protected static final int BUFFERING_HASH_LIMIT = 4;
    protected TlsContext context;
    private DigestInputBuffer buf;
    private Hashtable hashes;
    private Short prfHashAlgorithm;

    DeferredHash() {
        this.buf = new DigestInputBuffer();
        this.hashes = new Hashtable();
        this.prfHashAlgorithm = null;
    }

    private DeferredHash(Short s, Digest digest2) {
        this.buf = null;
        this.hashes = new Hashtable();
        this.prfHashAlgorithm = s;
        this.hashes.put(s, digest2);
    }

    public void init(TlsContext tlsContext) {
        this.context = tlsContext;
    }

    public TlsHandshakeHash notifyPRFDetermined() {
        int n = this.context.getSecurityParameters().getPrfAlgorithm();
        if (n == 0) {
            CombinedHash combinedHash = new CombinedHash();
            combinedHash.init(this.context);
            this.buf.updateDigest(combinedHash);
            return combinedHash.notifyPRFDetermined();
        }
        this.prfHashAlgorithm = Shorts.valueOf(TlsUtils.getHashAlgorithmForPRFAlgorithm(n));
        this.checkTrackingHash(this.prfHashAlgorithm);
        return this;
    }

    public void trackHashAlgorithm(short s) {
        if (this.buf == null) {
            throw new IllegalStateException("Too late to track more hash algorithms");
        }
        this.checkTrackingHash(Shorts.valueOf(s));
    }

    public void sealHashAlgorithms() {
        this.checkStopBuffering();
    }

    public TlsHandshakeHash stopTracking() {
        Digest digest2 = TlsUtils.cloneHash(this.prfHashAlgorithm, (Digest)this.hashes.get(this.prfHashAlgorithm));
        if (this.buf != null) {
            this.buf.updateDigest(digest2);
        }
        DeferredHash deferredHash = new DeferredHash(this.prfHashAlgorithm, digest2);
        deferredHash.init(this.context);
        return deferredHash;
    }

    public Digest forkPRFHash() {
        this.checkStopBuffering();
        if (this.buf != null) {
            Digest digest2 = TlsUtils.createHash(this.prfHashAlgorithm);
            this.buf.updateDigest(digest2);
            return digest2;
        }
        return TlsUtils.cloneHash(this.prfHashAlgorithm, (Digest)this.hashes.get(this.prfHashAlgorithm));
    }

    public byte[] getFinalHash(short s) {
        Digest digest2 = (Digest)this.hashes.get(Shorts.valueOf(s));
        if (digest2 == null) {
            throw new IllegalStateException("HashAlgorithm." + HashAlgorithm.getText(s) + " is not being tracked");
        }
        digest2 = TlsUtils.cloneHash(s, digest2);
        if (this.buf != null) {
            this.buf.updateDigest(digest2);
        }
        byte[] byArray = new byte[digest2.getDigestSize()];
        digest2.doFinal(byArray, 0);
        return byArray;
    }

    public String getAlgorithmName() {
        throw new IllegalStateException("Use fork() to get a definite Digest");
    }

    public int getDigestSize() {
        throw new IllegalStateException("Use fork() to get a definite Digest");
    }

    public void update(byte by) {
        if (this.buf != null) {
            this.buf.write(by);
            return;
        }
        Enumeration enumeration = this.hashes.elements();
        while (enumeration.hasMoreElements()) {
            Digest digest2 = (Digest)enumeration.nextElement();
            digest2.update(by);
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.buf != null) {
            this.buf.write(byArray, n, n2);
            return;
        }
        Enumeration enumeration = this.hashes.elements();
        while (enumeration.hasMoreElements()) {
            Digest digest2 = (Digest)enumeration.nextElement();
            digest2.update(byArray, n, n2);
        }
    }

    public int doFinal(byte[] byArray, int n) {
        throw new IllegalStateException("Use fork() to get a definite Digest");
    }

    public void reset() {
        if (this.buf != null) {
            this.buf.reset();
            return;
        }
        Enumeration enumeration = this.hashes.elements();
        while (enumeration.hasMoreElements()) {
            Digest digest2 = (Digest)enumeration.nextElement();
            digest2.reset();
        }
    }

    protected void checkStopBuffering() {
        if (this.buf != null && this.hashes.size() <= 4) {
            Enumeration enumeration = this.hashes.elements();
            while (enumeration.hasMoreElements()) {
                Digest digest2 = (Digest)enumeration.nextElement();
                this.buf.updateDigest(digest2);
            }
            this.buf = null;
        }
    }

    protected void checkTrackingHash(Short s) {
        if (!this.hashes.containsKey(s)) {
            Digest digest2 = TlsUtils.createHash(s);
            this.hashes.put(s, digest2);
        }
    }
}

