/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.utils;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.mamoe.mirai.utils.DirectoryLogger;
import net.mamoe.mirai.utils.FileLoggerKt;
import net.mamoe.mirai.utils.SimpleLogger;
import net.mamoe.mirai.utils.SingleFileLogger;
import net.mamoe.mirai.utils.TimeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001b\u001a\u00020\u0018H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00020\f8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R]\u0010\u000f\u001aK\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0015\u0012\u0013\u0018\u00010\u0003\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0015\u0012\u0015\u0012\u0013\u0018\u00010\u0016\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/mamoe/mirai/utils/DirectoryLogger;", "Lnet/mamoe/mirai/utils/SimpleLogger;", "identity", "", "directory", "Ljava/io/File;", "retain", "", "(Ljava/lang/String;Ljava/io/File;J)V", "day", "", "delegate", "Lnet/mamoe/mirai/utils/SingleFileLogger;", "getDelegate", "()Lnet/mamoe/mirai/utils/SingleFileLogger;", "logger", "Lkotlin/Function3;", "Lnet/mamoe/mirai/utils/SimpleLogger$LogPriority;", "Lkotlin/ParameterName;", "name", "priority", "message", "", "e", "", "getLogger", "()Lkotlin/jvm/functions/Function3;", "checkOutdated", "mirai-core-api"})
@SourceDebugExtension(value={"SMAP\nFileLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileLogger.kt\nnet/mamoe/mirai/utils/DirectoryLogger\n+ 2 TimeUtils.kt\nnet/mamoe/mirai/utils/TimeUtilsKt_common\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,63:1\n56#2:64\n52#2:65\n48#2:66\n44#2:67\n40#2:68\n1295#3,2:69\n*S KotlinDebug\n*F\n+ 1 FileLogger.kt\nnet/mamoe/mirai/utils/DirectoryLogger\n*L\n33#1:64\n33#1:65\n33#1:66\n33#1:67\n33#1:68\n41#1:69,2\n*E\n"})
public final class DirectoryLogger
extends SimpleLogger {
    @NotNull
    private final File directory;
    private final long retain;
    private int day;
    @NotNull
    private SingleFileLogger delegate;
    @NotNull
    private final Function3<SimpleLogger.LogPriority, String, Throwable, Unit> logger;

    @JvmOverloads
    public DirectoryLogger(@NotNull String identity, @NotNull File directory, long retain) {
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        super("", (Function3<? super SimpleLogger.LogPriority, ? super String, ? super Throwable, Unit>)FileLoggerKt.access$getSTUB$p());
        this.directory = directory;
        this.retain = retain;
        this.directory.mkdirs();
        this.day = FileLoggerKt.getCurrentDay();
        this.delegate = new SingleFileLogger(identity, new File(this.directory, FileLoggerKt.getCurrentDate() + ".log"));
        this.logger = (Function3)new Function3<SimpleLogger.LogPriority, String, Throwable, Unit>(this){
            final /* synthetic */ DirectoryLogger this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(@NotNull SimpleLogger.LogPriority priority, @Nullable String message, @Nullable Throwable e) {
                Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
                DirectoryLogger.access$getDelegate(this.this$0).call(priority, message, e);
            }
        };
    }

    public /* synthetic */ DirectoryLogger(String string, File file, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            file = new File(string);
        }
        if ((n & 4) != 0) {
            int $this$weeksToMillis$iv = 1;
            boolean $i$f$getWeeksToMillis = false;
            int $this$daysToMillis$iv$iv = 7;
            boolean $i$f$getDaysToMillis = false;
            int $this$hoursToMillis$iv$iv$iv = 24;
            boolean $i$f$getHoursToMillis = false;
            int $this$minutesToMillis$iv$iv$iv$iv = 60;
            boolean $i$f$getMinutesToMillis = false;
            int $this$secondsToMillis$iv$iv$iv$iv$iv = 60;
            boolean $i$f$getSecondsToMillis = false;
            l = (long)$this$weeksToMillis$iv * ((long)$this$daysToMillis$iv$iv * ((long)$this$hoursToMillis$iv$iv$iv * ((long)$this$minutesToMillis$iv$iv$iv$iv * ((long)$this$secondsToMillis$iv$iv$iv$iv$iv * 1000L))));
        }
        this(string, file, l);
    }

    private final void checkOutdated() {
        long current = TimeUtilsKt.currentTimeMillis();
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)this.directory, null, (int)1, null)), (Function1)checkOutdated.1.INSTANCE), (Function1)((Function1)new Function1<File, Boolean>(current, this){
            final /* synthetic */ long $current;
            final /* synthetic */ DirectoryLogger this$0;
            {
                this.$current = $current;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$current - it.lastModified() > DirectoryLogger.access$getRetain$p(this.this$0);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            it.delete();
        }
    }

    private final SingleFileLogger getDelegate() {
        int currentDay = FileLoggerKt.getCurrentDay();
        if (this.day != currentDay) {
            this.day = currentDay;
            this.checkOutdated();
            String string = this.getIdentity();
            Intrinsics.checkNotNull((Object)string);
            this.delegate = new SingleFileLogger(string, new File(this.directory, FileLoggerKt.getCurrentDate() + ".log"));
        }
        return this.delegate;
    }

    @Override
    @NotNull
    protected Function3<SimpleLogger.LogPriority, String, Throwable, Unit> getLogger() {
        return this.logger;
    }

    @JvmOverloads
    public DirectoryLogger(@NotNull String identity, @NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this(identity, directory, 0L, 4, null);
    }

    @JvmOverloads
    public DirectoryLogger(@NotNull String identity) {
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        this(identity, null, 0L, 6, null);
    }

    public static final /* synthetic */ long access$getRetain$p(DirectoryLogger $this) {
        return $this.retain;
    }

    public static final /* synthetic */ SingleFileLogger access$getDelegate(DirectoryLogger $this) {
        return $this.getDelegate();
    }
}

