/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils.io.serialization.tars.internal;

import java.io.EOFException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.Input;
import kotlinx.io.core.InputKt;
import net.mamoe.mirai.internal.utils.io.serialization.tars.internal.DebugLogger;
import net.mamoe.mirai.internal.utils.io.serialization.tars.internal.TarsHead;
import net.mamoe.mirai.internal.utils.io.serialization.tars.internal.TarsOldKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u000bJ\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u001c\u001a\u00020\u0017H\u0002J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u000bJ\u0018\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020 2\b\b\u0002\u0010\u001e\u001a\u00020\u0001J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010)\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u000bJ\u0010\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020 H\u0001JI\u0010/\u001a\u0002H0\"\b\b\u0000\u00100*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00192\u000e\b\u0006\u00101\u001a\b\u0012\u0004\u0012\u00020,022\u0014\b\u0004\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H004H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J7\u00106\u001a\u0004\u0018\u0001H0\"\u0004\b\u0000\u001002\u0006\u0010\u001a\u001a\u00020\u00192\u0014\b\u0004\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H004H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00107J\u0013\u00108\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0086\u0010J\u000e\u00109\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019J-\u0010:\u001a\u0002H0\"\u0004\b\u0000\u001002\u0014\b\u0004\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H004H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006<"}, d2={"Lnet/mamoe/mirai/internal/utils/io/serialization/tars/internal/TarsInput;", "", "input", "Lkotlinx/io/core/Input;", "charset", "Ljava/nio/charset/Charset;", "Lkotlinx/io/charsets/Charset;", "debugLogger", "Lnet/mamoe/mirai/internal/utils/io/serialization/tars/internal/DebugLogger;", "(Lkotlinx/io/core/Input;Ljava/nio/charset/Charset;Lnet/mamoe/mirai/internal/utils/io/serialization/tars/internal/DebugLogger;)V", "_head", "Lnet/mamoe/mirai/internal/utils/io/serialization/tars/internal/TarsHead;", "_nextHead", "currentHead", "getCurrentHead", "()Lnet/mamoe/mirai/internal/utils/io/serialization/tars/internal/TarsHead;", "currentHeadOrNull", "getCurrentHeadOrNull", "getInput", "()Lkotlinx/io/core/Input;", "nextHead", "peekNextHead", "prepareNextHead", "", "readInt32", "", "tag", "readNextHeadButDoNotAssignTo_Head", "ignoreNextHead", "readTarsBooleanValue", "head", "readTarsByteValue", "", "readTarsDoubleValue", "", "readTarsFloatValue", "", "readTarsIntValue", "type", "readTarsLongValue", "", "readTarsShortValue", "", "readTarsStringValue", "", "skipField", "", "skipToHeadAndUseIfPossibleOrFail", "R", "message", "Lkotlin/Function0;", "block", "Lkotlin/Function1;", "(ILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "skipToHeadAndUseIfPossibleOrNull", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "skipToHeadOrNull", "skipToTag", "useHead", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "mirai-core"})
public final class TarsInput {
    @NotNull
    private final Input input;
    @NotNull
    private final Charset charset;
    @NotNull
    private final DebugLogger debugLogger;
    @Nullable
    private TarsHead _head;
    @Nullable
    private TarsHead _nextHead;

    public TarsInput(@NotNull Input input, @NotNull Charset charset, @NotNull DebugLogger debugLogger) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)debugLogger, (String)"debugLogger");
        this.input = input;
        this.charset = charset;
        this.debugLogger = debugLogger;
        this.prepareNextHead();
    }

    @NotNull
    public final Input getInput() {
        return this.input;
    }

    @NotNull
    public final TarsHead getCurrentHead() {
        TarsHead tarsHead = this._head;
        if (tarsHead == null) {
            throw new EOFException("No current TarsHead available");
        }
        return tarsHead;
    }

    @Nullable
    public final TarsHead getCurrentHeadOrNull() {
        return this._head;
    }

    @Nullable
    public final TarsHead peekNextHead() {
        TarsHead tarsHead;
        TarsHead tarsHead2 = this._nextHead;
        if (tarsHead2 != null) {
            TarsHead it = tarsHead2;
            boolean bl = false;
            return it;
        }
        TarsHead it = tarsHead = this.readNextHeadButDoNotAssignTo_Head(true);
        boolean bl = false;
        this._nextHead = it;
        it = tarsHead;
        boolean bl2 = false;
        System.out.println((Object)Intrinsics.stringPlus((String)"Peek next head: ", (Object)it));
        return tarsHead;
    }

    public final boolean prepareNextHead() {
        TarsHead tarsHead;
        TarsHead it = tarsHead = TarsInput.readNextHeadButDoNotAssignTo_Head$default(this, false, 1, null);
        boolean bl = false;
        this._head = it;
        return tarsHead != null;
    }

    @NotNull
    public final TarsHead nextHead() {
        if (!this.prepareNextHead()) {
            throw new EOFException("No more TarsHead available");
        }
        return this.getCurrentHead();
    }

    private final TarsHead readNextHeadButDoNotAssignTo_Head(boolean ignoreNextHead) {
        int n;
        TarsHead n2;
        if (!ignoreNextHead && (n2 = this._nextHead) != null) {
            this._nextHead = null;
            return n2;
        }
        if (this.input.getEndOfInput()) {
            return null;
        }
        Input $this$readUByte$iv = this.input;
        int $i$f$readUByte = 0;
        int n3 = $this$readUByte$iv.readByte();
        byte var2 = UByte.constructor-impl((byte)n3);
        $i$f$readUByte = 15;
        byte type = UByte.constructor-impl((byte)((byte)(var2 & $i$f$readUByte)));
        n3 = UInt.constructor-impl((int)(var2 & 0xFF));
        int tag = UInt.constructor-impl((int)(n3 >>> (n = 4)));
        if (tag == 15) {
            Input $this$readUByte$iv2 = this.input;
            boolean $i$f$readUByte2 = false;
            byte by = $this$readUByte$iv2.readByte();
            tag = UInt.constructor-impl((int)(UByte.constructor-impl((byte)by) & 0xFF));
        }
        return new TarsHead(tag, type);
    }

    static /* synthetic */ TarsHead readNextHeadButDoNotAssignTo_Head$default(TarsInput tarsInput, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return tarsInput.readNextHeadButDoNotAssignTo_Head(bl);
    }

    public final <R> R useHead(@NotNull Function1<? super TarsHead, ? extends R> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$useHead = false;
        Object object = this.getCurrentHead();
        Object it = object = block.invoke(object);
        boolean bl = false;
        this.prepareNextHead();
        return (R)object;
    }

    @Nullable
    public final <R> R skipToHeadAndUseIfPossibleOrNull(int tag, @NotNull Function1<? super TarsHead, ? extends R> block) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$skipToHeadAndUseIfPossibleOrNull = false;
        TarsHead tarsHead = this.skipToHeadOrNull(tag);
        if (tarsHead == null) {
            object2 = null;
        } else {
            TarsHead tarsHead2 = tarsHead;
            object2 = block.invoke((Object)tarsHead2);
        }
        Object it = object = object2;
        boolean bl = false;
        this.prepareNextHead();
        return (R)object;
    }

    @NotNull
    public final <R> R skipToHeadAndUseIfPossibleOrFail(int tag, @NotNull Function0<String> message2, @NotNull Function1<? super TarsHead, ? extends R> block) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(message2, (String)"message");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$skipToHeadAndUseIfPossibleOrFail = false;
        TarsInput this_$iv = this;
        boolean $i$f$skipToHeadAndUseIfPossibleOrNull = false;
        TarsHead tarsHead = this_$iv.skipToHeadOrNull(tag);
        if (tarsHead == null) {
            object2 = null;
        } else {
            TarsHead tarsHead2 = tarsHead;
            object2 = block.invoke((Object)tarsHead2);
        }
        Object it$iv = object = object2;
        boolean bl = false;
        this_$iv.prepareNextHead();
        Object object3 = object;
        if (object3 == null) {
            Object object4 = message2.invoke();
            throw new IllegalStateException(object4.toString());
        }
        return (R)object3;
    }

    public static /* synthetic */ Object skipToHeadAndUseIfPossibleOrFail$default(TarsInput this_, int tag, Function0 message2, Function1 block, int n, Object object) {
        Object object2;
        Object object3;
        if ((n & 2) != 0) {
            message2 = (Function0)new Function0<String>(tag){
                final /* synthetic */ int $tag;
                {
                    this.$tag = $tag;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Intrinsics.stringPlus((String)"tag not found: ", (Object)this.$tag);
                }
            };
        }
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        boolean $i$f$skipToHeadAndUseIfPossibleOrFail = false;
        TarsInput this_$iv = this_;
        boolean $i$f$skipToHeadAndUseIfPossibleOrNull = false;
        TarsHead tarsHead = this_$iv.skipToHeadOrNull(tag);
        if (tarsHead == null) {
            object3 = null;
        } else {
            TarsHead tarsHead2 = tarsHead;
            object3 = block.invoke((Object)tarsHead2);
        }
        Object it$iv = object2 = object3;
        boolean bl = false;
        this_$iv.prepareNextHead();
        Object object4 = object2;
        if (object4 == null) {
            Object object5 = message2.invoke();
            throw new IllegalStateException(object5.toString());
        }
        return object4;
    }

    public final boolean skipToTag(int tag) {
        while (this.peekNextHead() != null) {
            TarsHead hd;
            if (tag <= hd.getTag() || hd.getType() == 11) {
                return tag == hd.getTag();
            }
            System.out.println((Object)("Discard " + tag + ", " + hd + ", " + hd.getSize()));
            InputKt.discardExact((Input)this.input, (int)hd.getSize());
            this.skipField(hd.getType());
        }
        return false;
    }

    public final int readInt32(int tag) {
        if (!this.skipToTag(tag)) {
            return 0;
        }
        return this.readTarsIntValue(this.nextHead());
    }

    @Nullable
    public final TarsHead skipToHeadOrNull(int tag) {
        TarsHead tarsHead;
        TarsInput tarsInput = this;
        int n = tag;
        while (true) {
            TarsHead current;
            TarsInput tarsInput2 = tarsInput;
            int n2 = n;
            if (tarsInput2.getCurrentHeadOrNull() == null) {
                return null;
            }
            if (current.getTag() > n2) {
                tarsHead = null;
                break;
            }
            if (current.getTag() == n2) {
                tarsHead = current;
                break;
            }
            tarsInput2.skipField(current.getType());
            if (!tarsInput2.prepareNextHead()) {
                boolean bl = false;
                String string = "cannot skip to tag " + n2 + ", early EOF";
                throw new IllegalStateException(string.toString());
            }
            tarsInput = tarsInput2;
            n = n2;
        }
        return tarsHead;
    }

    @PublishedApi
    public final void skipField(byte type) {
        System.out.println(new Function0<String>(type){
            final /* synthetic */ byte $type;
            {
                this.$type = $type;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"skipping ", (Object)TarsHead.Companion.findTarsTypeName(this.$type));
            }
        });
        byte by = type;
        if (by == 0) {
            InputKt.discardExact((Input)this.input, (int)1);
        } else if (by == 1) {
            InputKt.discardExact((Input)this.input, (int)2);
        } else if (by == 2) {
            InputKt.discardExact((Input)this.input, (int)4);
        } else if (by == 3) {
            InputKt.discardExact((Input)this.input, (int)8);
        } else if (by == 4) {
            InputKt.discardExact((Input)this.input, (int)4);
        } else if (by == 5) {
            InputKt.discardExact((Input)this.input, (int)8);
        } else if (by == 6) {
            Input $this$readUByte$iv = this.input;
            boolean $i$f$readUByte = false;
            byte by2 = $this$readUByte$iv.readByte();
            InputKt.discardExact((Input)this.input, (int)(UByte.constructor-impl((byte)by2) & 0xFF));
        } else if (by == 7) {
            InputKt.discardExact((Input)this.input, (int)this.input.readInt());
        } else if (by == 8) {
            DebugLogger $this$readUByte$iv = this.debugLogger;
            int $i$f$readUByte = $this$readUByte$iv.getStructureHierarchy();
            $this$readUByte$iv.setStructureHierarchy($i$f$readUByte + 1);
            int it = $this$readUByte$iv = this.readInt32(0);
            int n = 0;
            System.out.println((Object)Intrinsics.stringPlus((String)"SIZE = ", (Object)it));
            $this$readUByte$iv *= 2;
            it = 0;
            while (it < $this$readUByte$iv) {
                int it2 = n = it++;
                boolean bl = false;
                this.skipField(this.nextHead().getType());
            }
            $this$readUByte$iv = this.debugLogger;
            it = $this$readUByte$iv.getStructureHierarchy();
            $this$readUByte$iv.setStructureHierarchy(it + -1);
        } else if (by == 9) {
            DebugLogger $this$readUByte$iv = this.debugLogger;
            int it = $this$readUByte$iv.getStructureHierarchy();
            $this$readUByte$iv.setStructureHierarchy(it + 1);
            it = $this$readUByte$iv = this.readInt32(0);
            int n3 = 0;
            System.out.println((Object)Intrinsics.stringPlus((String)"SIZE = ", (Object)it));
            int n2 = 0;
            while (n2 < $this$readUByte$iv) {
                int it3 = n3 = n2++;
                boolean bl = false;
                this.skipField(this.nextHead().getType());
            }
            $this$readUByte$iv = this.debugLogger;
            n2 = $this$readUByte$iv.getStructureHierarchy();
            $this$readUByte$iv.setStructureHierarchy(n2 + -1);
        } else if (by == 10) {
            DebugLogger $this$readUByte$iv = this.debugLogger;
            int n = $this$readUByte$iv.getStructureHierarchy();
            $this$readUByte$iv.setStructureHierarchy(n + 1);
            TarsHead head = null;
            do {
                if ((head = this.nextHead()).getType() == 11) {
                    DebugLogger debugLogger = this.debugLogger;
                    int n3 = debugLogger.getStructureHierarchy();
                    debugLogger.setStructureHierarchy(n3 + -1);
                    this.skipField(head.getType());
                    break;
                }
                this.skipField(head.getType());
            } while (head.getType() != 11);
        } else if (!(by == 11 ? true : by == 12)) {
            if (by == 13) {
                Object head = this.debugLogger;
                int n = ((DebugLogger)head).getStructureHierarchy();
                ((DebugLogger)head).setStructureHierarchy(n + 1);
                head = null;
                head = this.nextHead();
                if (!(((TarsHead)head).getType() == 0)) {
                    boolean $i$a$-check-TarsInput$skipField$92 = false;
                    String $i$a$-check-TarsInput$skipField$92 = "bad simple list element type: " + ((TarsHead)head).getType() + ", " + head;
                    throw new IllegalStateException($i$a$-check-TarsInput$skipField$92.toString());
                }
                if (!(((TarsHead)head).getTag() == 0)) {
                    boolean $i$a$-check-TarsInput$skipField$102 = false;
                    String $i$a$-check-TarsInput$skipField$102 = Intrinsics.stringPlus((String)"simple list element tag must be 0, but was ", (Object)((TarsHead)head).getTag());
                    throw new IllegalStateException($i$a$-check-TarsInput$skipField$102.toString());
                }
                head = this.nextHead();
                if (!(((TarsHead)head).getTag() == 0)) {
                    boolean bl = false;
                    String string = Intrinsics.stringPlus((String)"tag for size for simple list must be 0, but was ", (Object)((TarsHead)head).getTag());
                    throw new IllegalStateException(string.toString());
                }
                InputKt.discardExact((Input)this.input, (int)this.readTarsIntValue((TarsHead)head));
                DebugLogger debugLogger = this.debugLogger;
                int n4 = debugLogger.getStructureHierarchy();
                debugLogger.setStructureHierarchy(n4 + -1);
            } else {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"invalid type: ", (Object)type).toString());
            }
        }
    }

    public final int readTarsIntValue(@NotNull TarsHead head) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        return this.readTarsIntValue(head.getType(), head);
    }

    public final int readTarsIntValue(byte type, @NotNull Object head) {
        int n;
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        byte by = type;
        if (by == 12) {
            n = 0;
        } else if (by == 0) {
            n = this.input.readByte();
        } else if (by == 1) {
            n = this.input.readShort();
        } else if (by == 2) {
            n = this.input.readInt();
        } else {
            throw new IllegalStateException(("type mismatch: " + head + ", expecting int.").toString());
        }
        return n;
    }

    public static /* synthetic */ int readTarsIntValue$default(TarsInput tarsInput, byte by, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = by;
        }
        return tarsInput.readTarsIntValue(by, object);
    }

    public final short readTarsShortValue(@NotNull TarsHead head) {
        short s;
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        byte by = head.getType();
        if (by == 12) {
            s = 0;
        } else if (by == 0) {
            s = this.input.readByte();
        } else if (by == 1) {
            s = this.input.readShort();
        } else {
            throw new IllegalStateException(("type mismatch: " + head + ", expecting short.").toString());
        }
        return s;
    }

    public final long readTarsLongValue(@NotNull TarsHead head) {
        long l;
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        byte by = head.getType();
        if (by == 12) {
            l = 0L;
        } else if (by == 0) {
            l = this.input.readByte();
        } else if (by == 1) {
            l = this.input.readShort();
        } else if (by == 2) {
            l = this.input.readInt();
        } else if (by == 3) {
            l = this.input.readLong();
        } else {
            throw new IllegalStateException(("type mismatch " + head + ", expecting long.").toString());
        }
        return l;
    }

    public final byte readTarsByteValue(@NotNull TarsHead head) {
        byte by;
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        byte by2 = head.getType();
        if (by2 == 12) {
            by = 0;
        } else if (by2 == 0) {
            by = this.input.readByte();
        } else {
            throw new IllegalStateException(("type mismatch: " + head + ", expecting byte.").toString());
        }
        return by;
    }

    public final float readTarsFloatValue(@NotNull TarsHead head) {
        float f;
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        byte by = head.getType();
        if (by == 12) {
            f = 0.0f;
        } else if (by == 4) {
            f = this.input.readFloat();
        } else {
            throw new IllegalStateException(("type mismatch: " + head + ", expecting float.").toString());
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readTarsStringValue(@NotNull TarsHead head) {
        String string;
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        byte by = head.getType();
        if (by == 6) {
            Input $this$readUByte$iv = this.input;
            boolean $i$f$readUByte = false;
            byte by2 = $this$readUByte$iv.readByte();
            string = TarsOldKt.readString(this.input, UByte.constructor-impl((byte)by2) & 0xFF, this.charset);
        } else if (by == 7) {
            void it;
            int n;
            Input $this$readUInt$iv = this.input;
            int $i$f$readUInt = 0;
            int n2 = $this$readUInt$iv.readInt();
            $i$f$readUInt = n = UInt.constructor-impl((int)n2);
            Input input = this.input;
            boolean bl = false;
            if (!(true <= it ? it < 0x6400000 : false)) {
                boolean bl2 = false;
                String string2 = Intrinsics.stringPlus((String)"bad string length: ", (Object)((int)it));
                throw new IllegalArgumentException(string2.toString());
            }
            string = TarsOldKt.readString(input, n, this.charset);
        } else {
            throw new IllegalStateException(("type mismatch: " + head + ", expecting 6 or 7 (for string)").toString());
        }
        return string;
    }

    public final double readTarsDoubleValue(@NotNull TarsHead head) {
        double d;
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        switch (head.getType()) {
            case 12: {
                d = 0.0;
                break;
            }
            case 4: {
                d = this.input.readFloat();
                break;
            }
            case 5: {
                d = this.input.readDouble();
                break;
            }
            default: {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"type mismatch: ", (Object)head).toString());
            }
        }
        return d;
    }

    public final boolean readTarsBooleanValue(@NotNull TarsHead head) {
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        return this.readTarsByteValue(head) == 1;
    }
}

