/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.components;

import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import net.mamoe.mirai.internal.BotAccount;
import net.mamoe.mirai.internal.network.components.AccountSecrets;
import net.mamoe.mirai.internal.network.components.AccountSecretsImpl;
import net.mamoe.mirai.internal.network.components.AccountSecretsManager;
import net.mamoe.mirai.internal.network.components.AccountSecretsManagerKt;
import net.mamoe.mirai.internal.utils.crypto.TEA;
import net.mamoe.mirai.internal.utils.io.ProtoBuf;
import net.mamoe.mirai.internal.utils.io.serialization.SerializationUtils;
import net.mamoe.mirai.utils.FileKt;
import net.mamoe.mirai.utils.MiraiFile;
import net.mamoe.mirai.utils.MiraiLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lnet/mamoe/mirai/internal/network/components/FileCacheAccountSecretsManager;", "Lnet/mamoe/mirai/internal/network/components/AccountSecretsManager;", "file", "Lnet/mamoe/mirai/utils/MiraiFile;", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "(Lnet/mamoe/mirai/utils/MiraiFile;Lnet/mamoe/mirai/utils/MiraiLogger;)V", "getFile", "()Lnet/mamoe/mirai/utils/MiraiFile;", "getLogger", "()Lnet/mamoe/mirai/utils/MiraiLogger;", "getSecrets", "Lnet/mamoe/mirai/internal/network/components/AccountSecrets;", "account", "Lnet/mamoe/mirai/internal/BotAccount;", "getSecretsImpl", "invalidate", "", "saveSecrets", "secrets", "Companion", "mirai-core"})
public final class FileCacheAccountSecretsManager
implements AccountSecretsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MiraiFile file;
    @NotNull
    private final MiraiLogger logger;

    public FileCacheAccountSecretsManager(@NotNull MiraiFile file, @NotNull MiraiLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.file = file;
        this.logger = logger2;
    }

    @NotNull
    public final MiraiFile getFile() {
        return this.file;
    }

    @NotNull
    public final MiraiLogger getLogger() {
        return this.logger;
    }

    @Override
    public synchronized void saveSecrets(@NotNull BotAccount account, @NotNull AccountSecrets secrets) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)secrets, (String)"secrets");
        if (secrets.getWLoginSigInfoField() == null) {
            return;
        }
        Companion.saveSecretsToFile(this.file, account, secrets);
        MiraiLogger $this$info$iv = this.logger;
        boolean $i$f$info = false;
        if ($this$info$iv.isInfoEnabled()) {
            MiraiLogger miraiLogger = $this$info$iv;
            boolean bl = false;
            miraiLogger.info("Saved account secrets to local cache for fast login.");
        }
    }

    @Override
    @Nullable
    public synchronized AccountSecrets getSecrets(@NotNull BotAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        return this.getSecretsImpl(account);
    }

    private final AccountSecrets getSecretsImpl(BotAccount account) {
        Object $i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$22;
        if (!this.file.exists()) {
            return null;
        }
        try {
            boolean $i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$22 = false;
            $i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$22 = Result.constructor-impl((Object)((AccountSecretsImpl)SerializationUtils.loadAs$default(TEA.decrypt$default(FileKt.readBytes((MiraiFile)this.file), account.getPasswordMd5(), 0, 4, null), (DeserializationStrategy)AccountSecretsImpl.Companion.serializer(), 0, 2, null)));
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)$i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$22);
        if (throwable != null) {
            Throwable e = throwable;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)e.getMessage(), (Object)"Field 'ecdhInitialPublicKey' is required for type with serial name 'net.mamoe.mirai.internal.network.components.AccountSecretsImpl', but it was missing")) {
                MiraiLogger $this$info$iv = this.logger;
                boolean $i$f$info = false;
                if ($this$info$iv.isInfoEnabled()) {
                    MiraiLogger miraiLogger = $this$info$iv;
                    boolean bl2 = false;
                    miraiLogger.info("Detected old account secrets, invalidating...");
                }
            } else {
                this.logger.error("Failed to load account secrets from local cache. Invalidating cache...", e);
            }
            this.file.delete();
            return null;
        }
        AccountSecretsImpl loaded2 = (AccountSecretsImpl)$i$a$-runCatching-FileCacheAccountSecretsManager$getSecretsImpl$loaded$22;
        MiraiLogger $this$info$iv = this.logger;
        boolean $i$f$info = false;
        if ($this$info$iv.isInfoEnabled()) {
            MiraiLogger miraiLogger = $this$info$iv;
            boolean bl = false;
            miraiLogger.info("Loaded account secrets from local cache.");
        }
        return loaded2;
    }

    @Override
    public synchronized void invalidate() {
        this.file.delete();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lnet/mamoe/mirai/internal/network/components/FileCacheAccountSecretsManager$Companion;", "", "()V", "saveSecretsToFile", "", "file", "Lnet/mamoe/mirai/utils/MiraiFile;", "account", "Lnet/mamoe/mirai/internal/BotAccount;", "secrets", "Lnet/mamoe/mirai/internal/network/components/AccountSecrets;", "mirai-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void saveSecretsToFile(@NotNull MiraiFile file, @NotNull BotAccount account, @NotNull AccountSecrets secrets) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)secrets, (String)"secrets");
            FileKt.writeBytes((MiraiFile)file, (byte[])TEA.encrypt$default(SerializationUtils.toByteArray((ProtoBuf)AccountSecretsManagerKt.AccountSecretsImpl(secrets), (SerializationStrategy)AccountSecretsImpl.Companion.serializer()), account.getPasswordMd5(), 0, 4, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

