/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.component;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.network.component.ComponentKey;
import net.mamoe.mirai.internal.network.component.ComponentStorage;
import net.mamoe.mirai.internal.network.component.ConcurrentComponentStorageKt;
import net.mamoe.mirai.internal.network.component.MutableComponentStorage;
import net.mamoe.mirai.internal.network.component.NoSuchComponentException;
import net.mamoe.mirai.utils.CollectionsKt;
import net.mamoe.mirai.utils.TestOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\u0017\u001a\u0002H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001b\u001a\u0004\u0018\u0001H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000bH\u0016\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001c\u001a\u0004\u0018\u0001H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000bH\u0016\u00a2\u0006\u0002\u0010\u001aJ.\u0010\u001d\u001a\u00020\u001e\"\b\b\u0000\u0010\u0018*\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000b2\u0006\u0010\u001f\u001a\u0002H\u0018H\u0096\u0002\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\"H\u0016R\u0016\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u00128VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lnet/mamoe/mirai/internal/network/component/ConcurrentComponentStorage;", "Lnet/mamoe/mirai/internal/network/component/ComponentStorage;", "Lnet/mamoe/mirai/internal/network/component/MutableComponentStorage;", "showAllComponents", "", "creationStacktrace", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(ZLjava/lang/Exception;)V", "keys", "", "Lnet/mamoe/mirai/internal/network/component/ComponentKey;", "getKeys", "()Ljava/util/Set;", "map", "", "", "size", "", "getSize$annotations", "()V", "getSize", "()I", "get", "T", "key", "(Lnet/mamoe/mirai/internal/network/component/ComponentKey;)Ljava/lang/Object;", "getOrNull", "remove", "set", "", "value", "(Lnet/mamoe/mirai/internal/network/component/ComponentKey;Ljava/lang/Object;)V", "toString", "", "mirai-core"})
public final class ConcurrentComponentStorage
implements ComponentStorage,
MutableComponentStorage {
    private final boolean showAllComponents;
    @Nullable
    private final Exception creationStacktrace;
    @NotNull
    private final Map<ComponentKey<?>, Object> map;

    public ConcurrentComponentStorage(boolean showAllComponents, @Nullable Exception creationStacktrace) {
        this.showAllComponents = showAllComponents;
        this.creationStacktrace = creationStacktrace;
        this.map = CollectionsKt.ConcurrentHashMap();
    }

    public /* synthetic */ ConcurrentComponentStorage(boolean bl, Exception exception, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = ConcurrentComponentStorageKt.access$getSHOW_ALL_COMPONENTS();
        }
        if ((n & 2) != 0) {
            exception = ConcurrentComponentStorageKt.access$getSHOW_COMPONENTS_CREATION_STACKTRACE() ? new Exception("ConcurrentComponentStorage Creation stacktrace") : null;
        }
        this(bl, exception);
    }

    @Override
    @NotNull
    public Set<ComponentKey<?>> getKeys() {
        return this.map.keySet();
    }

    @Override
    public int getSize() {
        return this.map.size();
    }

    @TestOnly
    public static /* synthetic */ void getSize$annotations() {
    }

    @Override
    @NotNull
    public <T> T get(@NotNull ComponentKey<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        T t = this.getOrNull(key);
        if (t == null) {
            throw new NoSuchComponentException(key, this, this.creationStacktrace);
        }
        return t;
    }

    @Override
    @Nullable
    public <T> T getOrNull(@NotNull ComponentKey<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (T)this.map.get(key);
    }

    @Override
    public <T> void set(@NotNull ComponentKey<T> key, @NotNull T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.map.put(key, value);
    }

    @Override
    @Nullable
    public <T> T remove(@NotNull ComponentKey<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (T)this.map.remove(key);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.showAllComponents) {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = $this$toString_u24lambda_u240.append("ConcurrentComponentStorage(size=").append(this.map.size()).append(") {");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(\"ConcurrentCompon\u2026d(map.size).append(\") {\")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            for (Map.Entry<ComponentKey<?>, Object> entry : this.map.entrySet()) {
                ComponentKey<?> key = entry.getKey();
                Object value = entry.getValue();
                StringBuilder stringBuilder3 = $this$toString_u24lambda_u240.append("  ").append(ComponentKey.Companion.componentName(key, false)).append(": ").append(value);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(\"  \").append(key.\u2026ppend(\": \").append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            }
            $this$toString_u24lambda_u240.append('}');
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }
        return "ConcurrentComponentStorage(size=" + this.map.size() + ')';
    }

    public ConcurrentComponentStorage() {
        this(false, null, 3, null);
    }
}

