/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.components;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.internal.AbstractBot;
import net.mamoe.mirai.internal.contact.UtilKt;
import net.mamoe.mirai.internal.network.MultiPacket;
import net.mamoe.mirai.internal.network.Packet;
import net.mamoe.mirai.internal.network.ParseErrorPacket;
import net.mamoe.mirai.internal.network.components.PacketLoggingStrategy;
import net.mamoe.mirai.internal.network.components.PacketLoggingStrategyImpl;
import net.mamoe.mirai.internal.network.components.PacketLoggingStrategyKt;
import net.mamoe.mirai.internal.network.protocol.packet.IncomingPacket;
import net.mamoe.mirai.internal.network.protocol.packet.OutgoingPacket;
import net.mamoe.mirai.utils.Either;
import net.mamoe.mirai.utils.MiraiLogger;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/mamoe/mirai/internal/network/components/PacketLoggingStrategyImpl;", "Lnet/mamoe/mirai/internal/network/components/PacketLoggingStrategy;", "bot", "Lnet/mamoe/mirai/internal/AbstractBot;", "blacklist", "", "", "(Lnet/mamoe/mirai/internal/AbstractBot;Ljava/util/Set;)V", "logReceived", "", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "incomingPacket", "Lnet/mamoe/mirai/internal/network/protocol/packet/IncomingPacket;", "logReceivedImpl", "packet", "Lnet/mamoe/mirai/internal/network/Packet;", "logSent", "outgoingPacket", "Lnet/mamoe/mirai/internal/network/protocol/packet/OutgoingPacket;", "Companion", "mirai-core"})
@SourceDebugExtension(value={"SMAP\nPacketLoggingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacketLoggingStrategy.kt\nnet/mamoe/mirai/internal/network/components/PacketLoggingStrategyImpl\n+ 2 MiraiLogger.kt\nnet/mamoe/mirai/utils/Utils__MiraiLoggerKt\n+ 3 Either.kt\nnet/mamoe/mirai/utils/Either$Companion\n+ 4 StandardUtils.kt\nnet/mamoe/mirai/utils/StandardUtilsKt_common\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n188#2,2:122\n188#2,2:131\n188#2,2:133\n138#3:124\n93#3:125\n32#4,2:126\n19#4,2:129\n1#5:128\n*S KotlinDebug\n*F\n+ 1 PacketLoggingStrategy.kt\nnet/mamoe/mirai/internal/network/components/PacketLoggingStrategyImpl\n*L\n45#1:122,2\n85#1:131,2\n87#1:133,2\n49#1:124\n49#1:125\n49#1:126,2\n49#1:129,2\n49#1:128\n*E\n"})
public final class PacketLoggingStrategyImpl
implements PacketLoggingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractBot bot;
    @NotNull
    private final Set<String> blacklist;
    @NotNull
    private static final Lazy<Set<String>> DEFAULT_BLACKLIST$delegate = LazyKt.lazy((Function0)Companion.DEFAULT_BLACKLIST.2.INSTANCE);

    public PacketLoggingStrategyImpl(@NotNull AbstractBot bot, @NotNull Set<String> blacklist) {
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Intrinsics.checkNotNullParameter(blacklist, (String)"blacklist");
        this.bot = bot;
        this.blacklist = blacklist;
    }

    public /* synthetic */ PacketLoggingStrategyImpl(AbstractBot abstractBot, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set2 = Companion.getDefaultBlacklist();
        }
        this(abstractBot, set2);
    }

    @Override
    public void logSent(@NotNull MiraiLogger logger2, @NotNull OutgoingPacket outgoingPacket) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)outgoingPacket, (String)"outgoingPacket");
        if (this.blacklist.contains(outgoingPacket.getCommandName())) {
            return;
        }
        MiraiLogger $this$verbose$iv = logger2;
        boolean $i$f$verbose = false;
        if ($this$verbose$iv.isVerboseEnabled()) {
            MiraiLogger miraiLogger = $this$verbose$iv;
            boolean bl = false;
            miraiLogger.verbose("Send: " + outgoingPacket.getDisplayName());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logReceived(@NotNull MiraiLogger logger2, @NotNull IncomingPacket incomingPacket) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)incomingPacket, (String)"incomingPacket");
        Either.Companion companion = Either.Companion;
        Object $this$fold_u2d1gtWUZ4$iv = incomingPacket.getResult-AtAycW8();
        boolean bl = false;
        void var6_6 = this_$iv;
        Object $this$leftOrNull$iv$iv = $this$fold_u2d1gtWUZ4$iv;
        boolean bl2 = false;
        Object $this$safeCast$iv$iv$iv = $this$leftOrNull$iv$iv;
        boolean $i$f$safeCast = false;
        Object object = $this$safeCast$iv$iv$iv;
        if (!(object instanceof Throwable)) {
            object = null;
        }
        Throwable throwable = (Throwable)object;
        if (throwable != null) {
            Throwable it$iv = throwable;
            boolean bl3 = false;
            Throwable e = it$iv;
            boolean bl4 = false;
            if (e instanceof CancellationException) {
                return;
            }
            logger2.error("Exception in decoding packet.", e);
        } else {
            Object $this$cast$iv$iv = $this$fold_u2d1gtWUZ4$iv;
            boolean $i$f$cast = false;
            Packet packet2 = (Packet)$this$cast$iv$iv;
            boolean bl5 = false;
            if (packet2 == null) {
                return;
            }
            if (!this.bot.getLogger().isEnabled() && !logger2.isEnabled()) {
                return;
            }
            if (packet2 instanceof MultiPacket) {
                if (((MultiPacket)packet2).isMeaningful()) {
                    this.logReceivedImpl(packet2, incomingPacket, logger2);
                }
                Iterator<Packet> iterator2 = ((MultiPacket)packet2).children();
                while (iterator2.hasNext()) {
                    Packet d = iterator2.next();
                    this.logReceivedImpl(d, incomingPacket, logger2);
                }
            }
            this.logReceivedImpl(packet2, incomingPacket, logger2);
        }
    }

    private final void logReceivedImpl(Packet packet2, IncomingPacket incomingPacket, MiraiLogger logger2) {
        Packet packet3 = packet2;
        if (packet3 instanceof ParseErrorPacket) {
            ((ParseErrorPacket)packet2).getDirection().getLogger(this.bot).error("Exception on parsing packet.", ((ParseErrorPacket)packet2).getError());
        } else if (packet3 instanceof MessageEvent) {
            UtilKt.logMessageReceived((MessageEvent)packet2);
        } else if (!(packet3 instanceof Packet.NoLog)) {
            if (this.blacklist.contains(incomingPacket.getCommandName())) {
                return;
            }
            if (PacketLoggingStrategyKt.access$getSHOW_PACKET_DETAILS$p()) {
                MiraiLogger $this$verbose$iv = logger2;
                boolean $i$f$verbose = false;
                if ($this$verbose$iv.isVerboseEnabled()) {
                    MiraiLogger miraiLogger = $this$verbose$iv;
                    boolean bl = false;
                    miraiLogger.verbose(UtilKt.replaceMagicCodes("Recv: " + incomingPacket.getCommandName() + ' ' + Either.toString-impl((Object)incomingPacket.getResult-AtAycW8())));
                }
            } else {
                MiraiLogger $this$verbose$iv = logger2;
                boolean $i$f$verbose = false;
                if ($this$verbose$iv.isVerboseEnabled()) {
                    MiraiLogger miraiLogger = $this$verbose$iv;
                    boolean bl = false;
                    miraiLogger.verbose(UtilKt.replaceMagicCodes("Recv: " + incomingPacket.getCommandName()));
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lnet/mamoe/mirai/internal/network/components/PacketLoggingStrategyImpl$Companion;", "", "()V", "DEFAULT_BLACKLIST", "", "", "getDEFAULT_BLACKLIST", "()Ljava/util/Set;", "DEFAULT_BLACKLIST$delegate", "Lkotlin/Lazy;", "getDefaultBlacklist", "mirai-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getDefaultBlacklist() {
            if (MiraiUtils.systemProp((String)"mirai.network.show.verbose.packets", (boolean)false)) {
                return SetsKt.emptySet();
            }
            return this.getDEFAULT_BLACKLIST();
        }

        private final Set<String> getDEFAULT_BLACKLIST() {
            Lazy lazy = DEFAULT_BLACKLIST$delegate;
            return (Set)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

