/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.message;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.internal.message.MessageToElemsKt;
import net.mamoe.mirai.internal.message.ReceiveMessageTransformer;
import net.mamoe.mirai.internal.message.data.LongMessageInternal;
import net.mamoe.mirai.internal.message.data.OnlineAudioImpl;
import net.mamoe.mirai.internal.message.protocol.impl.PokeMessageProtocol;
import net.mamoe.mirai.internal.message.protocol.impl.RichMessageProtocol;
import net.mamoe.mirai.internal.message.source.OfflineSourceImplKt;
import net.mamoe.mirai.internal.message.source.OnlineMessageSourceFromFriendImpl;
import net.mamoe.mirai.internal.message.source.OnlineMessageSourceFromGroupImpl;
import net.mamoe.mirai.internal.message.source.OnlineMessageSourceFromStrangerImpl;
import net.mamoe.mirai.internal.message.source.OnlineMessageSourceFromTempImpl;
import net.mamoe.mirai.internal.network.protocol.data.proto.ImMsgBody;
import net.mamoe.mirai.internal.network.protocol.data.proto.MsgComm;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.Audio;
import net.mamoe.mirai.message.data.AudioCodec;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageMetadata;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.message.data.MessageSourceKind;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.PokeMessage;
import net.mamoe.mirai.message.data.QuoteReply;
import net.mamoe.mirai.message.data.SingleMessage;
import net.mamoe.mirai.message.data.VipFace;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\n\u0010\u000e\u001a\u00020\u000f*\u00020\u000fJ\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012J\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lnet/mamoe/mirai/internal/message/ReceiveMessageTransformer;", "", "()V", "createMessageSource", "Lnet/mamoe/mirai/message/data/MessageSource;", "bot", "Lnet/mamoe/mirai/Bot;", "onlineSource", "", "messageSourceKind", "Lnet/mamoe/mirai/message/data/MessageSourceKind;", "messageList", "", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/MsgComm$Msg;", "cleanupRubbishMessageElements", "Lnet/mamoe/mirai/message/data/MessageChain;", "compressContinuousPlainText", "", "Lnet/mamoe/mirai/message/data/MessageChainBuilder;", "toAudio", "Lnet/mamoe/mirai/internal/message/data/OnlineAudioImpl;", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$Ptt;", "mirai-core"})
@SourceDebugExtension(value={"SMAP\nReceiveMessageHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReceiveMessageHandler.kt\nnet/mamoe/mirai/internal/message/ReceiveMessageTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,314:1\n350#2,7:315\n350#2,7:322\n350#2,7:329\n1747#2,3:336\n350#2,7:339\n350#2,7:346\n350#2,7:353\n*S KotlinDebug\n*F\n+ 1 ReceiveMessageHandler.kt\nnet/mamoe/mirai/internal/message/ReceiveMessageTransformer\n*L\n238#1:315,7\n239#1:322,7\n249#1:329,7\n272#1:336,3\n277#1:339,7\n297#1:346,7\n298#1:353,7\n*E\n"})
public final class ReceiveMessageTransformer {
    @NotNull
    public static final ReceiveMessageTransformer INSTANCE = new ReceiveMessageTransformer();

    private ReceiveMessageTransformer() {
    }

    @NotNull
    public final MessageSource createMessageSource(@NotNull Bot bot, boolean onlineSource, @NotNull MessageSourceKind messageSourceKind, @NotNull List<MsgComm.Msg> messageList) {
        MessageSource messageSource;
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Intrinsics.checkNotNullParameter((Object)messageSourceKind, (String)"messageSourceKind");
        Intrinsics.checkNotNullParameter(messageList, (String)"messageList");
        boolean bl = onlineSource;
        if (bl) {
            MessageMetadata messageMetadata;
            switch (WhenMappings.$EnumSwitchMapping$0[messageSourceKind.ordinal()]) {
                case 1: {
                    messageMetadata = new OnlineMessageSourceFromTempImpl(bot, messageList);
                    break;
                }
                case 2: {
                    messageMetadata = new OnlineMessageSourceFromGroupImpl(bot, messageList);
                    break;
                }
                case 3: {
                    messageMetadata = new OnlineMessageSourceFromFriendImpl(bot, messageList);
                    break;
                }
                case 4: {
                    messageMetadata = new OnlineMessageSourceFromStrangerImpl(bot, messageList);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            messageSource = (MessageSource)messageMetadata;
        } else if (!bl) {
            messageSource = (MessageSource)OfflineSourceImplKt.OfflineMessageSourceImplData(bot, messageList, messageSourceKind);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return messageSource;
    }

    public final void compressContinuousPlainText(@NotNull MessageChainBuilder $this$compressContinuousPlainText) {
        Intrinsics.checkNotNullParameter((Object)$this$compressContinuousPlainText, (String)"<this>");
        int index = 0;
        StringBuilder builder = new StringBuilder();
        while (index + 1 < $this$compressContinuousPlainText.size()) {
            SingleMessage elm0 = $this$compressContinuousPlainText.get(index);
            SingleMessage elm1 = $this$compressContinuousPlainText.get(index + 1);
            if (elm0 instanceof PlainText && elm1 instanceof PlainText) {
                SingleMessage elm;
                builder.setLength(0);
                int end = -1;
                int i = index;
                int n = $this$compressContinuousPlainText.size();
                while (i < n && (elm = $this$compressContinuousPlainText.get(i)) instanceof PlainText) {
                    end = i++;
                    builder.append(((PlainText)elm).getContent());
                }
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
                $this$compressContinuousPlainText.set(index, (SingleMessage)new PlainText(string));
                int index1 = index + 1;
                n = end - index;
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    $this$compressContinuousPlainText.remove(index1);
                }
            }
            ++index;
        }
        CollectionsKt.removeAll((List)((List)$this$compressContinuousPlainText), (Function1)compressContinuousPlainText.2.INSTANCE);
    }

    @NotNull
    public final MessageChain cleanupRubbishMessageElements(@NotNull MessageChain $this$cleanupRubbishMessageElements) {
        int n;
        int n2;
        MessageChainBuilder messageChainBuilder;
        MessageChainBuilder builder;
        block30: {
            int n3;
            List $this$indexOfFirst$iv;
            int index$iv;
            boolean $i$f$indexOfFirst;
            block29: {
                int vipFaceIndex;
                block28: {
                    int n4;
                    boolean bl;
                    SingleMessage it;
                    block27: {
                        int quoteReplyIndex;
                        block26: {
                            int n5;
                            int quoteReplyIndex2;
                            int exceptedQuoteReplyIndex;
                            int index$iv2;
                            block25: {
                                int n6;
                                int n7;
                                block24: {
                                    MessageChainBuilder messageChainBuilder2;
                                    Intrinsics.checkNotNullParameter((Object)$this$cleanupRubbishMessageElements, (String)"<this>");
                                    MessageChainBuilder it2 = messageChainBuilder2 = new MessageChainBuilder(((Collection)$this$cleanupRubbishMessageElements).size());
                                    boolean bl2 = false;
                                    it2.addAll((Collection)$this$cleanupRubbishMessageElements);
                                    builder = messageChainBuilder2;
                                    boolean bl3 = false;
                                    List $this$indexOfFirst$iv2 = (List)builder;
                                    boolean $i$f$indexOfFirst2 = false;
                                    index$iv2 = 0;
                                    for (Object item$iv : $this$indexOfFirst$iv2) {
                                        it = (SingleMessage)item$iv;
                                        boolean bl4 = false;
                                        if (it instanceof MessageSource) {
                                            n7 = index$iv2;
                                            break block24;
                                        }
                                        ++index$iv2;
                                    }
                                    n7 = -1;
                                }
                                exceptedQuoteReplyIndex = n7 + 1;
                                List $this$indexOfFirst$iv3 = (List)builder;
                                boolean $i$f$indexOfFirst3 = false;
                                int index$iv3 = 0;
                                for (Object item$iv : $this$indexOfFirst$iv3) {
                                    SingleMessage it3 = (SingleMessage)item$iv;
                                    boolean bl5 = false;
                                    if (it3 instanceof QuoteReply) {
                                        n6 = index$iv3;
                                        break block25;
                                    }
                                    ++index$iv3;
                                }
                                n6 = quoteReplyIndex2 = -1;
                            }
                            if (quoteReplyIndex2 >= 1 && quoteReplyIndex2 != exceptedQuoteReplyIndex) {
                                SingleMessage qr = builder.get(quoteReplyIndex2);
                                builder.remove(quoteReplyIndex2);
                                builder.add(exceptedQuoteReplyIndex, qr);
                            }
                            boolean bl6 = false;
                            List $this$indexOfFirst$iv4 = (List)builder;
                            boolean $i$f$indexOfFirst4 = false;
                            index$iv2 = 0;
                            for (Object item$iv : $this$indexOfFirst$iv4) {
                                it = (SingleMessage)item$iv;
                                boolean bl7 = false;
                                if (it instanceof QuoteReply) {
                                    n5 = index$iv2;
                                    break block26;
                                }
                                ++index$iv2;
                            }
                            n5 = quoteReplyIndex = -1;
                        }
                        if (quoteReplyIndex >= 0 && quoteReplyIndex < builder.size() - 1) {
                            SingleMessage elm;
                            if (builder.get(quoteReplyIndex + 1) instanceof At) {
                                builder.remove(quoteReplyIndex + 1);
                            }
                            if (quoteReplyIndex < builder.size() - 1 && (elm = builder.get(quoteReplyIndex + 1)) instanceof PlainText && StringsKt.startsWith$default((CharSequence)((PlainText)elm).getContent(), (char)' ', (boolean)false, (int)2, null)) {
                                if (((PlainText)elm).getContent().length() == 1) {
                                    builder.remove(quoteReplyIndex + 1);
                                } else {
                                    String string = ((PlainText)elm).getContent().substring(1);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                                    builder.set(quoteReplyIndex + 1, (SingleMessage)new PlainText(string));
                                }
                            }
                        }
                        Iterable $this$any$iv = (Iterable)builder;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                SingleMessage it4 = (SingleMessage)element$iv;
                                boolean bl8 = false;
                                if (!(it4 instanceof Audio)) continue;
                                bl = true;
                                break block27;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        builder.remove((Object)MessageToElemsKt.getUNSUPPORTED_VOICE_MESSAGE_PLAIN());
                    }
                    boolean bl9 = false;
                    List $this$indexOfFirst$iv5 = (List)builder;
                    boolean $i$f$indexOfFirst5 = false;
                    int index$iv4 = 0;
                    for (Object item$iv : $this$indexOfFirst$iv5) {
                        it = (SingleMessage)item$iv;
                        boolean bl10 = false;
                        if (it instanceof VipFace) {
                            n4 = index$iv4;
                            break block28;
                        }
                        ++index$iv4;
                    }
                    n4 = vipFaceIndex = -1;
                }
                if (vipFaceIndex >= 0 && vipFaceIndex < builder.size() - 1) {
                    SingleMessage singleMessage = builder.get(vipFaceIndex);
                    Intrinsics.checkNotNull((Object)singleMessage, (String)"null cannot be cast to non-null type net.mamoe.mirai.message.data.VipFace");
                    VipFace l = (VipFace)singleMessage;
                    SingleMessage text = builder.get(vipFaceIndex + 1);
                    if (text instanceof PlainText && ((PlainText)text).getContent().length() == 4 + l.getCount() / 10 + l.getKind().getName().length()) {
                        builder.remove(vipFaceIndex + 1);
                    }
                }
                List bl9 = (List)builder;
                messageChainBuilder = builder;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    SingleMessage it = (SingleMessage)item$iv;
                    boolean bl = false;
                    if (it instanceof LongMessageInternal) {
                        n3 = index$iv;
                        break block29;
                    }
                    ++index$iv;
                }
                n3 = -1;
            }
            n2 = n3;
            ReceiveMessageTransformer.cleanupRubbishMessageElements$removeSuffixText(messageChainBuilder, n2, RichMessageProtocol.Companion.getUNSUPPORTED_MERGED_MESSAGE_PLAIN());
            $this$indexOfFirst$iv = (List)builder;
            messageChainBuilder = builder;
            $i$f$indexOfFirst = false;
            index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                SingleMessage it = (SingleMessage)item$iv;
                boolean bl = false;
                if (it instanceof PokeMessage) {
                    n = index$iv;
                    break block30;
                }
                ++index$iv;
            }
            n = -1;
        }
        n2 = n;
        ReceiveMessageTransformer.cleanupRubbishMessageElements$removeSuffixText(messageChainBuilder, n2, PokeMessageProtocol.Companion.getUNSUPPORTED_POKE_MESSAGE_PLAIN());
        this.compressContinuousPlainText(builder);
        return builder.asMessageChain();
    }

    @NotNull
    public final OnlineAudioImpl toAudio(@NotNull ImMsgBody.Ptt $this$toAudio) {
        Intrinsics.checkNotNullParameter((Object)$this$toAudio, (String)"<this>");
        return new OnlineAudioImpl(StringsKt.decodeToString((byte[])$this$toAudio.fileName), $this$toAudio.fileMd5, MiraiUtils.toLongUnsigned((int)$this$toAudio.fileSize), AudioCodec.Companion.fromId($this$toAudio.format), StringsKt.decodeToString((byte[])$this$toAudio.downPara), MiraiUtils.toLongUnsigned((int)$this$toAudio.time), $this$toAudio);
    }

    private static final void cleanupRubbishMessageElements$removeSuffixText(MessageChainBuilder builder, int index, PlainText text) {
        if (index >= 0 && index < builder.size() - 1 && Intrinsics.areEqual((Object)builder.get(index + 1), (Object)text)) {
            builder.remove(index + 1);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageSourceKind.values().length];
            try {
                nArray[MessageSourceKind.TEMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageSourceKind.GROUP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageSourceKind.FRIEND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageSourceKind.STRANGER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

