/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.contact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.AnonymousMember;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.ContactOrBot;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.Member;
import net.mamoe.mirai.contact.MemberKt;
import net.mamoe.mirai.contact.MessageTooLargeException;
import net.mamoe.mirai.contact.OtherClient;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.events.FriendMessageEvent;
import net.mamoe.mirai.event.events.FriendMessageSyncEvent;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.GroupMessageSyncEvent;
import net.mamoe.mirai.event.events.GroupTempMessageEvent;
import net.mamoe.mirai.event.events.GroupTempMessageSyncEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.event.events.OtherClientMessageEvent;
import net.mamoe.mirai.event.events.StrangerMessageEvent;
import net.mamoe.mirai.event.events.StrangerMessageSyncEvent;
import net.mamoe.mirai.internal.contact.GroupImpl;
import net.mamoe.mirai.internal.contact.UtilKt;
import net.mamoe.mirai.internal.message.LongMessageInternal;
import net.mamoe.mirai.internal.utils.TypeKt;
import net.mamoe.mirai.message.data.FileMessage;
import net.mamoe.mirai.message.data.Image;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageContent;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.message.data.MessageUtils;
import net.mamoe.mirai.message.data.SingleMessage;
import net.mamoe.mirai.utils.ExceptionCollector;
import net.mamoe.mirai.utils.MiraiLogger;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000m\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\t\u001a\f\u0010\u001c\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0000\u001a\f\u0010 \u001a\u00020!*\u00020\"H\u0000\u001a\u0014\u0010#\u001a\u00020!*\u00020$2\u0006\u0010%\u001a\u00020&H\u0000\u001a\f\u0010'\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\u0014\u0010(\u001a\u00020\u0005*\u00020&2\u0006\u0010)\u001a\u00020\u001eH\u0000\u001a \u0010*\u001a\u0004\u0018\u0001H+\"\n\b\u0000\u0010+\u0018\u0001*\u00020,*\u00020&H\u0080\b\u00a2\u0006\u0002\u0010-\u001a\u001c\u0010.\u001a\u00020\u001e*\u00020\u001f2\u0006\u0010/\u001a\u00020&2\u0006\u00100\u001a\u00020$H\u0000\u001a\f\u00101\u001a\u00020!*\u00020&H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\"\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\"\u0019\u0010\u0011\u001a\u00020\u0012*\u00020\u00138\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0019\u0010\u0016\u001a\u00020\u0012*\u00020\u00178\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\"\u0019\u0010\u0016\u001a\u00020\u0012*\u00020\u00138\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015\"\u0019\u0010\u0016\u001a\u00020\u0012*\u00020\u001a8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001b\u00a8\u00062"}, d2={"ALLOW_SENDING_FILE_MESSAGE", "", "charMappings", "", "", "", "getCharMappings", "()Ljava/util/Map;", "fileMessageWarningShown", "net/mamoe/mirai/internal/contact/UtilKt$fileMessageWarningShown$1", "Lnet/mamoe/mirai/internal/contact/UtilKt$fileMessageWarningShown$1;", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "getLogger", "()Lnet/mamoe/mirai/utils/MiraiLogger;", "logger$delegate", "Lkotlin/Lazy;", "groupCode", "", "Lnet/mamoe/mirai/contact/Group;", "getGroupCode", "(Lnet/mamoe/mirai/contact/Group;)J", "uin", "Lnet/mamoe/mirai/Bot;", "getUin", "(Lnet/mamoe/mirai/Bot;)J", "Lnet/mamoe/mirai/contact/User;", "(Lnet/mamoe/mirai/contact/User;)J", "applyCharMapping", "countImages", "", "Lnet/mamoe/mirai/message/data/MessageChain;", "logMessageReceived", "", "Lnet/mamoe/mirai/event/events/MessageEvent;", "logMessageSent", "Lnet/mamoe/mirai/contact/Contact;", "message", "Lnet/mamoe/mirai/message/data/Message;", "replaceMagicCodes", "takeContent", "length", "takeSingleContent", "T", "Lnet/mamoe/mirai/message/data/MessageContent;", "(Lnet/mamoe/mirai/message/data/Message;)Lnet/mamoe/mirai/message/data/MessageContent;", "verifyLength", "originalMessage", "target", "verifySendingValid", "mirai-core"})
public final class UtilKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
    @NotNull
    private static final fileMessageWarningShown.1 fileMessageWarningShown = new ExceptionCollector(){

        protected void addSuppressed(@NotNull Throwable receiver, @NotNull Throwable e) {
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }
    };
    private static final boolean ALLOW_SENDING_FILE_MESSAGE = MiraiUtils.systemProp((String)"mirai.message.allow.sending.file.message", (boolean)false);
    @NotNull
    private static final Map<Character, String> charMappings;

    public static final long getUin(@NotNull Group $this$uin) {
        Intrinsics.checkNotNullParameter((Object)$this$uin, (String)"<this>");
        boolean $i$f$getUin = false;
        Group $this$cast$iv = $this$uin;
        boolean $i$f$cast = false;
        boolean bl = false;
        return ((GroupImpl)$this$cast$iv).getUin();
    }

    public static final long getGroupCode(@NotNull Group $this$groupCode) {
        Intrinsics.checkNotNullParameter((Object)$this$groupCode, (String)"<this>");
        boolean $i$f$getGroupCode = false;
        return $this$groupCode.getId();
    }

    public static final long getUin(@NotNull User $this$uin) {
        Intrinsics.checkNotNullParameter((Object)$this$uin, (String)"<this>");
        boolean $i$f$getUin = false;
        return $this$uin.getId();
    }

    public static final long getUin(@NotNull Bot $this$uin) {
        Intrinsics.checkNotNullParameter((Object)$this$uin, (String)"<this>");
        boolean $i$f$getUin = false;
        return $this$uin.getId();
    }

    public static final void logMessageSent(@NotNull Contact $this$logMessageSent, @NotNull Message message2) {
        Intrinsics.checkNotNullParameter((Object)$this$logMessageSent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (!(message2 instanceof LongMessageInternal)) {
            $this$logMessageSent.getBot().getLogger().verbose(UtilKt.replaceMagicCodes($this$logMessageSent + " <- " + message2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int countImages(@NotNull MessageChain $this$countImages) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$countImages, (String)"<this>");
        Iterable $this$count$iv = (Iterable)$this$countImages;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                SingleMessage it = (SingleMessage)element$iv;
                boolean bl = false;
                if (!(it instanceof Image)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    private static final MiraiLogger getLogger() {
        Lazy lazy = logger$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (MiraiLogger)lazy.getValue();
    }

    public static final void verifySendingValid(@NotNull Message $this$verifySendingValid) {
        Intrinsics.checkNotNullParameter((Object)$this$verifySendingValid, (String)"<this>");
        Message message2 = $this$verifySendingValid;
        if (message2 instanceof MessageChain) {
            Iterable $this$forEach$iv = (Iterable)$this$verifySendingValid;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SingleMessage it = (SingleMessage)element$iv;
                boolean bl = false;
                UtilKt.verifySendingValid((Message)it);
            }
        } else if (message2 instanceof FileMessage && !ALLOW_SENDING_FILE_MESSAGE) {
            Exception e = new Exception("This stacktrace might help you find your code causing this problem. It is shown once for each distinct line.");
            String log = "Sending FileMessage manually is error-prone and is planned to be prohibited in the future. Please use AbsoluteFolder.uploadNewFile (recommended) or RemoteFile.uploadAndSend instead (deprecated).You can add JVM argument '-Dmirai.message.allow.sending.file.message=true' to ignore this warning, however, your code might not work in the future.";
            if (fileMessageWarningShown.collect(e)) {
                UtilKt.getLogger().warning(log, (Throwable)e);
            } else {
                UtilKt.getLogger().warning(log);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int verifyLength(@NotNull MessageChain $this$verifyLength, @NotNull Message originalMessage, @NotNull Contact target) {
        Intrinsics.checkNotNullParameter((Object)$this$verifyLength, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)originalMessage, (String)"originalMessage");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        MessageChain chain2 = $this$verifyLength;
        int length2 = TypeKt.estimateLength($this$verifyLength, (ContactOrBot)target, 15001);
        if (length2 > 15000 || UtilKt.countImages($this$verifyLength) > 50) {
            void rsp;
            String string = CollectionsKt.joinToString$default((Iterable)((Iterable)chain2), (CharSequence)"", null, null, (int)10, null, null, (int)54, null);
            boolean bl = false;
            boolean bl2 = false;
            String string2 = string;
            StringBuilder stringBuilder = new StringBuilder().append("message(");
            Message message2 = (Message)$this$verifyLength;
            Message message3 = originalMessage;
            Contact contact = target;
            boolean bl3 = false;
            void var14_14 = rsp.length() > 100 ? Intrinsics.stringPlus((String)StringsKt.take((String)rsp, (int)100), (Object)"...") : rsp;
            String string3 = stringBuilder.append((String)var14_14).append(") is too large. Allow up to 50 images or 5000 chars").toString();
            Message message4 = message2;
            Message message5 = message3;
            Contact contact2 = contact;
            throw new MessageTooLargeException(contact2, message5, message4, string3);
        }
        return length2;
    }

    public static final void logMessageReceived(@NotNull MessageEvent $this$logMessageReceived) {
        Intrinsics.checkNotNullParameter((Object)$this$logMessageReceived, (String)"<this>");
        MiraiLogger $this$verbose$iv = $this$logMessageReceived.getBot().getLogger();
        boolean $i$f$verbose = false;
        if ($this$verbose$iv.isVerboseEnabled()) {
            MiraiLogger miraiLogger = $this$verbose$iv;
            boolean bl = false;
            MessageEvent messageEvent = $this$logMessageReceived;
            String string = UtilKt.replaceMagicCodes(messageEvent instanceof GroupMessageEvent ? UtilKt.logMessageReceived$renderGroupMessage(((GroupMessageEvent)$this$logMessageReceived).getGroup(), $this$logMessageReceived.getSenderName(), ((GroupMessageEvent)$this$logMessageReceived).getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof GroupMessageSyncEvent ? UtilKt.logMessageReceived$renderGroupMessageSync(((GroupMessageSyncEvent)$this$logMessageReceived).getGroup(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof GroupTempMessageEvent ? UtilKt.logMessageReceived$renderGroupTempMessage(((GroupTempMessageEvent)$this$logMessageReceived).getGroup(), $this$logMessageReceived.getSenderName(), (Member)((GroupTempMessageEvent)$this$logMessageReceived).getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof GroupTempMessageSyncEvent ? UtilKt.logMessageReceived$renderGroupTempMessageSync(((GroupTempMessageSyncEvent)$this$logMessageReceived).getGroup(), MemberKt.getNameCardOrNick((Member)((Member)((GroupTempMessageSyncEvent)$this$logMessageReceived).getSubject())), (Member)((GroupTempMessageSyncEvent)$this$logMessageReceived).getSubject(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof StrangerMessageEvent ? UtilKt.logMessageReceived$renderStrangerMessage($this$logMessageReceived.getSenderName(), (User)((StrangerMessageEvent)$this$logMessageReceived).getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof StrangerMessageSyncEvent ? UtilKt.logMessageReceived$renderStrangerMessageSync(((StrangerMessageSyncEvent)$this$logMessageReceived).getSubject().getNick(), (User)((StrangerMessageSyncEvent)$this$logMessageReceived).getSubject(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof FriendMessageEvent ? UtilKt.logMessageReceived$renderFriendMessage((User)((FriendMessageEvent)$this$logMessageReceived).getSender(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof FriendMessageSyncEvent ? UtilKt.logMessageReceived$renderFriendMessageSync((User)((FriendMessageSyncEvent)$this$logMessageReceived).getSubject(), $this$logMessageReceived.getMessage()) : (messageEvent instanceof OtherClientMessageEvent ? UtilKt.logMessageReceived$renderOtherClientMessage($this$logMessageReceived, ((OtherClientMessageEvent)$this$logMessageReceived).getClient()) : $this$logMessageReceived.toString())))))))));
            miraiLogger.verbose(string);
        }
    }

    @NotNull
    public static final Map<Character, String> getCharMappings() {
        return charMappings;
    }

    @NotNull
    public static final String applyCharMapping(@NotNull String $this$applyCharMapping) {
        Intrinsics.checkNotNullParameter((Object)$this$applyCharMapping, (String)"<this>");
        int n = $this$applyCharMapping.length();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$applyCharMapping_u24lambda_u2d6 = stringBuilder;
        boolean bl5 = false;
        CharSequence $this$forEach$iv = $this$applyCharMapping;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        for (int j = 0; j < charSequence.length(); ++j) {
            char element$iv;
            char c = element$iv = charSequence.charAt(j);
            boolean bl6 = false;
            String string = UtilKt.getCharMappings().get(Character.valueOf(c));
            $this$applyCharMapping_u24lambda_u2d6.append(string == null ? Character.valueOf(c) : string);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String replaceMagicCodes(@NotNull String $this$replaceMagicCodes) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceMagicCodes, (String)"<this>");
        return UtilKt.applyCharMapping($this$replaceMagicCodes);
    }

    @NotNull
    public static final String takeContent(@NotNull Message $this$takeContent, int length2) {
        Intrinsics.checkNotNullParameter((Object)$this$takeContent, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)((Iterable)MessageUtils.newChain((Message)$this$takeContent)), (CharSequence)"", null, null, (int)length2, null, (Function1)takeContent.1.INSTANCE, (int)22, null);
    }

    public static final /* synthetic */ <T extends MessageContent> T takeSingleContent(Message $this$takeSingleContent) {
        MessageContent messageContent;
        Intrinsics.checkNotNullParameter((Object)$this$takeSingleContent, (String)"<this>");
        boolean $i$f$takeSingleContent = false;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        MessageContent messageContent2 = (MessageContent)$this$takeSingleContent;
        if (messageContent2 == null) {
            MessageContent messageContent3;
            MessageChain messageChain;
            Message $this$castOrNull$iv = $this$takeSingleContent;
            boolean $i$f$castOrNull = false;
            boolean bl = false;
            Message message2 = $this$castOrNull$iv;
            if (!(message2 instanceof MessageChain)) {
                message2 = null;
            }
            if ((messageChain = (MessageChain)message2) == null) {
                messageContent3 = null;
            } else {
                Object v2;
                block6: {
                    MessageChain $this$findIsInstance$iv = messageChain;
                    boolean $i$f$findIsInstance = false;
                    Iterable iterable = (Iterable)$this$findIsInstance$iv;
                    boolean bl2 = false;
                    Iterable iterable2 = iterable;
                    boolean bl3 = false;
                    for (Object t : iterable2) {
                        SingleMessage it$iv = (SingleMessage)t;
                        boolean bl4 = false;
                        Intrinsics.reifiedOperationMarker((int)3, (String)"T?");
                        if (!(it$iv instanceof SingleMessage)) continue;
                        v2 = t;
                        break block6;
                    }
                    v2 = null;
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                messageContent3 = (MessageContent)((SingleMessage)v2);
            }
            messageContent = messageContent3;
        } else {
            messageContent = messageContent2;
        }
        return (T)messageContent;
    }

    /*
     * WARNING - void declaration
     */
    private static final String logMessageReceived$renderMessage(MessageChain message2) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = (Iterable)message2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            SingleMessage it = (SingleMessage)element$iv$iv;
            boolean bl = false;
            if (it instanceof MessageSource) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String logMessageReceived$renderGroupMessage(Group group, String senderName, Member sender2, MessageChain message2) {
        String displayId = sender2 instanceof AnonymousMember ? "\u533f\u540d" : String.valueOf(sender2.getId());
        return '[' + group.getName() + '(' + group.getId() + ")] " + senderName + '(' + displayId + ") -> " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderGroupMessageSync(Group group, MessageChain message2) {
        return '[' + group.getName() + '(' + group.getId() + ")][SYNC] <- " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderGroupTempMessage(Group group, String senderName, Member sender2, MessageChain message2) {
        return '[' + group.getName() + '(' + group.getId() + ")] " + senderName + "(Temp " + sender2.getId() + ") -> " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderGroupTempMessageSync(Group group, String subjectName, Member subject2, MessageChain message2) {
        return '[' + group.getName() + '(' + group.getId() + ")] " + subjectName + "(Temp " + subject2.getId() + ")[SYNC] <- " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderStrangerMessage(String senderName, User sender2, MessageChain message2) {
        return '[' + senderName + "(Stranger " + sender2.getId() + ") -> " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderStrangerMessageSync(String subjectName, User subject2, MessageChain message2) {
        return '[' + subjectName + "(Stranger " + subject2.getId() + ")[SYNC] <- " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderFriendMessage(User sender2, MessageChain message2) {
        return sender2.getNick() + '(' + sender2.getId() + ") -> " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderFriendMessageSync(User subject2, MessageChain message2) {
        return subject2.getNick() + '(' + subject2.getId() + ")[SYNC] <- " + UtilKt.logMessageReceived$renderMessage(message2);
    }

    private static final String logMessageReceived$renderOtherClientMessage(MessageEvent $this_logMessageReceived, OtherClient client2) {
        OtherClient $this$platform$iv = client2;
        boolean $i$f$getPlatform = false;
        return $this$platform$iv.getInfo().getPlatform() + " -> " + UtilKt.logMessageReceived$renderMessage($this_logMessageReceived.getMessage());
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('\n'), (Object)"\\n"), TuplesKt.to((Object)Character.valueOf('\r'), (Object)""), TuplesKt.to((Object)Character.valueOf('\u202e'), (Object)"<RTL>"), TuplesKt.to((Object)Character.valueOf('\u202d'), (Object)"<LTR>")};
        charMappings = MapsKt.mapOf((Pair[])pairArray);
    }
}

