/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.components;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.internal.AbstractBot;
import net.mamoe.mirai.internal.contact.UtilKt;
import net.mamoe.mirai.internal.network.MultiPacket;
import net.mamoe.mirai.internal.network.Packet;
import net.mamoe.mirai.internal.network.ParseErrorPacket;
import net.mamoe.mirai.internal.network.components.PacketLoggingStrategy;
import net.mamoe.mirai.internal.network.components.PacketLoggingStrategyImpl;
import net.mamoe.mirai.internal.network.protocol.packet.IncomingPacket;
import net.mamoe.mirai.internal.network.protocol.packet.OutgoingPacket;
import net.mamoe.mirai.utils.Either;
import net.mamoe.mirai.utils.MiraiLogger;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/mamoe/mirai/internal/network/components/PacketLoggingStrategyImpl;", "Lnet/mamoe/mirai/internal/network/components/PacketLoggingStrategy;", "bot", "Lnet/mamoe/mirai/internal/AbstractBot;", "blacklist", "", "", "(Lnet/mamoe/mirai/internal/AbstractBot;Ljava/util/Set;)V", "logReceived", "", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "incomingPacket", "Lnet/mamoe/mirai/internal/network/protocol/packet/IncomingPacket;", "logReceivedImpl", "packet", "Lnet/mamoe/mirai/internal/network/Packet;", "logSent", "outgoingPacket", "Lnet/mamoe/mirai/internal/network/protocol/packet/OutgoingPacket;", "Companion", "mirai-core"})
public final class PacketLoggingStrategyImpl
implements PacketLoggingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractBot bot;
    @NotNull
    private final Set<String> blacklist;
    @NotNull
    private static final Lazy<Set<String>> DEFAULT_BLACKLIST$delegate = LazyKt.lazy((Function0)Companion.DEFAULT_BLACKLIST.2.INSTANCE);
    @JvmField
    public static boolean SHOW_PACKET_DETAILS = MiraiUtils.systemProp((String)"mirai.network.show.packet.details", (boolean)false);

    public PacketLoggingStrategyImpl(@NotNull AbstractBot bot, @NotNull Set<String> blacklist) {
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Intrinsics.checkNotNullParameter(blacklist, (String)"blacklist");
        this.bot = bot;
        this.blacklist = blacklist;
    }

    public /* synthetic */ PacketLoggingStrategyImpl(AbstractBot abstractBot, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = Companion.getDefaultBlacklist();
        }
        this(abstractBot, set);
    }

    @Override
    public void logSent(@NotNull MiraiLogger logger2, @NotNull OutgoingPacket outgoingPacket) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)outgoingPacket, (String)"outgoingPacket");
        if (this.blacklist.contains(outgoingPacket.getCommandName())) {
            return;
        }
        MiraiLogger $this$verbose$iv = logger2;
        boolean $i$f$verbose = false;
        if ($this$verbose$iv.isVerboseEnabled()) {
            MiraiLogger miraiLogger = $this$verbose$iv;
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Send: ", (Object)outgoingPacket.getDisplayName());
            miraiLogger.verbose(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logReceived(@NotNull MiraiLogger logger2, @NotNull IncomingPacket incomingPacket) {
        block9: {
            Unit unit;
            Throwable throwable;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)incomingPacket, (String)"incomingPacket");
            Either.Companion companion = Either.Companion;
            Object $this$fold_u2d1gtWUZ4$iv = incomingPacket.getResult-AtAycW8();
            boolean bl = false;
            void var6_6 = this_$iv;
            Object $this$leftOrNull$iv$iv = $this$fold_u2d1gtWUZ4$iv;
            boolean bl2 = false;
            Object $this$safeCast$iv$iv$iv = $this$leftOrNull$iv$iv;
            boolean $i$f$safeCast = false;
            boolean bl3 = false;
            Object object = $this$safeCast$iv$iv$iv;
            if (!(object instanceof Throwable)) {
                object = null;
            }
            if ((throwable = (Throwable)object) == null) {
                unit = null;
            } else {
                Throwable this_$iv$iv = throwable;
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable it$iv = this_$iv$iv;
                boolean bl6 = false;
                Throwable e = it$iv;
                boolean bl7 = false;
                if (e instanceof CancellationException) {
                    return;
                }
                logger2.error("Exception in decoding packet.", e);
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
            if (unit2 != null) break block9;
            Object $this$cast$iv$iv = $this$fold_u2d1gtWUZ4$iv;
            boolean $i$f$cast = false;
            boolean bl8 = false;
            throwable = (Packet)$this$cast$iv$iv;
            boolean bl9 = false;
            bl8 = false;
            Throwable packet = throwable;
            boolean bl10 = false;
            Object object2 = packet;
            if (object2 == null) {
                return;
            }
            if (!this.bot.getLogger().isEnabled() && !logger2.isEnabled()) {
                return;
            }
            if (packet instanceof MultiPacket) {
                if (((MultiPacket)((Object)packet)).isMeaningful()) {
                    this.logReceivedImpl((Packet)packet, incomingPacket, logger2);
                }
                Iterator<Packet> iterator = ((MultiPacket)((Object)packet)).children();
                boolean bl11 = false;
                object2 = iterator;
                while (object2.hasNext()) {
                    Packet d = (Packet)object2.next();
                    this.logReceivedImpl(d, incomingPacket, logger2);
                }
            }
            this.logReceivedImpl((Packet)packet, incomingPacket, logger2);
        }
    }

    private final void logReceivedImpl(Packet packet, IncomingPacket incomingPacket, MiraiLogger logger2) {
        Packet packet2 = packet;
        if (packet2 instanceof ParseErrorPacket) {
            ((ParseErrorPacket)packet).getDirection().getLogger(this.bot).error("Exception on parsing packet.", ((ParseErrorPacket)packet).getError());
        } else if (packet2 instanceof MessageEvent) {
            UtilKt.logMessageReceived((MessageEvent)packet);
        } else if (!(packet2 instanceof Packet.NoLog)) {
            if (this.blacklist.contains(incomingPacket.getCommandName())) {
                return;
            }
            if (SHOW_PACKET_DETAILS) {
                MiraiLogger $this$verbose$iv = logger2;
                boolean $i$f$verbose = false;
                if ($this$verbose$iv.isVerboseEnabled()) {
                    MiraiLogger miraiLogger = $this$verbose$iv;
                    boolean bl = false;
                    String string = UtilKt.replaceMagicCodes("Recv: " + incomingPacket.getCommandName() + ' ' + Either.toString-impl((Object)incomingPacket.getResult-AtAycW8()));
                    miraiLogger.verbose(string);
                }
            } else {
                MiraiLogger $this$verbose$iv = logger2;
                boolean $i$f$verbose = false;
                if ($this$verbose$iv.isVerboseEnabled()) {
                    MiraiLogger miraiLogger = $this$verbose$iv;
                    boolean bl = false;
                    String string = UtilKt.replaceMagicCodes(Intrinsics.stringPlus((String)"Recv: ", (Object)incomingPacket.getCommandName()));
                    miraiLogger.verbose(string);
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/mamoe/mirai/internal/network/components/PacketLoggingStrategyImpl$Companion;", "", "()V", "DEFAULT_BLACKLIST", "", "", "getDEFAULT_BLACKLIST", "()Ljava/util/Set;", "DEFAULT_BLACKLIST$delegate", "Lkotlin/Lazy;", "SHOW_PACKET_DETAILS", "", "getDefaultBlacklist", "mirai-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getDefaultBlacklist() {
            if (MiraiUtils.systemProp((String)"mirai.network.show.verbose.packets", (boolean)false)) {
                return SetsKt.emptySet();
            }
            return this.getDEFAULT_BLACKLIST();
        }

        private final Set<String> getDEFAULT_BLACKLIST() {
            Lazy lazy = DEFAULT_BLACKLIST$delegate;
            Object var2_2 = null;
            boolean bl = false;
            return (Set)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

