/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils.crypto;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.utils.crypto.ECDH;
import net.mamoe.mirai.internal.utils.crypto.ECDHKeyPair;
import net.mamoe.mirai.internal.utils.crypto.ECDHKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000bR\u0018\u0010\u0011\u001a\u00060\u0012j\u0002`\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u00060\u0005j\u0002`\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lnet/mamoe/mirai/internal/utils/crypto/ECDHKeyPairImpl;", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHKeyPair;", "delegate", "Ljava/security/KeyPair;", "initialPublicKey", "Ljava/security/PublicKey;", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHPublicKey;", "(Ljava/security/KeyPair;Ljava/security/PublicKey;)V", "maskedPublicKey", "", "getMaskedPublicKey", "()[B", "maskedPublicKey$delegate", "Lkotlin/Lazy;", "maskedShareKey", "getMaskedShareKey", "maskedShareKey$delegate", "privateKey", "Ljava/security/PrivateKey;", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHPrivateKey;", "getPrivateKey", "()Ljava/security/PrivateKey;", "publicKey", "getPublicKey", "()Ljava/security/PublicKey;", "mirai-core"})
public final class ECDHKeyPairImpl
implements ECDHKeyPair {
    @NotNull
    private final KeyPair delegate;
    @NotNull
    private final Lazy maskedShareKey$delegate;
    @NotNull
    private final Lazy maskedPublicKey$delegate;

    public ECDHKeyPairImpl(@NotNull KeyPair delegate, @NotNull PublicKey initialPublicKey) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)initialPublicKey, (String)"initialPublicKey");
        this.delegate = delegate;
        this.maskedShareKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>(this, initialPublicKey){
            final /* synthetic */ ECDHKeyPairImpl this$0;
            final /* synthetic */ PublicKey $initialPublicKey;
            {
                this.this$0 = $receiver;
                this.$initialPublicKey = $initialPublicKey;
                super(0);
            }

            @NotNull
            public final byte[] invoke() {
                return ECDH.Companion.calculateShareKey(this.this$0.getPrivateKey(), this.$initialPublicKey);
            }
        }));
        this.maskedPublicKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>(this){
            final /* synthetic */ ECDHKeyPairImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final byte[] invoke() {
                byte[] byArray = this.this$0.getPublicKey().getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"publicKey.encoded");
                int n = 26;
                int n2 = 91;
                boolean bl = false;
                return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            }
        }));
    }

    public /* synthetic */ ECDHKeyPairImpl(KeyPair keyPair, PublicKey publicKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            publicKey = ECDHKt.getDefaultInitialPublicKey().getKey$mirai_core();
        }
        this(keyPair, publicKey);
    }

    @Override
    @NotNull
    public PrivateKey getPrivateKey() {
        PrivateKey privateKey = this.delegate.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"delegate.private");
        return privateKey;
    }

    @Override
    @NotNull
    public PublicKey getPublicKey() {
        PublicKey publicKey = this.delegate.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"delegate.public");
        return publicKey;
    }

    @Override
    @NotNull
    public byte[] getMaskedShareKey() {
        Lazy lazy = this.maskedShareKey$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (byte[])lazy.getValue();
    }

    @Override
    @NotNull
    public byte[] getMaskedPublicKey() {
        Lazy lazy = this.maskedPublicKey$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (byte[])lazy.getValue();
    }
}

