/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message;

public class BinaryUtil {
    public static int readInt(byte[] bytes, int offset) {
        return (bytes[offset] << 24) + ((bytes[offset + 1] & 0xFF) << 16) + ((bytes[offset + 2] & 0xFF) << 8) + (bytes[offset + 3] & 0xFF);
    }

    public static int[] readInts(byte[] bytes) {
        if ((bytes.length & 3) != 0) {
            throw new IllegalArgumentException("Number of bytes must be a multiple of 4.");
        }
        int[] ints = new int[bytes.length >> 2];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = BinaryUtil.readInt(bytes, i << 2);
        }
        return ints;
    }

    public static byte[] writeInt(int value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value >>> 24);
        bytes[offset + 1] = (byte)(value >>> 16);
        bytes[offset + 2] = (byte)(value >>> 8);
        bytes[offset + 3] = (byte)value;
        return bytes;
    }

    public static byte[] writeLong(long value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value >>> 56);
        bytes[offset + 1] = (byte)(value >>> 48);
        bytes[offset + 2] = (byte)(value >>> 40);
        bytes[offset + 3] = (byte)(value >>> 32);
        bytes[offset + 4] = (byte)(value >>> 24);
        bytes[offset + 5] = (byte)(value >>> 16);
        bytes[offset + 6] = (byte)(value >>> 8);
        bytes[offset + 7] = (byte)value;
        return bytes;
    }

    public static long readLong(byte[] bytes, int offset) {
        return ((long)bytes[offset] << 56) + (((long)bytes[offset + 1] & 0xFFL) << 48) + (((long)bytes[offset + 2] & 0xFFL) << 40) + (((long)bytes[offset + 3] & 0xFFL) << 32) + (((long)bytes[offset + 4] & 0xFFL) << 24) + (((long)bytes[offset + 5] & 0xFFL) << 16) + (((long)bytes[offset + 6] & 0xFFL) << 8) + ((long)bytes[offset + 7] & 0xFFL);
    }
}

