/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class Hashing {
    private static MessageDigest getSHA1MessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("All java implementations should be able to create SHA-1 digests", e);
        }
    }

    private static MessageDigest getSHA256MessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("All java implementations should be able to create SHA-256 digests", e);
        }
    }

    public static int hashcode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static int identityHash(int h) {
        return (h << 1) - (h << 8);
    }

    public static int juHashMapHash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public static int wangJenkinsHash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    public static final int murmur3BaseStep(int h) {
        h ^= h >>> 16;
        h *= -2048144789;
        h ^= h >>> 13;
        return (h *= -1028477387) >>> 16;
    }

    public static byte[] SHA1(byte[] bytes) {
        Objects.requireNonNull(bytes, "bytes is null");
        MessageDigest md = Hashing.getSHA1MessageDigest();
        return md.digest(bytes);
    }

    public static byte[] SHA256(byte[] bytes) {
        Objects.requireNonNull(bytes, "bytes is null");
        MessageDigest md = Hashing.getSHA256MessageDigest();
        return md.digest(bytes);
    }
}

