/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageReader;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.ValueSerializer;

public class MessageHelper {
    public static double checkDouble(double value) {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException("Cannot write double value " + value);
        }
        return value;
    }

    public static float checkFloat(float value) {
        if (!Float.isFinite(value)) {
            throw new IllegalArgumentException("Cannot write float value " + value);
        }
        return value;
    }

    private static <T> T convert(T value) {
        return (T)(value instanceof Message ? ((Message)value).immutable() : value);
    }

    public static <T extends Message> T immutable(T t) {
        return (T)(t == null ? null : t.immutable());
    }

    public static <T> List<T> immutableCopy(List<? extends T> list) {
        ArrayList<T> l = new ArrayList<T>(list.size());
        for (T t : list) {
            l.add(MessageHelper.convert(t));
        }
        return Collections.unmodifiableList(l);
    }

    public static <K, V> Map<K, V> immutableCopy(Map<? extends K, ? extends V> map) {
        LinkedHashMap<K, V> l = new LinkedHashMap<K, V>(map.size());
        for (Map.Entry<K, V> t : map.entrySet()) {
            l.put(MessageHelper.convert(t.getKey()), MessageHelper.convert(t.getValue()));
        }
        return Collections.unmodifiableMap(l);
    }

    public static <T> Set<T> immutableCopy(Set<? extends T> list) {
        LinkedHashSet<T> l = new LinkedHashSet<T>(list.size());
        for (T t : list) {
            l.add(MessageHelper.convert(t));
        }
        return Collections.unmodifiableSet(l);
    }

    public static <T> List<T> readList(int tag, String name, MessageReader reader, ValueSerializer<T> parser) throws IOException {
        Objects.requireNonNull(reader, "reader is null");
        return reader.readList(tag, name, parser);
    }

    public static <K, V> Map<K, V> readMap(int tag, String name, MessageReader reader, ValueSerializer<K> keyParser, ValueSerializer<V> valueParser) throws IOException {
        return reader.readMap(tag, name, keyParser, valueParser);
    }

    public static <T> Set<T> readSet(int tag, String name, MessageReader reader, ValueSerializer<T> parser) throws IOException {
        return reader.readSet(tag, name, parser);
    }

    public static <T extends Message> MessageSerializer<T> getSerializer(T message) {
        return MessageHelper.getSerializer(message, message.getClass());
    }

    private static <T extends Message> MessageSerializer<T> getSerializer(T message, Class<?> messageType) {
        try {
            Field field = messageType.getField("SERIALIZER");
            return (MessageSerializer)field.get(null);
        }
        catch (NoSuchFieldException e) {
            if (message != null) {
                try {
                    Method m = messageType.getMethod("serializer", new Class[0]);
                    return (MessageSerializer)m.invoke(message, new Object[0]);
                }
                catch (ReflectiveOperationException e1) {
                    throw new RuntimeException("All messages must have a public static final String NAME field or a name() method, offending class = " + messageType.getCanonicalName(), e1);
                }
            }
            throw new RuntimeException("All messages must have a public static final " + MessageSerializer.class.getSimpleName() + " SERIALIZER field, offending class = " + messageType.getCanonicalName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getName(Message message) {
        return MessageHelper.getName(message, message.getClass());
    }

    public static String getName(Class<? extends Message> messageType) {
        return MessageHelper.getName(null, messageType);
    }

    private static String getName(Message message, Class<? extends Message> messageType) {
        Objects.requireNonNull(messageType, "message type is null");
        try {
            Field field = messageType.getField("NAME");
            return (String)field.get(null);
        }
        catch (NoSuchFieldException e) {
            if (message != null) {
                try {
                    Method m = messageType.getMethod("name", new Class[0]);
                    return (String)m.invoke((Object)message, new Object[0]);
                }
                catch (ReflectiveOperationException e1) {
                    throw new RuntimeException("All messages must have a public static final String NAME field or a name() method, offending class = " + messageType.getCanonicalName(), e1);
                }
            }
            throw new RuntimeException("All messages must have a public static final String NAME field, offending class = " + messageType.getCanonicalName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

