/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.maritimecloud.internal.message.MessageHelper;
import net.maritimecloud.internal.message.binary.BinaryUtils;
import net.maritimecloud.message.MessageEnum;
import net.maritimecloud.message.MessageFormatType;
import net.maritimecloud.message.ValueWriter;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public abstract class AbstractBinaryValueWriter
implements ValueWriter {
    @Override
    public final void writeBoolean(Boolean value) throws IOException {
        this.writeInt(value != false ? 1 : 0);
    }

    @Override
    public final void writeDouble(Double value) throws IOException {
        this.writeInt64(Double.doubleToLongBits(MessageHelper.checkDouble(value)));
    }

    @Override
    public final void writeEnum(MessageEnum serializable) throws IOException {
        this.writeInt(serializable.getValue());
    }

    @Override
    public final MessageFormatType getFormatType() {
        return MessageFormatType.MACHINE_READABLE;
    }

    @Override
    public void writeDecimal(BigDecimal value) throws IOException {
        this.writeBinary(BinaryUtils.encodeBigDecimal(value));
    }

    @Override
    public final void writePositionTime(PositionTime value) throws IOException {
        this.writeBinary(value.toBinary());
    }

    @Override
    public final void writePosition(Position value) throws IOException {
        this.writeBinary(value.toBinary());
    }

    @Override
    public final void writeFloat(Float value) throws IOException {
        this.writeInt(Float.floatToIntBits(MessageHelper.checkFloat(value.floatValue())));
    }

    @Override
    public void writeVarInt(BigInteger value) throws IOException {
        this.writeBinary(BinaryUtils.encodeBigInteger(value));
    }

    @Override
    public final void writeText(String value) throws IOException {
        this.writeBinary(Binary.copyFromUtf8(value));
    }
}

