/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary;

import java.io.IOException;
import java.io.InputStream;
import net.maritimecloud.internal.message.binary.Exceptions;

public class ReaderUtils {
    static int readRawVarint32(InputStream input) throws IOException {
        int firstByte = input.read();
        if (firstByte == -1) {
            throw Exceptions.truncatedMessage();
        }
        return ReaderUtils.readRawVarint32(firstByte, input);
    }

    public static int readRawVarint32(int firstByte, InputStream input) throws IOException {
        int b;
        int offset;
        if ((firstByte & 0x80) == 0) {
            return firstByte;
        }
        int result = firstByte & 0x7F;
        for (offset = 7; offset < 32; offset += 7) {
            b = input.read();
            if (b == -1) {
                throw Exceptions.truncatedMessage();
            }
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        while (offset < 64) {
            b = input.read();
            if (b == -1) {
                throw Exceptions.truncatedMessage();
            }
            if ((b & 0x80) == 0) {
                return result;
            }
            offset += 7;
        }
        throw Exceptions.malformedVarint();
    }
}

