/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary.compact;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.maritimecloud.internal.message.binary.compact.Types;
import net.maritimecloud.util.Binary;

public class BinaryInputStream
extends Types {
    int lastWireType;
    int fieldNumber;
    boolean consumed = true;
    final InputStream is;

    public BinaryInputStream(Binary bytes) {
        this(bytes.toByteArray());
    }

    public BinaryInputStream(byte[] bytes) {
        this(new ByteArrayInputStream(bytes));
    }

    public BinaryInputStream(InputStream is) {
        this.is = Objects.requireNonNull(is);
    }

    public int readInt() {
        return 0;
    }

    int getWireType() throws IOException {
        if (this.consumed) {
            this.readHeader();
        }
        return this.lastWireType;
    }

    int getFieldId() throws IOException {
        if (this.consumed) {
            this.readHeader();
        }
        return this.fieldNumber;
    }

    byte[] read(int bytes) throws IOException {
        byte[] b = new byte[bytes];
        for (int i = 0; i < bytes; ++i) {
            b[i] = this.readRawByte();
        }
        this.consumed = true;
        return b;
    }

    void readHeader() throws IOException {
        byte b = this.readRawByte();
        this.lastWireType = Types.getWireType(b);
        this.fieldNumber = (b & 0xFFFFFFF0) == 0 ? this.readInt() : Types.getTagFieldNumber(b);
        this.consumed = false;
    }

    int readVarint32() throws IOException {
        return (int)this.readRawVarint64SlowPath();
    }

    long readRawVarint64SlowPath() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            this.consumed = true;
            return result;
        }
        throw new RuntimeException();
    }

    private byte readRawByte() throws IOException {
        return (byte)this.is.read();
    }

    public int read08Bits() throws IOException {
        int result = this.readRawByte() & 0xFF;
        this.consumed = true;
        return result;
    }

    public int read16Bits() throws IOException {
        int result = (this.readRawByte() & 0xFF) << 8 << 16 >> 16;
        this.consumed = true;
        return result |= this.readRawByte() & 0xFF;
    }

    public int read32Bits() throws IOException {
        int result = (this.readRawByte() & 0xFF) << 24;
        result |= (this.readRawByte() & 0xFF) << 16;
        result |= (this.readRawByte() & 0xFF) << 8;
        this.consumed = true;
        return result |= this.readRawByte() & 0xFF;
    }

    public int read64Bits() throws IOException {
        int result = this.readRawByte() << 24;
        result = this.readRawByte() << 16;
        result = this.readRawByte() << 8;
        return result + this.readRawByte();
    }
}

