/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary.compact;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.maritimecloud.internal.message.binary.AbstractBinaryMessageWriter;
import net.maritimecloud.internal.message.binary.compact.BinaryOutputStream;
import net.maritimecloud.internal.message.binary.compact.BinaryValueWriter;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.message.ValueWriter;

public class BinaryMessageWriter
extends AbstractBinaryMessageWriter {
    final BinaryOutputStream os;

    BinaryMessageWriter(BinaryOutputStream bos) {
        this.os = Objects.requireNonNull(bos);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    protected void writeBinary(int tag, byte[] bin) throws IOException {
        this.os.writeBytes(tag, bin);
    }

    @Override
    public void writeBoolean(int tag, String name, Boolean value) throws IOException {
        if (value != null) {
            this.os.writeBoolean(tag, name, value);
        }
    }

    @Override
    protected void writeDecimal0(int tag, BigDecimal bd) throws IOException {
        this.os.encodeAndWriteInteger(tag, bd.scale());
        this.os.writeBytes(bd.unscaledValue().toByteArray());
    }

    @Override
    protected void writeInt0(int tag, int value) throws IOException {
        this.os.encodeAndWriteInteger(tag, value);
    }

    @Override
    protected void writeInt640(int tag, long value) throws IOException {
        this.os.encodeAndWriteInteger(tag, (int)value);
    }

    @Override
    protected <K, V> void writeMap0(int tag, Map<K, V> map, ValueSerializer<K> keySerializer, ValueSerializer<V> valueSerializer) throws IOException {
        byte[] bytes = BinaryValueWriter.writeWithWriter(w -> {
            for (Map.Entry e : map.entrySet()) {
                keySerializer.write(e.getKey(), (ValueWriter)w);
                valueSerializer.write(e.getValue(), (ValueWriter)w);
            }
        });
        this.os.writeBytes(tag, bytes);
    }

    @Override
    protected <T extends Message> void writeMessage0(int tag, T message, MessageSerializer<T> serializer) throws IOException {
        byte[] bytes = BinaryValueWriter.writeWithWriter(w -> serializer.write(message, (ValueWriter)w));
        this.os.writeBytes(tag, bytes);
    }

    @Override
    protected <T> void writeSetOrList(int tag, Collection<T> col, ValueSerializer<T> serializer) throws IOException {
        byte[] bytes = BinaryValueWriter.writeWithWriter(e -> {
            for (Object t : col) {
                if (t == null) continue;
                serializer.write((Object)t, (ValueWriter)e);
            }
        });
        this.os.writeBytes(tag, bytes);
    }

    public static <T extends Message> byte[] write(T message, MessageSerializer<T> serializer) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputStream bos = new BinaryOutputStream(baos);
        BinaryMessageWriter bvw = new BinaryMessageWriter(bos);
        serializer.write(message, bvw);
        bvw.flush();
        return baos.toByteArray();
    }

    @Override
    protected void writeInt640(int tag, String name, long value) throws IOException {
    }
}

