/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary.compact;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Objects;
import net.maritimecloud.internal.message.binary.compact.Types;

public class BinaryOutputStream
extends Types {
    final OutputStream os;

    BinaryOutputStream(OutputStream os) {
        this.os = Objects.requireNonNull(os);
    }

    public BinaryOutputStream encodeAndWriteInteger(int tag, int value) throws IOException {
        switch (value) {
            case 0: {
                return this.writeTypeTag(0, tag);
            }
            case 1: {
                return this.writeTypeTag(1, tag);
            }
            case 2: {
                return this.writeTypeTag(2, tag);
            }
            case -1: {
                return this.writeTypeTag(3, tag);
            }
        }
        if (value > 0) {
            if (value <= 127) {
                return this.writeTypeTag(4, tag).write08Bits(value);
            }
            if (value <= Short.MAX_VALUE) {
                return this.writeTypeTag(5, tag).write16Bits(value);
            }
            if ((value & 0xFFE00000) == 0) {
                return this.writeTypeTag(9, tag).writeRawVarint32(value);
            }
        } else {
            if (value >= -128) {
                return this.writeTypeTag(4, tag).write08Bits(value);
            }
            if (value >= Short.MIN_VALUE) {
                return this.writeTypeTag(5, tag).write16Bits(value);
            }
            if ((value & 0xFFE00000) == 0) {
                return this.writeTypeTag(8, tag).writeRawVarint32Negative(value);
            }
        }
        return this.writeTypeTag(6, tag).write32Bits(value);
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public BinaryOutputStream write08Bits(int value) throws IOException {
        return this.writeRawByte(value & 0xFF);
    }

    public BinaryOutputStream write16Bits(int value) throws IOException {
        this.writeRawByte(value >> 8 & 0xFF);
        return this.writeRawByte(value & 0xFF);
    }

    public BinaryOutputStream write24Bits(int value) throws IOException {
        this.writeRawByte(value >> 16 & 0xFF);
        this.writeRawByte(value >> 8 & 0xFF);
        return this.writeRawByte(value & 0xFF);
    }

    public BinaryOutputStream write32Bits(int value) throws IOException {
        this.writeRawByte(value >> 24 & 0xFF);
        this.writeRawByte(value >> 16 & 0xFF);
        this.writeRawByte(value >> 8 & 0xFF);
        return this.writeRawByte(value & 0xFF);
    }

    public BinaryOutputStream write64Bits(long value) throws IOException {
        this.writeRawByte((int)(value >> 56) & 0xFF);
        this.writeRawByte((int)(value >> 48) & 0xFF);
        this.writeRawByte((int)(value >> 40) & 0xFF);
        this.writeRawByte((int)(value >> 32) & 0xFF);
        this.writeRawByte((int)(value >> 24) & 0xFF);
        this.writeRawByte((int)(value >> 16) & 0xFF);
        this.writeRawByte((int)(value >> 8) & 0xFF);
        return this.writeRawByte((int)value & 0xFF);
    }

    public void writeBigDecimal(BigDecimal value) throws IOException {
        this.writeRawVarint32(value.scale());
    }

    public BinaryOutputStream writeBoolean(int tag, String name, boolean value) throws IOException {
        return this.writeTypeTag(value ? 1 : 0, tag);
    }

    public void writeBytes(byte[] value) throws IOException {
        this.os.write(value);
    }

    public void writeBytes(int tag, byte[] value) throws IOException {
        if (value.length == 1) {
            this.encodeAndWriteInteger(tag, value[0]);
        } else if (value.length == 2) {
            this.writeTypeTag(5, tag).writeRawByte(value[0]).writeRawByte(value[1]);
        } else if (value.length == 4) {
            this.writeTypeTag(6, tag).writeRawByte(value[0]).writeRawByte(value[1]).writeRawByte(value[2]).writeRawByte(value[3]);
        } else if (value.length == 8) {
            this.writeTypeTag(7, tag).writeRawByte(value[0]).writeRawByte(value[1]).writeRawByte(value[2]).writeRawByte(value[3]).writeRawByte(value[4]).writeRawByte(value[5]).writeRawByte(value[6]).writeRawByte(value[7]);
        } else {
            this.writeTypeTag(10, tag);
            this.writeVarInt32Positive(value.length);
            this.os.write(value);
        }
    }

    public BinaryOutputStream writeLong(int tag, long value) {
        return this;
    }

    BinaryOutputStream writeRawByte(byte value) throws IOException {
        this.os.write(value);
        return this;
    }

    BinaryOutputStream writeRawByte(int value) throws IOException {
        this.writeRawByte((byte)value);
        return this;
    }

    BinaryOutputStream writeRawVarint32(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeRawByte(value);
                return this;
            }
            this.writeRawByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    BinaryOutputStream writeRawVarint32Negative(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeRawByte(value);
                return this;
            }
            this.writeRawByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    BinaryOutputStream writeRawVarint64(long value) throws IOException {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeRawByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        return this.writeRawByte((int)value);
    }

    BinaryOutputStream writeTypeTag(int wireType, int fieldNumber) throws IOException {
        if (fieldNumber <= 15) {
            this.writeRawByte(BinaryOutputStream.makeTag(wireType, fieldNumber));
        } else {
            this.writeRawByte(BinaryOutputStream.makeTag(wireType, 0));
            this.writeRawVarint32(fieldNumber);
        }
        return this;
    }

    void writeVarInt32(int value) {
    }

    void writeVarInt32Positive(int value) throws IOException {
        this.writeRawVarint32(value);
    }
}

