/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary.compact;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import net.maritimecloud.internal.message.binary.compact.TReader;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.util.Binary;

class TReaderConstant
extends TReader {
    private final int constant;
    static final TReaderConstant C0 = new TReaderConstant(0);
    static final TReaderConstant C1 = new TReaderConstant(1);
    static final TReaderConstant C2 = new TReaderConstant(2);
    static final TReaderConstant CM1 = new TReaderConstant(-1);

    TReaderConstant(int constant) {
        this.constant = constant;
    }

    @Override
    public Binary readBinary() throws IOException {
        return Binary.copyFrom((byte)this.constant);
    }

    @Override
    public BigDecimal readDecimal() throws IOException {
        return BigDecimal.valueOf(this.constant);
    }

    @Override
    public Integer readInt() throws IOException {
        return this.constant;
    }

    @Override
    public Long readInt64() throws IOException {
        return this.constant;
    }

    @Override
    public <T> List<T> readList(ValueSerializer<T> parser) throws IOException {
        T t = parser.read(this);
        return Collections.singletonList(t);
    }

    @Override
    public BigInteger readVarInt() throws IOException {
        return BigInteger.valueOf(this.constant);
    }

    static TReaderConstant fromWireType(int wireType) {
        switch (wireType) {
            case 0: {
                return C0;
            }
            case 1: {
                return C1;
            }
            case 2: {
                return C2;
            }
            case 3: {
                return CM1;
            }
        }
        throw new UnsupportedOperationException();
    }
}

