/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.binary.protobuf;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.maritimecloud.internal.core.com.google.protobuf.CodedInputStream;
import net.maritimecloud.internal.message.binary.AbstractBinaryValueReader;
import net.maritimecloud.internal.message.binary.protobuf.ProtobufMessageReader;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.util.Binary;

public class ProtobufValueReader
extends AbstractBinaryValueReader {
    CodedInputStream cis;
    Long value;

    ProtobufValueReader(CodedInputStream cis) {
        this.cis = Objects.requireNonNull(cis);
    }

    ProtobufValueReader(Long value) {
        this.value = Objects.requireNonNull(value);
    }

    private void checkFromInputStream() throws IOException {
        if (this.cis == null) {
            throw new IOException("The value reader is not based on a CodedInputStream");
        }
    }

    @Override
    public Binary readBinary() throws IOException {
        this.checkFromInputStream();
        byte[] a = this.cis.readByteArray();
        return Binary.copyFrom(a);
    }

    @Override
    public Integer readInt() throws IOException {
        if (this.value != null) {
            return this.value.intValue();
        }
        this.checkFromInputStream();
        return this.cis.readSInt32();
    }

    @Override
    public Long readInt64() throws IOException {
        if (this.value != null) {
            return this.value;
        }
        this.checkFromInputStream();
        return this.cis.readSInt64();
    }

    @Override
    public BigDecimal readDecimal() throws IOException {
        this.checkFromInputStream();
        byte[] b = this.readBinary().toByteArray();
        CodedInputStream bdis = CodedInputStream.newInstance(b);
        int scale = bdis.readSInt32();
        BigInteger unscaled = new BigInteger(bdis.readByteArray());
        return new BigDecimal(unscaled, scale);
    }

    @Override
    public <T extends Message> T readMessage(MessageSerializer<T> parser) throws IOException {
        this.checkFromInputStream();
        byte[] b = this.cis.readByteArray();
        CodedInputStream mis = CodedInputStream.newInstance(b);
        ProtobufMessageReader reader = new ProtobufMessageReader(mis);
        return parser.read(reader);
    }

    @Override
    public <T> List<T> readList(ValueSerializer<T> parser) throws IOException {
        this.checkFromInputStream();
        byte[] b = this.cis.readByteArray();
        CodedInputStream lis = CodedInputStream.newInstance(b);
        ArrayList<T> list = new ArrayList<T>();
        ProtobufValueReader r = new ProtobufValueReader(lis);
        while (!lis.isAtEnd()) {
            T t = parser.read(r);
            if (t == null) continue;
            list.add(t);
        }
        return list;
    }

    @Override
    public <K, V> Map<K, V> readMap(ValueSerializer<K> keyParser, ValueSerializer<V> valueParser) throws IOException {
        this.checkFromInputStream();
        byte[] b = this.cis.readByteArray();
        CodedInputStream mis = CodedInputStream.newInstance(b);
        HashMap<K, V> map = new HashMap<K, V>();
        ProtobufValueReader r = new ProtobufValueReader(mis);
        while (!mis.isAtEnd()) {
            K key = keyParser.read(r);
            V value = valueParser.read(r);
            if (key == null || value == null) continue;
            map.put(key, value);
        }
        return map;
    }
}

