/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.text;

import java.io.IOException;
import net.maritimecloud.message.MessageEnum;
import net.maritimecloud.message.MessageEnumSerializer;
import net.maritimecloud.message.MessageFormatType;
import net.maritimecloud.message.SerializationException;
import net.maritimecloud.message.ValueReader;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public abstract class AbstractTextValueReader
implements ValueReader {
    @Override
    public final MessageFormatType getFormatType() {
        return MessageFormatType.HUMAN_READABLE;
    }

    @Override
    public Binary readBinary() throws IOException {
        String str = this.readString();
        try {
            return Binary.copyFromBase64(str);
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException("The serialized string does not contain a valid based 64 encoded message");
        }
    }

    @Override
    public <T extends MessageEnum> T readEnum(MessageEnumSerializer<T> factory) throws IOException {
        String str = this.readString();
        T t = factory.from(str);
        if (t == null) {
            throw new SerializationException("The string '" + str + "' does not correspond to a valid enum");
        }
        return t;
    }

    @Override
    public Position readPosition() throws IOException {
        return this.readMessage(Position.SERIALIZER);
    }

    @Override
    public PositionTime readPositionTime() throws IOException {
        return this.readMessage(PositionTime.SERIALIZER);
    }

    protected abstract String readString() throws IOException;

    @Override
    public String readText() throws IOException {
        String str = this.readString();
        return this.unescape(str);
    }

    protected String unescape(String value) {
        return value;
    }
}

