/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.text;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import net.maritimecloud.internal.message.MessageHelper;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageEnum;
import net.maritimecloud.message.MessageFormatType;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.message.ValueWriter;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public abstract class AbstractTextValueWriter
implements ValueWriter {
    protected String escape(String value) {
        return value;
    }

    @Override
    public final MessageFormatType getFormatType() {
        return MessageFormatType.HUMAN_READABLE;
    }

    @Override
    public final void writeBinary(Binary binary) throws IOException {
        this.writeEscapedString(binary.base64encode());
    }

    @Override
    public final void writeDecimal(BigDecimal value) throws IOException {
        this.writeNumber(value.toString());
    }

    @Override
    public void writeDouble(Double value) throws IOException {
        this.writeNumber(Double.toString(MessageHelper.checkDouble(value)));
    }

    @Override
    public final void writeEnum(MessageEnum serializable) throws IOException {
        this.writeEscapedString(serializable.getName());
    }

    protected abstract void writeEscapedString(String var1) throws IOException;

    @Override
    public void writeFloat(Float value) throws IOException {
        this.writeNumber(Float.toString(MessageHelper.checkFloat(value.floatValue())));
    }

    @Override
    public final void writeInt(Integer value) throws IOException {
        this.writeNumber(value.toString());
    }

    @Override
    public final void writeInt64(Long value) throws IOException {
        this.writeNumber(value.toString());
    }

    @Override
    public <K, V> void writeMap(Map<K, V> map, ValueSerializer<K> keySerializer, ValueSerializer<V> valueSerializer) throws IOException {
    }

    @Override
    public <T extends Message> void writeMessage(T message, MessageSerializer<T> serializer) throws IOException {
    }

    protected abstract void writeNumber(String var1) throws IOException;

    @Override
    public void writePosition(Position value) throws IOException {
        this.writeMessage(value, Position.SERIALIZER);
    }

    @Override
    public void writePositionTime(PositionTime value) throws IOException {
        this.writeMessage(value, PositionTime.SERIALIZER);
    }

    @Override
    public final void writeText(String value) throws IOException {
        Objects.requireNonNull(value, "value is null");
        this.writeEscapedString(this.escape(value));
    }

    @Override
    public final void writeVarInt(BigInteger value) throws IOException {
        this.writeNumber(value.toString());
    }
}

