/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.message.text.json;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.maritimecloud.internal.message.TaggableMessageWriter;
import net.maritimecloud.internal.message.TaggableValueWriter;
import net.maritimecloud.internal.message.text.AbstractTextValueWriter;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.message.ValueSerializer;

public class JsonValueWriter
extends AbstractTextValueWriter
implements TaggableValueWriter,
Closeable {
    static final String LS = "\n";
    private int indent;
    private boolean isFirst = true;
    private final Writer pw;
    private final MessageWriter w = new TaggableMessageWriter(this);

    public JsonValueWriter(Writer w) {
        this(w, 0);
    }

    public JsonValueWriter(Writer w, int indent) {
        this.pw = Objects.requireNonNull(w);
        this.indent = indent;
    }

    @Override
    public void close() throws IOException {
        this.pw.close();
    }

    @Override
    protected String escape(String string) {
        StringBuilder sb = new StringBuilder();
        int len = string.length();
        block10: for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private void indent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.pw.append("  ");
        }
    }

    @Override
    public void writeBoolean(Boolean value) throws IOException {
        this.pw.write(value.toString());
    }

    @Override
    protected void writeEscapedString(String value) throws IOException {
        this.pw.append("\"").append(value).append("\"");
    }

    @Override
    public <T> void writeList(List<T> list, ValueSerializer<T> serializer) throws IOException {
        this.pw.write("[");
        ++this.indent;
        boolean isFirst = true;
        for (T o : list) {
            if (!isFirst) {
                this.pw.write(",");
            }
            this.pw.write(LS);
            this.indent();
            serializer.write(o, this);
            isFirst = false;
        }
        this.pw.write(LS);
        --this.indent;
        this.indent();
        this.pw.append("]");
    }

    @Override
    public <K, V> void writeMap(Map<K, V> map, ValueSerializer<K> keySerializer, ValueSerializer<V> valueSerializer) throws IOException {
        this.pw.write("{}");
    }

    @Override
    public <T extends Message> void writeMessage(T message, MessageSerializer<T> serializer) throws IOException {
        if (message != null) {
            this.pw.write("{");
            ++this.indent;
            boolean isFirst = this.isFirst;
            this.isFirst = true;
            serializer.write(message, this.w);
            this.isFirst = isFirst;
            --this.indent;
            this.pw.write(LS);
            this.indent();
            this.pw.write("}");
        }
    }

    @Override
    protected void writeNumber(String value) throws IOException {
        this.pw.write(value);
    }

    @Override
    public JsonValueWriter writeTag(int tag, String name) throws IOException {
        if (!this.isFirst) {
            this.pw.write(",");
        }
        this.isFirst = false;
        this.pw.write(LS);
        this.indent();
        this.pw.write("\"" + name + "\": ");
        return this;
    }

    public static <T extends Message> String writeMessageTo(int indent, T message, MessageSerializer<T> serializer) throws IOException {
        StringWriter sw = new StringWriter();
        try (JsonValueWriter jvv = new JsonValueWriter(sw, indent);){
            jvv.writeMessage(message, serializer);
        }
        return sw.toString();
    }

    public static <T> String writeValueTo(int indent, T message, ValueSerializer<T> serializer) throws IOException {
        StringWriter sw = new StringWriter();
        try (JsonValueWriter jvv = new JsonValueWriter(sw, indent);){
            serializer.write(message, jvv);
        }
        return sw.toString();
    }
}

